/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.cs.scivizmaster.impl;

import edu.uwyo.cs.scivizmaster.factory.stubs.CreateResource;
import edu.uwyo.cs.scivizmaster.factory.stubs.CreateResourceResponse;
import edu.uwyo.cs.scivizmaster.factory.stubs.GenerateResource;
import edu.uwyo.cs.scivizmaster.factory.stubs.GenerateResourceResponse;
import edu.uwyo.cs.scivizmaster.impl.SciVizMasterResourceHome;
import java.net.URL;
import java.rmi.RemoteException;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.globus.wsrf.NoResourceHomeException;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceContextException;
import org.globus.wsrf.ResourceHome;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.container.ServiceHost;
import org.globus.wsrf.utils.AddressingUtils;

public class SciVizMasterFactoryService {
    public CreateResourceResponse createResource(CreateResource request) throws RemoteException {
        SciVizMasterResourceHome home = null;
        ResourceKey key = null;
        try {
            home = (SciVizMasterResourceHome)this.getInstanceResourceHome();
            key = home.create(request.getResID());
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
        EndpointReferenceType epr = null;
        try {
            URL baseURL = ServiceHost.getBaseURL();
            String instanceService = home.getInstanceServicePath();
            String instanceURI = baseURL.toString() + instanceService;
            System.out.println("FACTORY: " + instanceURI);
            epr = AddressingUtils.createEndpointReference((String)instanceURI, (ResourceKey)key);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
        CreateResourceResponse response = new CreateResourceResponse();
        response.setEndpointReference(epr);
        return response;
    }

    public GenerateResourceResponse generateResource(GenerateResource request) throws RemoteException {
        SciVizMasterResourceHome home = null;
        ResourceKey key = null;
        try {
            home = (SciVizMasterResourceHome)this.getInstanceResourceHome();
            key = home.genKey(request.getResID());
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
        EndpointReferenceType epr = null;
        try {
            URL baseURL = ServiceHost.getBaseURL();
            String instanceService = home.getInstanceServicePath();
            String instanceURI = baseURL.toString() + instanceService;
            System.out.println("FACTORY: " + instanceURI);
            epr = AddressingUtils.createEndpointReference((String)instanceURI, (ResourceKey)key);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
        GenerateResourceResponse response = new GenerateResourceResponse();
        response.setEndpointReference(epr);
        return response;
    }

    protected ResourceHome getInstanceResourceHome() throws NoResourceHomeException, ResourceContextException {
        ResourceHome home;
        ResourceContext ctx = ResourceContext.getResourceContext();
        String homeLoc = "java:comp/env//services/" + ctx.getService() + "/instanceHome";
        try {
            InitialContext initialContext = new InitialContext();
            home = (ResourceHome)initialContext.lookup(homeLoc);
        }
        catch (NameNotFoundException e) {
            throw new NoResourceHomeException();
        }
        catch (NamingException e) {
            throw new ResourceContextException("", (Throwable)e);
        }
        return home;
    }
}

