package edu.uwyo.cs.cell.impl;

import java.net.*;
import java.rmi.*;

import javax.naming.*;

import org.apache.axis.message.addressing.*;
import org.globus.wsrf.*;
import org.globus.wsrf.container.*;
import org.globus.wsrf.utils.*;

import edu.uwyo.cs.cell.factory.stubs.*;

public class CellFactoryService {

    public CreateResourceResponse createResource(CreateResource request)
	throws RemoteException {

	CellResourceHome home = null;
	ResourceKey key = null;

	try {
	    home = (CellResourceHome) getInstanceResourceHome();
	    key = home.create();
	} catch (Exception e) {
	    throw new RemoteException(e.getMessage(), e);
	}

	EndpointReferenceType epr = null;
	try {
	    URL baseURL = ServiceHost.getBaseURL();
	    String instanceService = home.getInstanceServicePath();
	    String instanceURI = baseURL.toString() + instanceService;
	    epr = AddressingUtils.createEndpointReference(instanceURI, key);
	} catch (Exception e) {
	    throw new RemoteException(e.getMessage(), e);
	}

	CreateResourceResponse response = new CreateResourceResponse();
	response.setEndpointReference(epr);
	return response;
    }

    protected ResourceHome getInstanceResourceHome()
	throws NoResourceHomeException, ResourceContextException {
	ResourceHome home;
	ResourceContext ctx;

	ctx = ResourceContext.getResourceContext();
	String homeLoc = org.globus.wsrf.Constants.JNDI_SERVICES_BASE_NAME + ctx.getService()
	    + "/instanceHome";
	try {
	    Context initialContext = new InitialContext();
	    home = (ResourceHome) initialContext.lookup(homeLoc);
	} catch (NameNotFoundException e) {
	    throw new NoResourceHomeException();
	} catch (NamingException e) {
	    throw new ResourceContextException("", e);
	}

	return home;
    }
}
