package edu.uwyo.cs.cell.impl;

import java.util.*;

import org.apache.commons.logging.*;

import org.apache.axis.components.uuid.*;
import org.apache.axis.message.addressing.*;

import org.globus.wsrf.*;
import org.globus.wsrf.impl.*;

public class CellResource implements Resource, ResourceIdentifier,
				     ResourceProperties, ResourceLifetime,
				     TopicListAccessor {

    static final Log logger = LogFactory.getLog (CellResource.class);

    private static final UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();

    private ResourcePropertySet propSet;

    private TopicList topicList;
    private SimpleTopic finishedTopic;

    private Calendar terminationTime;

    private Object key;

    private int position;
    private int value;
    private int leftValue;
    private int prevLeftValue;
    private int rightValue;
    private int prevRightValue;
    private boolean leftIsSet;
    private boolean rightIsSet;
    private boolean prevLeftIsSet;
    private boolean prevRightIsSet;
    private int numSteps;
    private EndpointReferenceType leftCellEPR;
    private EndpointReferenceType rightCellEPR;

    public Object initialize() throws Exception {
	key = uuidGen.nextUUID();
	logger.trace ("Initializing CellResource: " + key);

	propSet = new SimpleResourcePropertySet(CellConstants.RESOURCE_PROPERTIES);

	ResourceProperty positionRP = new ReflectionResourceProperty(CellConstants.RP_POSITION, "Position", this);
	this.propSet.add(positionRP);
	setPosition(0);

	ResourceProperty valueRP = new ReflectionResourceProperty(CellConstants.RP_VALUE, "Value", this);
	this.propSet.add(valueRP);
	setValue(0);

	ResourceProperty leftValueRP = new ReflectionResourceProperty(CellConstants.RP_LEFT_VALUE, "LeftValue", this);
	this.propSet.add(leftValueRP);
	setLeftValue(0);

	ResourceProperty rightValueRP = new ReflectionResourceProperty(CellConstants.RP_RIGHT_VALUE, "RightValue", this);
	this.propSet.add(rightValueRP);
	setRightValue(0);

	ResourceProperty prevLeftValueRP = new ReflectionResourceProperty(CellConstants.RP_PREV_LEFT_VALUE, "PrevLeftValue", this);
	this.propSet.add(prevLeftValueRP);
	setPrevLeftValue(0);

	ResourceProperty prevRightValueRP = new ReflectionResourceProperty(CellConstants.RP_PREV_RIGHT_VALUE, "PrevRightValue", this);
	this.propSet.add(prevRightValueRP);
	setPrevRightValue(0);

	ResourceProperty leftIsSetRP = new ReflectionResourceProperty(CellConstants.RP_LEFT_IS_SET, "LeftIsSet", this);
	this.propSet.add(leftIsSetRP);
	setLeftIsSet(false);

	ResourceProperty rightIsSetRP = new ReflectionResourceProperty(CellConstants.RP_RIGHT_IS_SET, "RightIsSet", this);
	this.propSet.add(rightIsSetRP);
	setRightIsSet(false);

	ResourceProperty prevLeftIsSetRP = new ReflectionResourceProperty(CellConstants.RP_PREV_LEFT_IS_SET, "PrevLeftIsSet", this);
	this.propSet.add(prevLeftIsSetRP);
	setPrevLeftIsSet(false);

	ResourceProperty prevRightIsSetRP = new ReflectionResourceProperty(CellConstants.RP_PREV_RIGHT_IS_SET, "PrevRightIsSet", this);
	this.propSet.add(prevRightIsSetRP);
	setPrevRightIsSet(false);

	ResourceProperty numStepsRP = new ReflectionResourceProperty(CellConstants.RP_NUM_STEPS, "NumSteps", this);
	this.propSet.add(numStepsRP);
	setNumSteps(-1);

	ResourceProperty leftCellEPRRP = new ReflectionResourceProperty(CellConstants.RP_LEFT_CELL_EPR, "LeftCellEPR", this);
	this.propSet.add(leftCellEPRRP);
	setLeftCellEPR(null);

	ResourceProperty rightCellEPRRP = new ReflectionResourceProperty(CellConstants.RP_RIGHT_CELL_EPR, "RightCellEPR", this);
	this.propSet.add(rightCellEPRRP);
	setRightCellEPR(null);

	ResourceProperty termTimeRP = new ReflectionResourceProperty(SimpleResourcePropertyMetaData.TERMINATION_TIME, this);
	this.propSet.add(termTimeRP);

	ResourceProperty currTimeRP = new ReflectionResourceProperty(SimpleResourcePropertyMetaData.CURRENT_TIME, this);
	this.propSet.add(currTimeRP);

	topicList = new SimpleTopicList (this);
	finishedTopic = new SimpleTopic (CellConstants.TOPIC_FINISHED);
	topicList.addTopic (finishedTopic);

	return key;
    }

    public int getPosition() {
	return position;
    }

    public synchronized void setPosition(int newPosition) {
	position = newPosition;
    }

    public int getValue() {
	return value;
    }

    public synchronized void setValue(int newValue) {
	value = newValue;
    }

    public int getLeftValue() {
	return leftValue;
    }

    public synchronized void setLeftValue(int newLeftValue) {
	leftValue = newLeftValue;
    }

    public int getRightValue() {
	return rightValue;
    }

    public synchronized void setRightValue(int newRightValue) {
	rightValue = newRightValue;
    }

    public int getPrevLeftValue() {
	return prevLeftValue;
    }

    public synchronized void setPrevLeftValue(int newPrevLeftValue) {
	prevLeftValue = newPrevLeftValue;
    }

    public int getPrevRightValue() {
	return prevRightValue;
    }

    public synchronized void setPrevRightValue(int newPrevRightValue) {
	prevRightValue = newPrevRightValue;
    }

    public boolean getLeftIsSet() {
	return leftIsSet;
    }

    public synchronized void setLeftIsSet(boolean newLeftIsSet) {
	leftIsSet = newLeftIsSet;
    }

    public boolean getRightIsSet() {
	return rightIsSet;
    }

    public synchronized void setRightIsSet(boolean newRightIsSet) {
	rightIsSet = newRightIsSet;
    }

    public boolean getPrevLeftIsSet() {
	return prevLeftIsSet;
    }

    public synchronized void setPrevLeftIsSet(boolean newPrevLeftIsSet) {
	prevLeftIsSet = newPrevLeftIsSet;
    }

    public boolean getPrevRightIsSet() {
	return prevRightIsSet;
    }

    public synchronized void setPrevRightIsSet(boolean newPrevRightIsSet) {
	prevRightIsSet = newPrevRightIsSet;
    }

    public int getNumSteps() {
	return numSteps;
    }

    public synchronized void setNumSteps(int newNumSteps) {
	numSteps = newNumSteps;
    }

    public EndpointReferenceType getLeftCellEPR () {
	return leftCellEPR;
    }

    public synchronized void setLeftCellEPR (EndpointReferenceType newLeftCellEPR) {
	leftCellEPR = newLeftCellEPR;
    }

    public EndpointReferenceType getRightCellEPR () {
	return rightCellEPR;
    }

    public synchronized void setRightCellEPR (EndpointReferenceType newRightCellEPR) {
	rightCellEPR = newRightCellEPR;
    }

    public synchronized void sendFinishedNotification () {
    }

    public SimpleTopic getFinishedTopic () {
	return finishedTopic;
    }

    public ResourcePropertySet getResourcePropertySet() {
	return this.propSet;
    }

    public Calendar getCurrentTime() {
	return Calendar.getInstance ();
    }

    public Calendar getTerminationTime () {
	return terminationTime;
    }

    public void setTerminationTime (Calendar newTerminationTime) {
	terminationTime = newTerminationTime;
    }

    public Object getID() {
	return this.key;
    }

    public TopicList getTopicList () {
	return topicList;
    }
}
