package edu.uwyo.cs.expavg.client;

import org.apache.axis.message.addressing.*;

import edu.uwyo.cs.expavg.stubs.*;
import edu.uwyo.cs.expavg.stubs.service.*;

public class ExpAvgClient {
    private static final String serviceURIPostfix = ":8080/wsrf/services/ExpAvgService";

    public static void main (String[] args) {
	String serviceURI = "http://localhost" + serviceURIPostfix;

	if (args.length > 0)
	    serviceURI = "http://" + args[0] + serviceURIPostfix;

	System.out.println ("Contacting service: " + serviceURI);

	ExpAvgServiceAddressingLocator locator = new ExpAvgServiceAddressingLocator ();

	try {
	    EndpointReferenceType endpoint = new EndpointReferenceType ();
	    endpoint.setAddress (new Address (serviceURI));
	    ExpAvgPortType expavg = locator.getExpAvgPortTypePort (endpoint);
	    
	    for (int i=0; i<10; i++) {
		float val = expavg.addValue (i);
		System.out.println ("Current value: " + val);
	    }
	}
	catch (Exception e) {
	    e.printStackTrace ();
	}
    }
}
