package edu.uwyo.cs.expavg.impl;

import java.rmi.RemoteException;
import javax.xml.namespace.*;

import org.globus.wsrf.*;
import org.globus.wsrf.impl.*;

public class ExpAvgService implements Resource, ResourceProperties  {
    public static final String NS = "http://www.cs.uwyo.edu/namespaces/ExpAvgService";
    public static final QName RP_VALUE = new QName (NS, "Value");
    public static final QName RP_WEIGHT = new QName (NS, "Weight");
    public static final QName RESOURCE_PROPERTIES = new QName (NS, "ExpAvgResourceProperties");

    private ResourcePropertySet propSet;

    private float value;
    private float weight;

    public ExpAvgService () throws RemoteException {
	propSet = new SimpleResourcePropertySet (RESOURCE_PROPERTIES);
	try {
	    ResourceProperty valueRP = new ReflectionResourceProperty (RP_VALUE, "Value", this);
	    ResourceProperty weightRP = new ReflectionResourceProperty (RP_WEIGHT, "Weight", this);
	    propSet.add (valueRP);
	    setValue (0);
	    propSet.add (weightRP);
	    setWeight ((float)0.5);
	}
	catch (Exception e) {
	    throw new RemoteException (e.getMessage(), e);
	}
    }

    public float getValue () {
	return value;
    }

    public synchronized void setValue (float newValue) {
	value = newValue;
    }

    public float getWeight () {
	return weight;
    }

    public synchronized void setWeight (float newWeight) {
	weight = newWeight;
    }

    public synchronized float addValue (float newValue) {
	value = weight * newValue + (1 - weight) * value;
	return value;
    }

    public ResourcePropertySet getResourcePropertySet() {
	return propSet;
    }


}
