/* This is the running task */

package edu.uwyo.cs.scivizmaster.client;

import java.io.*;
import java.lang.InterruptedException;

public class ActualTask
{
	private SciVizMasterClient client;
	ActualTask(Task task,String num,String ang,String out,String dt,
		   String ts,String dout,String mode,String iwidth,
		   String iheight,String master,String factory,String gftp,
		   String resid)
	{
		System.out.println("Actual Task start");
		client = new SciVizMasterClient();
		Process child = null;
		// Execute Treecode
		task.setStatMsg("Executing Treecode.");
		String value = System.getenv("TREECODE_LOCATION");
		String tree = value + "treecode nbody=" + num +
			" theta=" + ang + " dtime=" + dt + " dtout=" + dout +
			" tstop=" + ts + " out=" + out;
		try {
			child = Runtime.getRuntime().exec(tree);
			child.waitFor();
			BufferedReader in = new BufferedReader(new InputStreamReader(child.getErrorStream()));
			for(String line = in.readLine();line!=null;line=in.readLine())
				System.out.println(line);
			child.getInputStream().close();
			child.getOutputStream().close();
			child.getErrorStream().close();
		} catch (IOException e) {
			System.out.println("Treecode execution failed");
			return;
		} catch (InterruptedException e) {
			System.out.println("Treecode Interrupted");
			return;
		}
		// Upload Iters
		String[] args = {master,factory,gftp,out,num,mode,iwidth,iheight,resid};
		task.setStatMsg("Uploading Iters.");
		int ni = client.initialize(args);
		task.setLength(ni);
		while(!task.isCanceled() && !task.isDone())
		{
			try{
				// Contact service
				System.out.println("STARTING SLEEP\n");
				Thread.sleep(500);
			//	task.incCurrent();
				int n = client.getNRemaining();
				System.out.println("REMAINING: " + n);
				task.setCurrent(task.getLength()-n);
				if(task.getCurrent() >= task.getLength())
				{
					task.setDone();
				}
				System.out.println(task.getCurrent()+"\n");
				task.setStatMsg("Completed " + task.getCurrent() +
					" out of " + task.getLength() + ".");
			} catch (InterruptedException e) {
				System.out.println("ActualTask Interrupted\n");
			}
		}
		// Check files
		while(!check(ni)) {}
		String convert = "convert -delay 3 /tmp/Iter*.png ./out.mng";
		String display = "display ./out.mng";
		try {
			child = Runtime.getRuntime().exec(convert);
			child.waitFor();
			BufferedReader in = new BufferedReader(new InputStreamReader(child.getErrorStream()));
			for(String line = in.readLine();line!=null;line=in.readLine())
				System.out.println(line);
			child = Runtime.getRuntime().exec(display);
			child.waitFor();
			BufferedReader ig = new BufferedReader(new InputStreamReader(child.getErrorStream()));
			for(String ln = ig.readLine();ln!=null;ln=ig.readLine())
				System.out.println(ln);
			child.getInputStream().close();
			child.getOutputStream().close();
			child.getErrorStream().close();
		} catch (IOException e) {
			System.out.println("MNG construction or display execution failed");
			return;
		} catch (InterruptedException e) {
			System.out.println("MNG construction or display Interrupted");
			return;
		}
		System.out.println("Actual Task End");
	}

	private boolean check(int n)
	{
		boolean tmp = true;
		for(int i = 0; i < n && tmp == true; i++)
		{
			File f = new File("/tmp/Iter" + i + ".png");
			if(!f.exists())
				tmp = false;
		}
		return tmp;
	}
};
