package edu.uwyo.cs.scivizmaster.client;

import edu.uwyo.cs.scivizmaster.impl.*;
import edu.uwyo.cs.scivizmaster.stubs.*;
import edu.uwyo.cs.scivizmaster.stubs.service.*;

import java.io.*;
import java.util.*;
import java.lang.*;

public class FileHandler {
	public IterType getNextIter(int nb, BufferedReader in) throws IOException
	{
		int body = 0;
		String str;
		System.out.println("STARTING");
		/* Read the initial vals for the iter */
		str = in.readLine();
		System.out.println("FIRST LINE READ:" + str + "TODD");
		if(str == null)
			return null;
		in.readLine();
		in.readLine();
		System.out.println("INIT ITERTYPE");
		IterType iter = new IterType();
        iter.setMaxmass(-1);
        iter.setMinmass(1000000);
        iter.setMaxvel(-1);
        iter.setMinvel(1000000);
		/* Read Mass values until a Position line is seen */
		str = in.readLine();
		BodyType[] bodies = new BodyType[nb];
		String[] result = str.split("\\s");
		result = removeSpaceTokens(result);
		for(int t = 0; t < result.length; t++)
			System.out.println(result[t]);
		while(body < nb)
		{
			bodies[body] = new BodyType();
			bodies[body].setNbody(body);
			bodies[body].setMass(Float.valueOf(result[3]).floatValue());
            // Update the mins and maxes
            if((bodies[body].getMass()*100) > iter.getMaxmass())
            {
                iter.setMaxmass(bodies[body].getMass()*100);
            }
            else if((bodies[body].getMass()*100) < iter.getMinmass())
            {
                iter.setMinmass(bodies[body].getMass()*100);
            }
			body++;
			str = in.readLine();
			result = str.split("\\s");
			result = removeSpaceTokens(result);
		}
		body = 0;
		System.out.println("MASSES COMPLETE");
		/* Get the position vectors */
		while(body < nb)
		{
			bodies[body].setPosx(Float.valueOf(result[4]).floatValue());
			bodies[body].setPosy(Float.valueOf(result[5]).floatValue());
			bodies[body].setPosz(Float.valueOf(result[6]).floatValue());
			body++;
			str = in.readLine();
			result = str.split("\\s");
			result = removeSpaceTokens(result);
		}
		body = 0;
		System.out.println("POSSES COMPLETE");
		/* Get the velocity vectors */
		while(body < nb)
		{
			bodies[body].setVelx(Float.valueOf(result[4]).floatValue());
			bodies[body].setVely(Float.valueOf(result[5]).floatValue());
			bodies[body].setVelz(Float.valueOf(result[6]).floatValue());
            // update the mins and maxes
            float val = ((bodies[body].getVelx()*100)*(bodies[body].getVelx()*100)) +
                        ((bodies[body].getVely()*100)*(bodies[body].getVely()*100)) +
                        ((bodies[body].getVelz()*100)*(bodies[body].getVelz()*100));
            if(val > iter.getMaxvel())
            {
                iter.setMaxvel(val);
            }
            else if(val < iter.getMinvel())
            {
                iter.setMinvel(val);
            }
			body++;
			if(body != nb)
			{
				str = in.readLine();
				result = str.split("\\s");
				result = removeSpaceTokens(result);
			}
		}
		System.out.println("VELS COMPLETE");
		iter.setNbodies(body);
		iter.setBodies(bodies);
		return iter;
	}

	private String[] removeSpaceTokens(String[] result) {
//		for(int t = 0; t < result.length; t++)
//			System.out.println("VAL: " + result[t]);
		int size = result.length;
		int i = 0;
		while (i < size)
		{
			if(result[i].equals(" "))
			{
				int j = i;
				for(j = i; j < size-1; j++)
					result[j] = result[j+1];
				size--;
			}
			else if(result[i].equals(""))
			{
				int j = i;
				for(j = i; j < size-1; j++)
					result[j] = result[j+1];
				size--;
			}
			else
			{
				i++;
			}
		}
		String[] res = new String[size];
		for(i = 0; i < size; i++)
			res[i] = result[i];
//		for(int l = 0; l < res.length; l++)
//			System.out.println("CHANGED: " + res[l]);
		return res;
	}
}

