/* This class handles the progress bar dialog */
package edu.uwyo.cs.scivizmaster.client;

import javax.swing.*;
import javax.swing.BorderFactory; 
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.border.EtchedBorder;
import java.awt.*;
import java.awt.event.*;

public class ProgressDialog
{
	private JProgressBar progBar;
	private JLabel actionMsg;
	private Task task;
	private JFrame frame;
	private int numImgs;
	private Timer timer;

	public ProgressDialog(String num, String ang, String out, String dt,
			String ts, String dout, String mode, String iwidth,
			String iheight, String master, String factory,
			String gftp, String resid)
	{
		FractionParser fp = new FractionParser();
		double val = fp.convert(ts);
		double val2 = fp.convert(dout);
		val = val / val2;
		val = val + 1.0;
		Double dbl = new Double(val);
		numImgs = dbl.intValue();
		System.out.println("CONSTRUCT PROGRESS, STARTING TASK WITH " + numImgs + " imgs \n");
		task = new Task(num);

		createAndShowGUI();

//		Create a timer.
        timer = new Timer(100, new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                progBar.setValue(task.getCurrent());
                String s = task.getMessage();
                if (s != null) {
                	frame.setTitle(s);
                }
                if (task.isDone()) {
                    timer.stop();
                    progBar.setValue(progBar.getMaximum());
		    frame.setVisible(false);
                }
            }
        });
		
	task.go(num,ang,out,dt,ts,dout,mode,iwidth,iheight,master,factory,gftp,resid);
        timer.start();
	}

	private void create_components()
	{
		JPanel panel = new JPanel();
		panel.setLayout(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();
		JLabel action = new JLabel("Monitoring");
		c.gridx = 0;
		c.gridx = 0;
		panel.add(action,c);
		actionMsg = new JLabel("Progress");
		c.gridx = 1;
		panel.add(actionMsg,c);
		progBar = new JProgressBar(0, numImgs);
		progBar.setValue(0);
		progBar.setStringPainted(true);
		c.insets = new Insets(5,20,5,8); 
		c.gridx = 2;
		panel.add(progBar,c);

		frame.getContentPane().add(panel);
	}

	private void createAndShowGUI()
	{
		frame = new JFrame("Progress");

		create_components();
		
		Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
		frame.setLocation((screenDim.width / 2)-100,
			(screenDim.height / 2)-(int)(frame.getPreferredSize().getHeight()/2) + 150);

		frame.setSize(200,(int)(frame.getPreferredSize().getHeight()));
		frame.pack();
		frame.setVisible(true);
	}
};
