package edu.uwyo.cs.scivizmaster.client;

import java.util.*;
import java.io.*;
import java.rmi.*;

import org.apache.commons.logging.*;

import org.apache.axis.message.addressing.*;

import org.globus.wsrf.*;
import org.globus.wsrf.core.notification.*;
import org.globus.wsrf.core.notification.service.*;
import org.oasis.wsn.*;
import org.oasis.wsrf.lifetime.*;

import edu.uwyo.cs.scivizmaster.impl.*;
import edu.uwyo.cs.scivizmaster.stubs.*;
import edu.uwyo.cs.scivizmaster.stubs.service.*;
import edu.uwyo.cs.scivizmaster.factory.stubs.*;
import edu.uwyo.cs.scivizmaster.factory.stubs.service.*;

public class SciVizMasterClient implements NotifyCallback {
    static final Log logger = LogFactory.getLog (SciVizMasterClient.class);

    private static final String serviceURIPostfix = ":8080/wsrf/services/SciVizMasterService";
    private static final String factoryURIPostfix = ":8080/wsrf/services/SciVizMasterFactoryService";

    private ServiceInfo service;
    private int nBodies;
    private int mode;
    private int iwidth;
    private int iheight;
    private String serviceURL;
    private String factoryURL;
    private String infile;

    private boolean done = false;

    NotificationConsumerManager consumer;
    
    //public static void main (String[] args) {
//	   SciVizMasterClient client = new SciVizMasterClient ();
//
//	   client.initialize (args);
  //  }

    public int initialize (String[] args) {
	   String factoryURI;
	   String resID;
	   String gftpHost;
	   switch (args.length) {
	   default:
	       System.out.println ("Usage: SciVizMasterClient [ Master Service URL ] [ Factory Service URL ] [ GridFTP Server Address ] [ Treecode output file ] [ numbodies ] [ mode ] [ image width ] [ image height ] [ resid ]");
	       return -1;
	   case 9:
               serviceURL = args[0];
	       factoryURL = args[1];
	       gftpHost = args[2];
	       infile = args[3];
	       nBodies = Integer.valueOf(args[4]).intValue();
	       System.out.println("NUMBODIES: " + nBodies);
           mode = Integer.valueOf(args[5]).intValue();
	       iwidth = Integer.valueOf(args[6]).intValue();
	       iheight = Integer.valueOf(args[7]).intValue();
	       resID = args[8];
	       break;
	   }

        factoryURI = factoryURL + factoryURIPostfix;

	   service = new ServiceInfo();
 	   int ni = 0;

	   try {
	       SciVizFactoryServiceAddressingLocator factoryLocator = new SciVizFactoryServiceAddressingLocator ();
	       SciVizMasterJavaServiceAddressingLocator serviceLocator = new SciVizMasterJavaServiceAddressingLocator ();

	       EndpointReferenceType factoryEndpoint = new EndpointReferenceType ();
	       factoryEndpoint.setAddress (new Address (factoryURI));
	       FactoryPortType scivizFactory = factoryLocator.getFactoryPortTypePort (factoryEndpoint);

		  logger.info ("Creating Master service instance:\n");
		  CreateResource cr = new CreateResource();
		  cr.setResID(resID);
		  CreateResourceResponse createResponse = scivizFactory.createResource (cr);
		  service.endpoint = createResponse.getEndpointReference ();
		  service.port = serviceLocator.getMasterServicePortTypePort (service.endpoint);

		  logger.info ("Starting service:\n");
		  // init the file reader
		  FileHandler fh = new FileHandler();
		  try {
		  	BufferedReader in = new BufferedReader(new FileReader(infile));
			SetGftpServer gs = new SetGftpServer();
			gs.setDest(gftpHost);
			service.port.setGftpServer(gs);
		  	IterType i = fh.getNextIter(nBodies, in);
			i.setIter(ni);
			i.setMode(mode);
			i.setIwidth(iwidth);
			i.setIheight(iheight);
			AddIterData id = new AddIterData();
			id.setIdata(i);
			service.port.addIterData(id);
			ni++;
		  	while(i != null)
		  	{
				// Add the iter
				id = new AddIterData();
				i = fh.getNextIter(nBodies, in);
				if(i != null)
				{
					i.setIter(ni);
					i.setMode(mode);
					i.setIwidth(iwidth);
					i.setIheight(iheight);
					id.setIdata(i);
					service.port.addIterData(id);
					ni++;
				}
			}
			in.close();
		  } catch (IOException e) {
			  e.printStackTrace();
		  }

	      //while (!done)
	      //   Thread.sleep (5000);
	      //System.out.println ("Exiting!");
	   }
	   catch (Exception e) {
	       e.printStackTrace ();
	   }
	   return ni;
    }

    public int getNRemaining()
    {
	    try {
	    	GetNIterRemainingResponse n = service.port.getNIterRemaining(new GetNIterRemaining());
		return n.getNiters();
	    } catch (Exception e) {
		    return -1;
	    }
    }

    private void setupNotification () {
/*	try {
	    consumer = NotificationConsumerManager.getInstance();
	    consumer.startListening();
	    EndpointReferenceType consumerEPR = consumer
		.createNotificationConsumer(this);

	    Subscribe request = new Subscribe();

	    request.setUseNotify(Boolean.TRUE);
	    request.setConsumerReference(consumerEPR);

	    TopicExpressionType topicExpression = new TopicExpressionType();
	    topicExpression.setDialect(WSNConstants.SIMPLE_TOPIC_DIALECT);
	    topicExpression.setValue(CellConstants.TOPIC_FINISHED);
	    request.setTopicExpression(topicExpression);

	    WSBaseNotificationServiceAddressingLocator notifLocator = new WSBaseNotificationServiceAddressingLocator();

	    for (int i=0; i<NUM_CELLS; i++) {
		System.out.println ("Registering with port: " + i);
		NotificationProducer producerPort = notifLocator
		    .getNotificationProducerPort(cell[i].endpoint);
		producerPort.subscribe(request);
	    }
	}
	catch (Exception e) {
	    e.printStackTrace();
	}*/
    }

    public void deliver (List topicPath, EndpointReferenceType producer, Object message) {
/*	try {
	    FinishedNotificationMessageWrapperType wrp =
		(FinishedNotificationMessageWrapperType) message;
	    FinishedNotificationMessageType fini = wrp.getFinishedNotificationMessage();
	    int pos = fini.getPosition ();
	    int value = fini.getValue ();
	    cell[pos].value = value;
	    System.out.println ("Callback: pos=" + pos + " value=" + value);
	}
	catch (Exception e) {
	    e.printStackTrace();
	}*/
    }

    public synchronized void finishProcessing () {
	try {
	    if ((service.port.getNIterRemaining(new GetNIterRemaining())).getNiters() > 0)
		return;

	    //print_cells ();
	    System.out.println ("Finished!");

/*	    for (int i=0; i<NUM_CELLS; i++)
		cell[i].cell.destroy (new Destroy());

	    consumer.stopListening ();*/

	    done = true;
	}
	catch (Exception e) {
	    e.printStackTrace();
	}
    }

    private synchronized void addIters() {
    }

    private static class ServiceInfo {
	    public EndpointReferenceType endpoint;
	    public MasterServicePortType port;
    }

}

