/* This class handles the progress tracking */
package edu.uwyo.cs.scivizmaster.client;

public class Task
{
	private int lengthOfTask;
	private int current = 0;
	private boolean done = false;
	private boolean canceled = false;
	private String statMessage;
	Task tmp;

	public Task()
	{
		// Compute length of task
		lengthOfTask = 10;
		tmp = this;
	}

	public Task(String imgs)
	{
		// Keep track of num of images
		lengthOfTask = Integer.valueOf(imgs).intValue();
		tmp = this;
		System.out.println("CONSTRUCT TASK\n");
	}

	public void go(String imgs, String ang, String out, String dt,
		       String ts, String dout, String mode, String iwidth,
		       String iheight, String master, String factory,
		       String gftp, String resid)
	{
		final String imgs1 = imgs;
		final String ang1 = ang;
		final String out1 = out;
		final String dt1 = dt;
		final String ts1 = ts;
		final String dout1 = dout;
		final String mode1 = mode;
		final String iwidth1 = iwidth;
		final String iheight1 = iheight;
		final String master1 = master;
		final String factory1 = factory;
		final String gftp1 = gftp;
		final String resid1 = resid;
		System.out.println("GO!\n");
		final SwingWorker worker = new SwingWorker()
		{
			public Object construct()
			{
				System.out.println("CONSTRUCTING WORKER AND RUNNING ACTUAL TASK");
				current = 0;
				done = false;
				canceled = false;
				statMessage = null;
				return new ActualTask(tmp,imgs1,ang1,out1,dt1,
						      ts1,dout1,mode1,iwidth1,
						      iheight1,master1,factory1,
						      gftp1,resid1);
			}
		};
		worker.start();
	}
	
	public void setStatMsg(String s)
	{
		statMessage = s;
	}

	public synchronized void setLength(int l)
	{
		lengthOfTask = l;
	}

	public int getLength()
	{
		return lengthOfTask;
	}

	public synchronized void setCurrent(int c)
	{
		current = c;
	}

	public int getCurrent()
	{
		return current;
	}

	public void stop()
	{
		canceled = true;
		statMessage = null;
	}

	public boolean isDone()
	{
		return done;
	}
	
	public boolean isCanceled()
	{
		return canceled;
	}
	
	public void incCurrent()
	{
		current++;
	}
	
	public void setDone()
	{
		done = true;
	}
	
	public void setUnDone()
	{
		done = false;
	}

	public String getMessage()
	{
		return statMessage;
	}
};
