package edu.uwyo.cs.scivizmaster.impl;

import java.util.*;

import org.apache.commons.logging.*;

import org.apache.axis.components.uuid.*;
import org.apache.axis.message.addressing.*;

import org.globus.wsrf.*;
import org.globus.wsrf.impl.*;

import edu.uwyo.cs.scivizmaster.stubs.*;
import edu.uwyo.cs.scivizmaster.stubs.service.*;

public class SciVizMasterResource implements Resource, ResourceIdentifier,
				     ResourceProperties {

    static final Log logger = LogFactory.getLog (SciVizMasterResource.class);

    private static final UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();

    private ResourcePropertySet propSet;

    private Object key;

    private int curr;
    private int work;
    private String gftpServer;
    private IterType[] idata;

    public Object initialize(String resID) throws Exception {
//	key = uuidGen.nextUUID();
	key = new String(resID);
	logger.trace ("Initializing SciVizMasterResource: " + key);

	propSet = new SimpleResourcePropertySet(SciVizMasterConstants.RESOURCE_PROPERTIES);

	ResourceProperty iterRP = new ReflectionResourceProperty(SciVizMasterConstants.RP_ITER, "idata", this);
	this.propSet.add(iterRP);
	setIdata(null);
	ResourceProperty currRP = new ReflectionResourceProperty(SciVizMasterConstants.RP_CURR, "curr", this);
	this.propSet.add(currRP);
    setCurr(0);
	ResourceProperty workRP = new ReflectionResourceProperty(SciVizMasterConstants.RP_WORK, "work", this);
	this.propSet.add(workRP);
	setWork(0);
	ResourceProperty gftpRP = new ReflectionResourceProperty(SciVizMasterConstants.RP_WORK, "gftpServer", this);
	this.propSet.add(gftpRP);
	setGftpServer("");

	   return key;
    }

    public IterType[] getIdata() {
	   return idata;
    }

    public synchronized void setIdata(IterType[] newIter) {
	   idata = newIter;
    }

    public int getCurr()
    {
        return curr;
    }

    public synchronized void setCurr(int newCurr)
    {
        curr = newCurr;
    }

    public int getWork()
    {
        return work;
    }

    public synchronized void setWork(int newWork)
    {
        work = newWork;
    }

    public String getGftpServer()
    {
	return gftpServer;
    }

    public synchronized void setGftpServer(String newServ)
    {
	gftpServer = newServ;
    }

    public ResourcePropertySet getResourcePropertySet() {
	   return this.propSet;
    }

    public Object getID() {
	   return this.key;
    }

}
