package edu.uwyo.cs.scivizmaster.impl;

import java.rmi.RemoteException;

import org.globus.wsrf.*;
import org.apache.axis.message.addressing.*;
import org.apache.commons.logging.*;

import edu.uwyo.cs.scivizmaster.stubs.*;
import edu.uwyo.cs.scivizmaster.stubs.service.*;

public class SciVizMasterService {

    static final Log logger = LogFactory.getLog (SciVizMasterService.class);

    private SciVizMasterResource getResource() throws RemoteException {
    	Object resource = null;
    	try {
    	    resource = ResourceContext.getResourceContext().getResource();
    	} catch (Exception e) {
    	    throw new RemoteException("Error looking up resource", e);
    	}

    	SciVizMasterResource res = (SciVizMasterResource) resource;
    	return res;
    }

    public GetNextIterResponse getNextIter (GetNextIter params) throws RemoteException {
	    logger.trace ("GetNextIter::Enter\n");

	    SciVizMasterResource resource = getResource();
        GetNextIterResponse resp = new GetNextIterResponse();
        int curr = resource.getCurr();
        int work = resource.getWork();
        System.out.println("CURR: " + curr + " WORK: " + work);
        if(work == curr)
        {
            System.out.println("WORK == CURR");
            resp.setIdata(null);
        }
        else
        {
            System.out.println("WORK < CURR");
            System.out.println(Integer.valueOf(resource.getIdata()[work].getIter()).intValue());
            resp.setIdata((resource.getIdata())[work]);
            resource.setWork(work+1);
        }

        System.out.println("GETNEXTITER: RETURNING");
	    logger.trace ("GetNextIter::Exit\n");
        return resp;
    }

    public AddIterDataResponse addIterData (AddIterData params)  throws RemoteException {
	   logger.trace ("AddIterData::Enter\n");

	   SciVizMasterResource resource = getResource();
       int curr = resource.getCurr();
       IterType[] iters = resource.getIdata();
       IterType[] is = new IterType[curr+1];
       for(int i = 0; i < curr; i++)
       {
	       is[i] = new IterType();
	       is[i] = iters[i];
       }
       is[curr] = new IterType();
       is[curr] = params.getIdata();
       System.out.println(Integer.valueOf(is[curr].getIter()).intValue());
       System.out.println(Float.valueOf(is[curr].getBodies()[0].getMass()).floatValue());
       resource.setIdata(is);
       resource.setCurr(curr+1);

	   logger.trace ("AddIterData::Exit\n");
	   return new AddIterDataResponse ();
    }

    public GetNIterRemainingResponse getNIterRemaining (GetNIterRemaining params)  throws RemoteException {
        logger.trace ("GetNIterRemaining::Enter\n");
    	SciVizMasterResource resource = getResource();

        GetNIterRemainingResponse resp = new GetNIterRemainingResponse();
        resp.setNiters(resource.getCurr()-resource.getWork());

    	logger.trace ("GetNIterRemaining::Exit\n");
    	return resp;
    }
    
    public SetGftpServerResponse setGftpServer (SetGftpServer params)  throws RemoteException {
	    logger.trace ("SetGftpServer::Enter\n");
    	SciVizMasterResource resource = getResource();
	resource.setGftpServer(params.getDest());

    	logger.trace ("SetGftpServer::Exit\n");
	    return new SetGftpServerResponse ();
    }

    public GetGftpServerResponse getGftpServer (GetGftpServer params) throws RemoteException {
	logger.trace ("GetGftpServer::Enter\n");
	SciVizMasterResource resource = getResource();
	GetGftpServerResponse resp = new GetGftpServerResponse();
	resp.setDest(resource.getGftpServer());
	
	logger.trace ("GetGftpServer::Exit\n");
	return resp;
    }

}
