package edu.uwyo.cs.scivizmaster.slaveclient;

import java.util.*;
import java.rmi.*;

import org.apache.commons.logging.*;

import org.apache.axis.message.addressing.*;

import org.globus.wsrf.*;
import org.globus.wsrf.utils.*;
import org.globus.wsrf.impl.*;
import org.globus.wsrf.core.notification.*;
import org.globus.wsrf.core.notification.service.*;
import org.oasis.wsn.*;
import org.oasis.wsrf.lifetime.*;

import edu.uwyo.cs.scivizmaster.impl.*;
import edu.uwyo.cs.scivizmaster.stubs.*;
import edu.uwyo.cs.scivizmaster.stubs.service.*;
import edu.uwyo.cs.scivizmaster.factory.stubs.*;
import edu.uwyo.cs.scivizmaster.factory.stubs.service.*;

public class SciVizSlaveClient {
    static final Log logger = LogFactory.getLog (SciVizSlaveClient.class);

    public native void createImage(IterType i);

    static {
        System.loadLibrary("pnginterfacelib");
    }

    private static final String serviceURIPostfix = ":8080/wsrf/services/SciVizMasterService";
    private static final String factoryURIPostfix = ":8080/wsrf/services/SciVizMasterFactoryService";

    private ServiceInfo service;
    private String factoryURL;
    private String serviceURL;
    private String proxyFile;
    private String gftpHost;
    private URLCopy urlcopy = null;

    public static void main (String[] args) {
	   SciVizSlaveClient client = new SciVizSlaveClient ();

	   client.initialize (args);
    }

    public void initialize (String[] args) {
	   String factoryURI;
	   String resID;

	   switch (args.length) {
	   default:
	       System.out.println ("Usage: SlaveClient [ Factory Service URL ] [ Master Service URL ] [ Proxy File ] [ resID ]");
	       return;
	   case 4:
           factoryURL = args[0];
           serviceURL = args[1];
	       proxyFile = args[2];
	       resID = args[3];
	       break;
	   }

       factoryURI = factoryURL + factoryURIPostfix;

	   service = new ServiceInfo();

	   try {
	       urlcopy = new URLCopy();
	       SciVizFactoryServiceAddressingLocator factoryLocator = new SciVizFactoryServiceAddressingLocator ();
	       SciVizMasterJavaServiceAddressingLocator serviceLocator = new SciVizMasterJavaServiceAddressingLocator ();

	       EndpointReferenceType factoryEndpoint = new EndpointReferenceType ();
	       factoryEndpoint.setAddress (new Address (factoryURI));
           FactoryPortType scivizFactory = factoryLocator.getFactoryPortTypePort (factoryEndpoint);

           GenerateResource gr = new GenerateResource();
           gr.setResID(resID);

           logger.info ("Accessing Master service instance:\n");

		   GenerateResourceResponse genResponse = scivizFactory.generateResource (gr);
		   service.endpoint = genResponse.getEndpointReference ();
		   service.port = serviceLocator.getMasterServicePortTypePort (service.endpoint);

		  logger.info ("Starting service:\n");
          int val = 0;
		GetGftpServerResponse gftp = service.port.getGftpServer(new GetGftpServer());
		gftpHost = gftp.getDest();
		  while(val == 0)
		  {
			val = getAndDrawIter();
		  }
	   } catch (Exception e) {
		   e.printStackTrace();
	   }
    }

    public int getAndDrawIter()
    {
	    GetNextIterResponse next = new GetNextIterResponse();
	    try {
	    	next = service.port.getNextIter(new GetNextIter());
	    } catch (RemoteException e) {
		    e.printStackTrace();
		    return -1;
	    }
        IterType iter;
	    iter = next.getIdata();
	    if(iter == null)
        {
            System.out.println("ITER IS NULL, RETURNING -1");
		    return -1;
        }

        drawBodies(iter);
/*	String fname = "Iter" + iter.getIter() + ".png";
	String fromURL = "file:///" + fname;
	String toURL = "gsiftp://" + gftpHost + ":2811//tmp/" + fname;
	String subject = null;
	Cred cred = null;
	System.out.println("STARTING TRANSFER OF " + fname);
	try {
		cred = new Cred();
		cred.loadCred(proxyFile);
		subject = cred.getSubject();
		StringBuffer tmpSub = new StringBuffer();
		tmpSub.append("/");
		for(int i = 0; i < subject.length(); i++) {
			if(subject.charAt(i) != ',')
			{
				tmpSub.append(subject.charAt(i));
			}
			else 
			{
				tmpSub.append("/");
			}
		}
		int index = tmpSub.lastIndexOf("CN");
		if(index == tmpSub.indexOf("CN"))
		{
			index = subject.length();
		}
		urlcopy.transferData(fromURL,toURL,tmpSub.substring(0, index-1),false,false);
	} catch (Exception e) {
		e.printStackTrace();
	}
	System.out.println(fname + " transfered");*/
        return 0;
    }

    public int getIterIter(IterType iter)
    {
        return iter.getIter();
    }

    private void drawBodies(IterType iter)
    {
	    int num = iter.getNbodies();
	    int i = 0;
	    for (i = 0; i < num; i++)
	    {
            System.out.println("BODY: " + i);
/*		    drawBody(iter.getMode(),
				    ((iter.getBodies())[i]).getPosx(),
				    ((iter.getBodies())[i]).getPosy(),
				    ((iter.getBodies())[i]).getPosz(),
				    ((iter.getBodies())[i]).getVelx(),
				    ((iter.getBodies())[i]).getVely(),
				    ((iter.getBodies())[i]).getVelz(),
				    ((iter.getBodies())[i]).getMass()  );*/
	    }
//        createImage(iter);
    }

    private void drawBody(int mode, float posx, float posy, float posz, float velx, float vely, float velz, float mass)
    {
	    System.out.println("MODE: " + mode);
	    System.out.println("MASS: " + mass);
	    System.out.println("POSX: " + posx);
	    System.out.println("POSY: " + posy);
	    System.out.println("POSZ: " + posz);
	    System.out.println("VELX: " + velx);
	    System.out.println("VELY: " + vely);
	    System.out.println("VELZ: " + velz);
    }

    private static class ServiceInfo {
	    public EndpointReferenceType endpoint;
	    public MasterServicePortType port;
    }

}

