package edu.uwyo.cs.scivizmaster.slaveclient;

import java.net.MalformedURLException;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import org.globus.io.urlcopy.*;
import org.globus.util.*;
import org.globus.gsi.gssapi.auth.IdentityAuthorization;

public class URLCopy implements UrlCopyListener {
	long transferedBytes;
	public void transfer(long transferedBytes, long totalBytes)
	{
		this.transferedBytes += transferedBytes;
	}
	public void transferError(Exception e) {
		System.err.println("transferError: " + e);
	}
	public void transferCompleted() {
		System.out.println("transferedCompleted: bytes" + transferedBytes);
	}
	void transferData(String fromURL, String toURL, String subject, boolean thirdParty, boolean dcau) throws MalformedURLException, UrlCopyException
	{
		GlobusURL from = new GlobusURL(fromURL);
		GlobusURL to = new GlobusURL(toURL);
		System.out.println("FROM: " + from.toString() + " TO: " + to.toString());
		UrlCopy uc = new UrlCopy();
		uc.setSourceUrl(from);
		uc.setDestinationUrl(to);
		uc.setUseThirdPartyCopy(thirdParty);
		uc.setDCAU(dcau);
		if(subject != null && ! subject.equals("")) {
			uc.setSourceAuthorization(
				new IdentityAuthorization(subject));
			uc.setDestinationAuthorization(
				new IdentityAuthorization(subject));
		}
		uc.addUrlCopyListener(this);
		uc.run();
	}
/*	public static void main(String[] args) {
		try {
			Logger.getRootLogger().setLevel(Level.INFO);
			String fromURL = "file:////home/students/tbolin/globus/SciVizJava/Iter0.png";
			String toURL = "gsiftp://fish12.cs.uwyo.edu:2811//tmp/Iter0.png";
			String subject = "/O=Grid/OU=GlobusTest/OU=simpleCA-fish12.cs.uwyo.edu/OU=cs.uwyo.edu/CN=todd d. bolinger";
			boolean thirdp = false;
			boolean dcau = false;
			URLCopy transClient = new URLCopy();
			transClient.transferData(fromURL, toURL, subject, thirdp, dcau);
		} catch (Exception e) {
			System.err.println(e);
		}
	}*/
}
