package example;

import java.util.List;

import example.data.CatalogEntry;
import example.data.DBException;
import example.data.QueryDAO;

public class AppLogic {
	public List getData () {
		try {
			QueryDAO myQuery = new QueryDAO () {
				public Object processRow () throws DBException {
					try {
						// CatalogEntry (int id, String journal, String publisher, String date, String title, String author)
						return new CatalogEntry (rs.getInt ("catalogId"), 
								rs.getString ("journal"),
								rs.getString ("publisher"),
								rs.getString ("date"),
								rs.getString ("title"),
								rs.getString ("author"));
					} catch (Exception e) {
						throw new DBException (e.getMessage());
					}
				}					
			};

			myQuery.setQuery ("SELECT catalogId, journal, publisher, date, title, author from Catalog");
			List results = myQuery.execute ();
			return results;
		} catch (Exception e) {
			System.out.println(e);
			e.printStackTrace();
		}
		return null;
	}
}
