package example.data;
import java.util.List;
import java.util.ArrayList;
import java.sql.*;
import example.data.SqlTypes;

public abstract class QueryDAO {

	private String query;

	private int parameterNumber;
	private ArrayList parameterType;
	private ArrayList parameterValue;

	private String driverName = "com.mysql.jdbc.Driver";
	private String uri = "jdbc:mysql://localhost/test";
	private String username = "root";
	private String password = "giacint7";

	private ArrayList queryResults;
	public ResultSet rs = null;

	public QueryDAO () {
		parameterNumber = 0;
		parameterType = new ArrayList ();
		parameterValue = new ArrayList ();
		queryResults = new ArrayList ();
	}

	public void cleanEnvironment () {
		parameterNumber = 0;
		parameterType = new ArrayList ();
		parameterValue = new ArrayList ();
		queryResults = new ArrayList ();
	}

	public void setQuery (String query) {
		this.query = query;
	}

	public void setParameter(int index, String paramType, Object value) {
		int paramTypeNum = 0;

		if (paramType == SqlTypes.SQLSTRING) {
			paramTypeNum = 0;
		} else {
			if (paramType == SqlTypes.SQLINTEGER) {
				paramTypeNum = 1;
			} else {
				if (paramType == SqlTypes.SQLDATE) {
					paramTypeNum = 2;
				} else {
					if (paramType == SqlTypes.SQLCLOB) {
						paramTypeNum = 3;
					}
				}
			}
		}

		parameterType.add (index - 1, new Integer (paramTypeNum));
		parameterValue.add (index - 1, value);
		parameterNumber++;
	}

	public abstract Object processRow () throws DBException;

	public List execute() throws DBException {
		Connection conn = null;
		PreparedStatement stmt  = null;

		try {
			Class.forName (driverName).newInstance ();
			conn = DriverManager.getConnection (uri, username, password);    
			stmt = conn.prepareStatement (query);
			/* String email = "%jlc%";
		    stmt = conn.prepareStatement ("select * from users where PrimaryEmail = ? ");
		    stmt.setString(1, email);*/

		    for (int i = 0; i < parameterNumber; i++) {
		    	switch (((Integer) parameterType.get (i)).intValue ()) {
		    	case 0: stmt.setString (i + 1, (String) parameterValue.get (i));
		    	System.out.println("paramvalue = " +(String) parameterValue.get (i) );
		    	break;
		    	case 1: stmt.setInt (i + 1, ((Integer) parameterValue.get (i)).intValue ());
		    	break;
		    	case 2: java.sql.Date sqlDateVal = new java.sql.Date (((java.util.Date) parameterValue.get (i)).getTime ());
		    	stmt.setDate (i + 1, sqlDateVal);
		    	break;
		    	case 3: stmt.setString (i + 1, (String) parameterValue.get (i));
		    	break;
		    	}
		    }
		    // System.out.println("stmt: "+stmt);
		    rs = stmt.executeQuery ();
		    // System.out.println("rs == null" + (rs == null));
		    while (rs.next ()) {
		    	//  System.out.println("calling process row");
		    	queryResults.add (processRow());
		    }
		}
		catch (Exception e) {
			throw new DBException ("Unexpected exception: " + e);
		}
		finally {
			try {
				if (rs != null)
					rs.close ();
			}
			catch (Exception e) {
				throw new DBException  ("Unexpected exception: " + e);
			}
			try {
				if (stmt != null)
					stmt.close ();
			}
			catch (Exception e) {
				throw new DBException  ("Unexpected exception: " + e);
			}
			try {
				if (conn != null)
					conn.close ();
			}
			catch (Exception e) {
				throw new DBException ("Unexpected exception: " + e);
			} 
		}
		return queryResults;    
	}

	public static void main (String[] args) {
		try {
			QueryDAO myQuery = new QueryDAO () {
				public Object processRow () throws DBException {
					try {
						// CatalogEntry (int id, String journal, String publisher, String date, String title, String author)
						return new CatalogEntry (rs.getInt ("catalogId"), 
								rs.getString ("journal"),
								rs.getString ("publisher"),
								rs.getString ("date"),
								rs.getString ("title"),
								rs.getString ("author"));
					} catch (Exception e) {
						throw new DBException (e.getMessage());
					}
				}					
			};

			myQuery.setQuery ("SELECT catalogId, journal, publisher, date, title, author from Catalog");
			List results = myQuery.execute ();
			for (int i = 0; i < results.size(); i++) {
				System.out.println (results.get(i));
			}
		} catch (Exception e) {
			System.out.println(e);
		}
	}
}
