/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.cs.gradebook.download;

import edu.uwyo.cs.gradebook.download.Downloader;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DownloaderFactory {
    private static Logger logger = Logger.getLogger("edu.uwyo.cs.gradebook.download.DownloaderFactory");
    private static Class downloaderClass = null;

    public static Downloader getNewInstance() {
        Downloader downloader = null;
        if (downloaderClass == null) {
            try {
                Properties props = new Properties();
                InputStream stream = new DownloaderFactory().getClass().getClassLoader().getResourceAsStream("gradebook.properties");
                props.load(stream);
                stream.close();
                String classname = props.getProperty("downloader");
                downloaderClass = Class.forName(classname);
            }
            catch (Exception e) {
                logger.error("Unable to get class name for downloading");
                return null;
            }
        }
        logger.info("Creating instance of downloader: " + downloaderClass);
        try {
            downloader = (Downloader)downloaderClass.getConstructor(null).newInstance(null);
        }
        catch (Exception e) {
            logger.error("Unable to create instance of " + downloaderClass);
        }
        return downloader;
    }
}

