/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.cs.gradebook.download;

import com.Ostermiller.util.CSVParser;
import edu.uwyo.cs.gradebook.download.Downloader;
import edu.uwyo.cs.gradebook.download.HitWFormAnalyzer;
import edu.uwyo.cs.gradebook.model.Student;
import edu.uwyo.cs.gradebook.utils.HTTPPoster;
import html.lexer.LexerException;
import html.lexer.MyLexer;
import html.node.Start;
import html.parser.MyParser;
import html.parser.ParserException;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class HitWDownloader
implements Downloader {
    private static Logger logger = Logger.getLogger("edu.uwyo.cs.gradebook.download.HitWDownloader");
    private static final String LOGIN_URL = "https://matilda.uwyo.edu/HoleInTheWall/cgi-bin/sisget.pl?/awosgnon";
    private static final String REQUEST_URL = "https://matilda.uwyo.edu/HoleInTheWall/forms/rwb150of.htm";
    public static final int PUSHBACK_SIZE = 1024;

    public Student[] downloadClassRoster(String userid, String password, int year, int semester, String department, String course, String section) {
        HTTPPoster poster = HTTPPoster.getInstance();
        logger.info("downloadClassRoster: [" + year + "]" + ", [" + semester + "]" + ", [" + department + "]" + ", [" + course + "]" + ", [" + section + "]");
        if (semester != 1 && semester != 2 && semester != 3) {
            logger.error("Semester not one of SUMMER, FALL, or SPRING");
            return null;
        }
        year %= 100;
        logger.debug("Getting login page");
        String login = poster.doPost(LOGIN_URL);
        MyParser p = new MyParser(new MyLexer(new PushbackReader(new StringReader(login), 1024)));
        try {
            logger.debug("Parsing login page");
            Start tree = p.parse();
            HitWFormAnalyzer login_form = new HitWFormAnalyzer();
            tree.apply(login_form);
            String login_action = login_form.getAction();
            Properties login_inputs = login_form.getInputs();
            if (logger.isDebugEnabled()) {
                logger.debug("Form action = [" + login_action + "]");
                Enumeration<?> names = login_inputs.propertyNames();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    logger.debug("Form input [" + name + "] = [" + login_inputs.getProperty(name) + "]");
                }
            }
            login_inputs.setProperty("userid", userid);
            login_inputs.setProperty("userpw", password);
            logger.debug("Sending login request");
            String main_page = poster.doPost(this.fixURL(LOGIN_URL, login_action), login_inputs);
            logger.debug("Parsing login request for context");
            String rcode = null;
            Pattern context_pattern = Pattern.compile(".*InitializeContext\\p{Space}*\\(\\p{Space}*\"([^\"]*)\".*", 40);
            Matcher context_matcher = context_pattern.matcher(main_page);
            if (context_matcher.matches()) {
                rcode = context_matcher.group(1);
                if (logger.isDebugEnabled()) {
                    logger.debug("Found session context: [" + rcode + "]");
                }
            } else {
                logger.error("Unable to find session context");
            }
            String request = poster.doPost(REQUEST_URL);
            p = new MyParser(new MyLexer(new PushbackReader(new StringReader(request), 1024)));
            logger.debug("Parsing request page");
            tree = p.parse();
            HitWFormAnalyzer request_form = new HitWFormAnalyzer();
            tree.apply(request_form);
            String request_action = request_form.getAction();
            Properties request_inputs = request_form.getInputs();
            if (logger.isDebugEnabled()) {
                logger.debug("Form action = [" + request_action + "]");
                Enumeration<?> names = request_inputs.propertyNames();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    logger.debug("Form input [" + name + "] = [" + request_inputs.getProperty(name) + "]");
                }
            }
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMinimumIntegerDigits(2);
            request_inputs.setProperty("exemode", "DO");
            request_inputs.setProperty("routercode", rcode);
            request_inputs.setProperty("TERM", String.valueOf(nf.format(year)) + semester);
            request_inputs.setProperty("AUSubject", "A1" + department);
            request_inputs.setProperty("CrsNumber", course);
            request_inputs.setProperty("CrsSectNr", section);
            request_inputs.setProperty("opt1", "E");
            request_inputs.setProperty("opt2", "C");
            request_inputs.setProperty("phoneOpt", "");
            request_inputs.setProperty("EmailOpt", "E1");
            if (logger.isDebugEnabled()) {
                logger.debug("Completed login form");
                logger.debug("Form action = [" + request_action + "]");
                Enumeration<?> names = request_inputs.propertyNames();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    logger.debug("Form input [" + name + "] = [" + request_inputs.getProperty(name) + "]");
                }
            }
            String roster = poster.doPost(this.fixURL(REQUEST_URL, request_action), request_inputs);
            Student[] students = this.getStudentList(roster);
            return students;
        }
        catch (ParserException e) {
            logger.error("Error parsing login page");
            e.printStackTrace();
        }
        catch (LexerException e) {
            logger.error("Error parsing login page");
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.error("Error reading login page");
            e.printStackTrace();
        }
        return null;
    }

    private Student[] getStudentList(String roster) {
        String[][] values;
        String[] headings = new String[]{"CourseID", "Name", "SID", "PrivFlag", "Hours", "GrdTyp", "Class", "PriCollege", "PriDegree", "PriMaj1", "PriMaj2", "SecColl", "SecDegr", "SecMaj1", "SecMaj2", "Status", "Phone", "Email"};
        try {
            values = CSVParser.parse(new StringReader(roster));
        }
        catch (IOException e) {
            logger.error("Unable to parse roster from Hole in the Wall");
            e.printStackTrace();
            return null;
        }
        if (values[0].length != headings.length) {
            logger.error("Unexpected headings from Hole in the Wall: expected " + headings.length + " headings, but got " + values[0].length + " instead");
            return null;
        }
        int j = 0;
        while (j < values[0].length) {
            if (!values[0][j].equals(headings[j])) {
                logger.error("Unexpected heading downloaded from Hole in the Wall: expected [" + headings[j] + "], but got [" + values[0][j] + "]");
                return null;
            }
            ++j;
        }
        ArrayList<Student> students = new ArrayList<Student>();
        int i = 1;
        while (i < values.length) {
            Student st = new Student();
            st.isActive = true;
            st.course = values[i][0];
            st.name = values[i][1];
            st.ssn = values[i][2];
            st.email = values[i][17];
            students.add(st);
            if (logger.isDebugEnabled()) {
                logger.debug(st.toString());
            }
            ++i;
        }
        return students.toArray(new Student[0]);
    }

    private String fixURL(String base, String url) {
        if (logger.isDebugEnabled()) {
            logger.debug("Fixing URL [" + url + "] wrt base [" + base + "]");
        }
        try {
            URL baseurl = new URL(base);
            URL newurl = new URL(baseurl, url);
            String fixed_url = newurl.toString();
            if (logger.isDebugEnabled()) {
                logger.debug("Fixed URL to [" + fixed_url + "]");
            }
            return fixed_url;
        }
        catch (MalformedURLException e) {
            logger.error("Attempted to fix invalid URL [" + url + "] wrt base [" + base + "]");
            e.printStackTrace();
            return null;
        }
    }
}

