/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.cs.gradebook.download;

import edu.uwyo.cs.gradebook.utils.AttrParser;
import html.analysis.DepthFirstAdapter;
import html.node.AInputBlock;
import html.node.ANormalBlock;
import html.node.AOpentag;
import html.node.TTb;
import java.util.Properties;
import org.apache.log4j.Logger;

public class HitWFormAnalyzer
extends DepthFirstAdapter {
    private static Logger logger = Logger.getLogger("edu.uwyo.cs.gradebook.download.HitWFormAnalyzer");
    private String action = null;
    private Properties inputs = new Properties();

    public String getAction() {
        return this.action;
    }

    public Properties getInputs() {
        return (Properties)this.inputs.clone();
    }

    public void caseANormalBlock(ANormalBlock node) {
        String opentagName;
        AOpentag opentag = (AOpentag)node.getOpentag();
        String string = opentagName = node.getOpentag() != null ? opentag.getTag().getText().toLowerCase() : null;
        if (logger.isDebugEnabled()) {
            if (opentagName == null) {
                logger.debug("Processing normal block: [NULL]");
            } else {
                logger.debug("Processing normal block: [" + opentagName + "]");
            }
        }
        if (opentagName.equals("form")) {
            logger.debug("Processing <form>");
            TTb attrs = opentag.getTb();
            if (attrs != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Processing attributes: [" + attrs.getText() + "]");
                }
                Properties props = new AttrParser().parseAttrList(attrs.getText());
                this.action = props.getProperty("action", "");
                if (logger.isDebugEnabled()) {
                    logger.debug("Action = [" + this.action + "]");
                }
            }
        }
        super.caseANormalBlock(node);
    }

    public void caseAInputBlock(AInputBlock node) {
        logger.debug("Processing input block");
        TTb attrs = node.getTb();
        if (attrs != null) {
            Properties props;
            String name;
            if (logger.isDebugEnabled()) {
                logger.debug("Processing attributes: [" + attrs.getText() + "]");
            }
            if ((name = (props = new AttrParser().parseAttrList(attrs.getText())).getProperty("name")) != null) {
                String value = props.getProperty("value", "");
                this.inputs.setProperty(name, value);
                if (logger.isDebugEnabled()) {
                    logger.debug("    Input [" + name + "] = [" + value + "]");
                }
            }
        }
        super.caseAInputBlock(node);
    }
}

