/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.cs.gradebook.importer;

import edu.uwyo.cs.gradebook.importer.Importer;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ImporterFactory {
    private static Logger logger = Logger.getLogger("edu.uwyo.cs.gradebook.import.ImporterFactory");
    private static Class importerClass = null;

    public static Importer getNewInstance() {
        Importer importer = null;
        if (importerClass == null) {
            try {
                Properties props = new Properties();
                InputStream stream = new ImporterFactory().getClass().getClassLoader().getResourceAsStream("gradebook.properties");
                props.load(stream);
                stream.close();
                String classname = props.getProperty("importer");
                importerClass = Class.forName(classname);
            }
            catch (Exception e) {
                logger.error("Unable to get class name for importing");
                return null;
            }
        }
        logger.info("Creating instance of importer: " + importerClass);
        try {
            importer = (Importer)importerClass.getConstructor(null).newInstance(null);
        }
        catch (Exception e) {
            logger.error("Unable to create instance of " + importerClass);
        }
        return importer;
    }
}

