/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.cs.gradebook.importer;

import com.Ostermiller.util.CSVParser;
import edu.uwyo.cs.gradebook.importer.Importer;
import edu.uwyo.cs.gradebook.model.Student;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public final class WyoWebCsvImporter
implements Importer {
    private static Logger logger = Logger.getLogger("edu.uwyo.cs.gradebook.importer.WyoWebCsvImporter");

    public Student[] importClassRoster(String filename, String department, String course, String section) {
        String[][] values;
        try {
            FileReader in = new FileReader(filename);
            values = CSVParser.parse(new BufferedReader(in));
            in.close();
        }
        catch (IOException e) {
            logger.error("Unable to import '" + filename + "': " + e);
            e.printStackTrace();
            return null;
        }
        ArrayList<Student> students = new ArrayList<Student>();
        for (int i = 0; i < values.length; ++i) {
            if (!"Subject:".equals(values[i][0])) continue;
            if (!department.equals(values[i][1])) {
                logger.error("Department mismatch.  Expecting: [" + department + "], got: [" + values[i][1] + "]");
                return null;
            }
            if ("Course Number:".equals(values[i][0])) {
                if (course.equals(values[i][1])) continue;
                logger.error("Course number mismatch.  Expecting: [" + course + "], got: [" + values[i][1] + "]");
                return null;
            }
            if ("Section:".equals(values[i][0])) {
                if (section.equals(values[i][1])) continue;
                logger.error("Course section mismatch.  Expecting: [" + section + "], got: [" + values[i][1] + "]");
                return null;
            }
            if (!"Last Name".equals(values[i][0])) continue;
            ++i;
            while (i < values.length) {
                int LAST_NAME = 0;
                int FIRST_NAME = 1;
                int MIDDLE_INITIAL = 2;
                int SSN = 3;
                int EMAIL = 6;
                Student s = new Student();
                s.isActive = true;
                s.course = department + " " + course;
                s.name = values[i][LAST_NAME] + ", " + values[i][FIRST_NAME];
                if (values[i][MIDDLE_INITIAL] != null) {
                    s.name = s.name + " " + values[i][MIDDLE_INITIAL];
                }
                s.ssn = values[i][SSN];
                s.email = values[i][EMAIL];
                students.add(s);
                ++i;
            }
        }
        return (Student[])students.toArray();
    }
}

