/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.cs.gradebook.model;

import edu.uwyo.cs.gradebook.model.GradeGroup;
import edu.uwyo.cs.gradebook.model.GradeItem;
import edu.uwyo.cs.gradebook.model.GradeObject;
import edu.uwyo.cs.gradebook.model.Student;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Roster {
    private static Logger logger = Logger.getLogger("edu.uwyo.cs.gradebook.model.Roster");
    private String curFilename = null;
    private Student[] students = new Student[0];
    private GradeGroup grades = new GradeGroup();
    private double lowerBoundForA = 90.0;
    private double lowerBoundForB = 80.0;
    private double lowerBoundForC = 70.0;
    private double lowerBoundForD = 60.0;
    private int year = -1;
    private int semester = -1;
    private String department = null;
    private String course = null;
    private String section = null;

    public Roster() {
        this.init();
    }

    private void init() {
        this.curFilename = null;
        this.students = new Student[0];
        this.grades = new GradeGroup();
        this.grades.name = "New Group";
        this.lowerBoundForA = 90.0;
        this.lowerBoundForB = 80.0;
        this.lowerBoundForC = 70.0;
        this.lowerBoundForD = 60.0;
        this.year = -1;
        this.semester = -1;
        this.department = null;
        this.course = null;
        this.section = null;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int y) {
        this.year = y;
    }

    public int getSemester() {
        return this.semester;
    }

    public void setSemester(int s) {
        this.semester = s;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String d) {
        this.department = d;
    }

    public String getCourse() {
        return this.course;
    }

    public void setCourse(String c) {
        this.course = c;
    }

    public String getSection() {
        return this.section;
    }

    public void setSection(String s) {
        this.section = s;
    }

    public void readFromFile(String filename) throws IOException, SAXException, ParserConfigurationException {
        this.init();
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(new File(filename), (DefaultHandler)new RosterHandler());
            this.curFilename = filename;
            return;
        }
        catch (ParserConfigurationException e) {
            logger.error("Unable to configure XML Parser");
            e.printStackTrace();
            throw e;
        }
        catch (SAXException e) {
            logger.error("Unable to parse XML roster file");
            e.printStackTrace();
            throw e;
        }
    }

    private void indent(PrintWriter out, int indent) {
        int i = 0;
        while (i < indent) {
            out.print(" ");
            ++i;
        }
    }

    private void writeGradeGroupToFile(PrintWriter out, GradeGroup group, int indentAmount) throws IOException {
        this.indent(out, indentAmount);
        out.println("<gradegroup>");
        this.indent(out, indentAmount + 4);
        out.println("<name>" + group.name + "</name>");
        this.indent(out, indentAmount + 4);
        out.println("<maxitems>" + group.maxItems + "</maxitems>");
        this.indent(out, indentAmount + 4);
        out.println("<maxgrade>" + Double.toString(group.maxGrade) + "</maxgrade>");
        this.indent(out, indentAmount + 4);
        out.println("<weight>" + Double.toString(group.weight) + "</weight>");
        int i = 0;
        while (i < group.items.length) {
            if (group.items[i] instanceof GradeGroup) {
                this.writeGradeGroupToFile(out, (GradeGroup)group.items[i], indentAmount + 4);
            } else {
                this.writeGradeItemToFile(out, (GradeItem)group.items[i], indentAmount + 4);
            }
            ++i;
        }
        this.indent(out, indentAmount);
        out.println("</gradegroup>");
    }

    private void writeGradeItemToFile(PrintWriter out, GradeItem item, int indentAmount) throws IOException {
        this.indent(out, indentAmount);
        out.println("<gradeitem>");
        this.indent(out, indentAmount + 4);
        out.println("<name>" + item.name + "</name>");
        this.indent(out, indentAmount + 4);
        out.println("<maxoccurs>" + item.maxOccurs + "</maxoccurs>");
        this.indent(out, indentAmount + 4);
        out.println("<countsas>" + item.countsAs + "</countsas>");
        this.indent(out, indentAmount + 4);
        out.println("<maxgrade>" + Double.toString(item.maxGrade) + "</maxgrade>");
        this.indent(out, indentAmount + 4);
        out.println("<weight>" + Double.toString(item.weight) + "</weight>");
        this.indent(out, indentAmount);
        out.println("</gradeitem>");
    }

    public void writeToFile(String filename) throws IOException {
        File out_file = new File(filename);
        if (out_file.exists()) {
            int i = 1;
            while (true) {
                File backup_file;
                if (!(backup_file = new File(String.valueOf(filename) + "~" + i + "~")).exists()) {
                    out_file.renameTo(backup_file);
                    break;
                }
                ++i;
            }
        }
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(out_file)));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<roster>");
        if (this.year >= 0) {
            out.println("    <year>" + this.year + "</year>");
        }
        if (this.semester >= 0) {
            out.println("    <semester>" + this.semester + "</semester>");
        }
        if (this.department != null) {
            out.println("    <department>" + this.department + "</department>");
        }
        if (this.course != null) {
            out.println("    <course>" + this.course + "</course>");
        }
        if (this.section != null) {
            out.println("    <section>" + this.section + "</section>");
        }
        this.writeGradeGroupToFile(out, this.grades, 4);
        out.println("    <lowerboundfora>" + this.lowerBoundForA + "</lowerboundfora>");
        out.println("    <lowerboundforb>" + this.lowerBoundForB + "</lowerboundforb>");
        out.println("    <lowerboundforc>" + this.lowerBoundForC + "</lowerboundforc>");
        out.println("    <lowerboundford>" + this.lowerBoundForD + "</lowerboundford>");
        int i = 0;
        while (i < this.students.length) {
            out.println("    <student>");
            out.println("        <active>" + (this.students[i].isActive ? "yes" : "no") + "</active>");
            out.println("        <course>" + this.students[i].course + "</course>");
            out.println("        <name>" + this.students[i].name + "</name>");
            out.println("        <ssn>" + this.students[i].ssn + "</ssn>");
            out.println("        <id>" + this.students[i].id + "</id>");
            out.println("        <email>" + this.students[i].email + "</email>");
            out.println("        <grades>");
            if (this.students[i].grades != null) {
                for (String work : this.students[i].grades.keySet()) {
                    Double grade = (Double)this.students[i].grades.get(work);
                    out.println("            <item>");
                    out.println("                <work>" + work + "</work>");
                    out.println("                <grade>" + grade.toString() + "</grade>");
                    out.println("            </item>");
                }
            }
            out.println("        </grades>");
            out.println("    </student>");
            ++i;
        }
        out.println("</roster>");
        out.close();
        this.curFilename = filename;
    }

    public void mergeStudent(Student new_student) {
        int i = 0;
        while (i < this.students.length) {
            if (new_student.ssn.equals(this.students[i].ssn)) {
                this.students[i].isActive = new_student.isActive;
                this.students[i].course = new_student.course;
                this.students[i].name = new_student.name;
                this.students[i].email = new_student.email;
                break;
            }
            ++i;
        }
        if (i >= this.students.length) {
            Student[] tmp_students = new Student[this.students.length + 1];
            i = 0;
            while (i < this.students.length) {
                tmp_students[i] = this.students[i];
                ++i;
            }
            i = this.students.length;
            tmp_students[i] = (Student)new_student.clone();
            tmp_students[i].id = this.generateStudentId();
            this.students = tmp_students;
        }
    }

    public void mergeClassRoster(Student[] new_students) {
        logger.info("Merging roster with new students");
        int i = 0;
        while (i < this.students.length) {
            this.students[i].isActive = false;
            ++i;
        }
        i = 0;
        while (i < new_students.length) {
            this.mergeStudent(new_students[i]);
            ++i;
        }
        if (logger.isDebugEnabled()) {
            i = 0;
            while (i < this.students.length) {
                logger.debug(this.students[i].toString());
                ++i;
            }
        }
    }

    private int generateStudentId() {
        int id;
        int i;
        block0: do {
            id = (int)(1000.0 + 9000.0 * Math.random());
            i = 0;
            while (i < this.students.length) {
                if (this.students[i].id == id) continue block0;
                ++i;
            }
        } while (i < this.students.length);
        return id;
    }

    public String[] getGradeItems() {
        ArrayList list = new ArrayList();
        this.getGradeItemsFromGroup(this.grades, list);
        return list.toArray(new String[0]);
    }

    private void getGradeItemsFromGroup(GradeGroup g, ArrayList list) {
        int i = 0;
        while (i < g.items.length) {
            if (g.items[i] instanceof GradeGroup) {
                this.getGradeItemsFromGroup((GradeGroup)g.items[i], list);
            } else {
                GradeItem item = (GradeItem)g.items[i];
                if (item.maxOccurs > 1) {
                    int j = 0;
                    while (j < item.maxOccurs) {
                        list.add(String.valueOf(item.name) + (j + 1));
                        ++j;
                    }
                } else {
                    list.add(item.name);
                }
            }
            ++i;
        }
    }

    public void setGrade(int idx, String item, Double grade) {
        if (grade == null) {
            this.students[idx].grades.remove(item);
        } else {
            this.students[idx].grades.put(item, grade);
        }
    }

    public boolean setGradeItemName(String oldName, String newName) {
        block8: {
            GradeObject obj = this.getGradeObject(newName, this.grades);
            if (obj != null) {
                return false;
            }
            obj = this.getGradeObject(oldName, this.grades);
            obj.name = newName;
            if (!(obj instanceof GradeItem)) break block8;
            GradeItem item = (GradeItem)obj;
            if (item.maxOccurs > 1) {
                int i = 0;
                while (i < item.maxOccurs) {
                    String oldKey = String.valueOf(oldName) + (i + 1);
                    String newKey = String.valueOf(newName) + (i + 1);
                    int j = 0;
                    while (j < this.students.length) {
                        Double d = (Double)this.students[j].grades.get(oldKey);
                        if (d != null) {
                            this.students[j].grades.put(newKey, d);
                            this.students[j].grades.remove(oldKey);
                        }
                        ++j;
                    }
                    ++i;
                }
            } else {
                String oldKey = oldName;
                String newKey = newName;
                int j = 0;
                while (j < this.students.length) {
                    Double d = (Double)this.students[j].grades.get(oldKey);
                    if (d != null) {
                        this.students[j].grades.put(newKey, d);
                        this.students[j].grades.remove(oldKey);
                    }
                    ++j;
                }
            }
        }
        return true;
    }

    public GradeObject getGradeObject(String item) {
        GradeObject obj = this.getGradeObject(item, this.grades);
        if (obj != null) {
            obj = (GradeObject)obj.clone();
        }
        return obj;
    }

    private GradeObject getGradeObject(String item, GradeObject grade) {
        if (item.equals(grade.name)) {
            return grade;
        }
        if (grade instanceof GradeGroup) {
            GradeGroup group = (GradeGroup)grade;
            int i = 0;
            while (i < group.items.length) {
                GradeObject found_item = this.getGradeObject(item, group.items[i]);
                if (found_item != null) {
                    return found_item;
                }
                ++i;
            }
            return null;
        }
        GradeItem gitem = (GradeItem)grade;
        if (gitem.maxOccurs > 1) {
            int i = 0;
            while (i < gitem.maxOccurs) {
                if (item.equals(String.valueOf(gitem.name) + (i + 1))) {
                    return gitem;
                }
                ++i;
            }
        }
        return null;
    }

    public Double getFinalPercentGrade(int idx) {
        return this.getGradeForGroup(idx, this.grades, 0);
    }

    private Double getGradeForGroup(int idx, GradeGroup group, int indent) {
        private class GradeWeight {
            double grade;
            double weight;

            GradeWeight(double g, double w) {
                this.grade = g;
                this.weight = w;
            }
        }
        ArrayList<GradeWeight> child_grade = new ArrayList<GradeWeight>();
        int i = 0;
        while (i < group.items.length) {
            Double d;
            if (group.items[i] instanceof GradeGroup) {
                d = this.getGradeForGroup(idx, (GradeGroup)group.items[i], indent + 1);
                if (d != null) {
                    double dg = d;
                    dg = 100.0 * (dg / group.items[i].maxGrade);
                    child_grade.add(new GradeWeight(dg, group.items[i].weight));
                }
            } else {
                GradeItem item = (GradeItem)group.items[i];
                if (item.maxOccurs > 1) {
                    int j = 0;
                    while (j < item.maxOccurs) {
                        d = (Double)this.students[idx].grades.get(String.valueOf(item.name) + (j + 1));
                        if (d == null && this.gradeItemExistsForSomeStudent(String.valueOf(item.name) + (j + 1))) {
                            d = new Double(0.0);
                        }
                        if (d != null && item.weight > 0.0) {
                            double dg = d;
                            dg = 100.0 * (dg / item.maxGrade);
                            int k = 0;
                            while (k < item.countsAs) {
                                child_grade.add(new GradeWeight(dg, item.weight));
                                ++k;
                            }
                        }
                        ++j;
                    }
                } else {
                    d = (Double)this.students[idx].grades.get(item.name);
                    if (d == null && this.gradeItemExistsForSomeStudent(item.name)) {
                        d = new Double(0.0);
                    }
                    if (d != null && item.weight > 0.0) {
                        double dg = d;
                        dg = 100.0 * (dg / item.maxGrade);
                        int k = 0;
                        while (k < item.countsAs) {
                            child_grade.add(new GradeWeight(dg, item.weight));
                            ++k;
                        }
                    }
                }
            }
            ++i;
        }
        if (child_grade.size() == 0) {
            return null;
        }
        GradeWeight[] gw = child_grade.toArray(new GradeWeight[0]);
        int num_items = gw.length;
        if (group.maxItems >= 0 && gw.length > group.maxItems) {
            num_items = group.maxItems;
            Arrays.sort(gw, new Comparator(){

                public int compare(Object o1, Object o2) {
                    GradeWeight g1 = (GradeWeight)o1;
                    GradeWeight g2 = (GradeWeight)o2;
                    if (g1.grade < g2.grade) {
                        return 1;
                    }
                    if (g1.grade == g2.grade) {
                        return 0;
                    }
                    return -1;
                }
            });
        }
        double sum = 0.0;
        double weight = 0.0;
        int i2 = 0;
        while (i2 < num_items) {
            sum += gw[i2].grade * gw[i2].weight;
            weight += gw[i2].weight;
            ++i2;
        }
        return new Double(sum / weight);
    }

    private String getIndentationPrefix(int indent) {
        String prefix = "";
        int i = 0;
        while (i < indent) {
            prefix = String.valueOf(prefix) + "    ";
            ++i;
        }
        return prefix;
    }

    public Double getGrade(int idx, String item) {
        return (Double)this.students[idx].grades.get(item);
    }

    public String getFilename() {
        return this.curFilename;
    }

    public int getNumStudents() {
        return this.students.length;
    }

    public GradeGroup getGradeGroup() {
        return (GradeGroup)this.grades.clone();
    }

    public Student getStudent(int idx) {
        return (Student)this.students[idx].clone();
    }

    public double getLowerBoundForA() {
        return this.lowerBoundForA;
    }

    public double getLowerBoundForB() {
        return this.lowerBoundForB;
    }

    public double getLowerBoundForC() {
        return this.lowerBoundForC;
    }

    public double getLowerBoundForD() {
        return this.lowerBoundForD;
    }

    public void setLowerBoundForA(double bound) {
        this.lowerBoundForA = bound;
    }

    public void setLowerBoundForB(double bound) {
        this.lowerBoundForB = bound;
    }

    public void setLowerBoundForC(double bound) {
        this.lowerBoundForC = bound;
    }

    public void setLowerBoundForD(double bound) {
        this.lowerBoundForD = bound;
    }

    public double getMaxGrade(String name) {
        GradeObject item = this.getGradeObject(name, this.grades);
        return item.maxGrade;
    }

    public void setMaxGrade(String name, double amount) {
        GradeObject item = this.getGradeObject(name, this.grades);
        item.maxGrade = amount;
    }

    public int getCountsAs(String name) {
        GradeObject item = this.getGradeObject(name, this.grades);
        if (item instanceof GradeItem) {
            return ((GradeItem)item).countsAs;
        }
        return 1;
    }

    public void setCountsAs(String name, int amount) {
        GradeObject item = this.getGradeObject(name, this.grades);
        if (item instanceof GradeItem) {
            ((GradeItem)item).countsAs = amount;
        }
    }

    public double getWeight(String name) {
        GradeObject item = this.getGradeObject(name, this.grades);
        return item.weight;
    }

    public void setWeight(String name, double amount) {
        GradeObject item = this.getGradeObject(name, this.grades);
        item.weight = amount;
    }

    public int getMaxOccurs(String name) {
        GradeItem item = (GradeItem)this.getGradeObject(name, this.grades);
        return item.maxOccurs;
    }

    public boolean setMaxOccurs(String name, int amount) {
        GradeItem item = (GradeItem)this.getGradeObject(name, this.grades);
        int i = item.maxOccurs + 1;
        while (i < amount) {
            if (this.gradeItemExistsForSomeStudent(String.valueOf(item.name) + (i + 1))) {
                return false;
            }
            ++i;
        }
        item.maxOccurs = amount;
        return true;
    }

    public int getMaxItems(String name) {
        GradeGroup group = (GradeGroup)this.getGradeObject(name, this.grades);
        return group.maxItems;
    }

    public void setMaxItems(String name, int amount) {
        GradeGroup group = (GradeGroup)this.getGradeObject(name, this.grades);
        group.maxItems = amount;
    }

    public boolean delGradeObject(String name) {
        GradeObject obj = this.getGradeObject(name, this.grades);
        if (this.gradeObjectExistsForSomeStudent(obj)) {
            return false;
        }
        if (obj == this.grades) {
            return false;
        }
        return this.delGradeObject(obj, this.grades);
    }

    private boolean delGradeObject(GradeObject obj, GradeGroup group) {
        int i = 0;
        while (i < group.items.length) {
            if (group.items[i] == obj) {
                GradeObject[] children = new GradeObject[group.items.length - 1];
                int j = 0;
                int k = 0;
                while (j < group.items.length) {
                    if (group.items[j] != obj) {
                        children[k++] = group.items[j];
                    }
                    ++j;
                }
                group.items = children;
                return true;
            }
            if (group.items[i] instanceof GradeGroup && this.delGradeObject(obj, (GradeGroup)group.items[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean gradeObjectExistsForSomeStudent(GradeObject obj) {
        if (obj instanceof GradeGroup) {
            GradeGroup group = (GradeGroup)obj;
            int i = 0;
            while (i < group.items.length) {
                if (this.gradeObjectExistsForSomeStudent(group.items[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        GradeItem item = (GradeItem)obj;
        if (item.maxOccurs > 1) {
            int i = 0;
            while (i < item.maxOccurs) {
                if (this.gradeItemExistsForSomeStudent(String.valueOf(item.name) + (i + 1))) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return this.gradeItemExistsForSomeStudent(item.name);
    }

    private boolean gradeItemExistsForSomeStudent(String item) {
        int i = 0;
        while (i < this.students.length) {
            if (this.students[i].isActive && this.students[i].grades.get(item) != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addGradeItem(String parent, int idx) {
        String name = this.getUniqueName("New Item");
        GradeGroup group = (GradeGroup)this.getGradeObject(parent, this.grades);
        GradeItem newitem = new GradeItem();
        newitem.name = name;
        ArrayList<GradeItem> oldItems = new ArrayList<GradeItem>((Collection)Arrays.asList(group.items));
        oldItems.add(idx, newitem);
        group.items = oldItems.toArray(group.items);
    }

    public void addGradeGroup(String parent, int idx) {
        String name = this.getUniqueName("New Group");
        GradeGroup group = (GradeGroup)this.getGradeObject(parent, this.grades);
        GradeGroup newgroup = new GradeGroup();
        newgroup.name = name;
        ArrayList<GradeGroup> oldItems = new ArrayList<GradeGroup>((Collection)Arrays.asList(group.items));
        oldItems.add(idx, newgroup);
        group.items = oldItems.toArray(group.items);
    }

    private String getUniqueName(String base) {
        GradeObject obj = this.getGradeObject(base, this.grades);
        if (obj == null) {
            return base;
        }
        int i = 1;
        String basei;
        while ((obj = this.getGradeObject(basei = String.valueOf(base) + " (" + i + ")", this.grades)) != null) {
            ++i;
        }
        return basei;
    }

    private class RosterHandler
    extends DefaultHandler {
        private Logger logger = Logger.getLogger("edu.uwyo.cs.gradebook.model.Roster.RosterHandler");
        private String curString = null;
        private Student current = null;
        private String work = null;
        private String element = null;
        private ArrayList studentList = new ArrayList();
        private GradeGroup group = null;
        private GradeGroup topGroup = null;
        private GradeItem item = null;
        private Stack groupStack = new Stack();
        private double boundA = -1.0;
        private double boundB = -1.0;
        private double boundC = -1.0;
        private double boundD = -1.0;
        private int newYear = -1;
        private int newSemester = -1;
        private String newDepartment = null;
        private String newCourse = null;
        private String newSection = null;

        private RosterHandler() {
        }

        public void startDocument() throws SAXException {
            this.curString = "";
            this.current = null;
            this.work = null;
            this.element = null;
            this.studentList = new ArrayList();
            this.group = null;
            this.topGroup = null;
            this.item = null;
            this.groupStack = new Stack();
            this.boundA = -1.0;
            this.boundB = -1.0;
            this.boundC = -1.0;
            this.boundD = -1.0;
            this.newYear = -1;
            this.newSemester = -1;
            this.newDepartment = null;
            this.newCourse = null;
            this.newSection = null;
        }

        public void endDocument() throws SAXException {
            Roster.this.students = this.studentList.toArray(new Student[0]);
            Roster.this.grades = this.topGroup;
            if (this.boundA >= 0.0) {
                Roster.this.lowerBoundForA = this.boundA;
            }
            if (this.boundB >= 0.0) {
                Roster.this.lowerBoundForB = this.boundB;
            }
            if (this.boundC >= 0.0) {
                Roster.this.lowerBoundForC = this.boundC;
            }
            if (this.boundD >= 0.0) {
                Roster.this.lowerBoundForD = this.boundD;
            }
            if (this.newYear >= 0) {
                Roster.this.year = this.newYear;
            }
            if (this.newSemester >= 0) {
                Roster.this.semester = this.newSemester;
            }
            if (this.newDepartment != null) {
                Roster.this.department = this.newDepartment;
            }
            if (this.newCourse != null) {
                Roster.this.course = this.newCourse;
            }
            if (this.newSection != null) {
                Roster.this.section = this.newSection;
            }
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.curString = "";
            if (qName.equals("student")) {
                this.current = new Student();
                this.current.grades = new HashMap();
            } else if (qName.equals("gradegroup")) {
                GradeGroup newgroup = new GradeGroup();
                newgroup.name = "New Group";
                if (this.group == null) {
                    this.topGroup = newgroup;
                } else {
                    ArrayList<GradeGroup> oldItems = new ArrayList<GradeGroup>((Collection)Arrays.asList(this.group.items));
                    oldItems.add(newgroup);
                    this.group.items = oldItems.toArray(this.group.items);
                }
                this.groupStack.push(this.group);
                this.group = newgroup;
            } else if (qName.equals("gradeitem")) {
                this.item = new GradeItem();
                this.item.name = "New Item";
                ArrayList<GradeItem> oldItems = new ArrayList<GradeItem>((Collection)Arrays.asList(this.group.items));
                oldItems.add(this.item);
                this.group.items = oldItems.toArray(this.group.items);
            } else {
                this.element = qName;
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            this.curString = "";
            if (qName.equals("student")) {
                this.studentList.add(this.current);
                this.current = null;
            } else if (qName.equals("gradegroup")) {
                this.group = (GradeGroup)this.groupStack.pop();
            } else if (qName.equals("gradeitem")) {
                this.item = null;
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            String s = new String(ch, start, length).trim();
            if (this.curString == null || this.curString.equals("")) {
                this.curString = s;
            } else {
                s = this.curString = String.valueOf(this.curString) + s;
            }
            if (this.element.equals("active")) {
                if (!s.equals("")) {
                    this.current.isActive = s.equals("yes");
                }
            } else if (this.element.equals("course")) {
                if (this.current != null) {
                    if (this.current.course == null || !s.equals("")) {
                        this.current.course = s;
                    }
                } else if (!s.equals("")) {
                    this.newCourse = s;
                }
            } else if (this.element.equals("name")) {
                if (this.current != null) {
                    if (this.current.name == null || !s.equals("")) {
                        this.current.name = s;
                    }
                } else if (this.item != null) {
                    if (this.item.name == null || !s.equals("")) {
                        this.item.name = s;
                    }
                } else if (!(this.group == null || this.group.name != null && s.equals(""))) {
                    this.group.name = s;
                }
            } else if (this.element.equals("ssn")) {
                if (this.current.ssn == null || !s.equals("")) {
                    this.current.ssn = s;
                }
            } else if (this.element.equals("id")) {
                if (!s.equals("")) {
                    this.current.id = Integer.parseInt(s);
                }
            } else if (this.element.equals("email")) {
                if (this.current.email == null || !s.equals("")) {
                    this.current.email = s;
                }
            } else if (this.element.equals("work")) {
                if (this.work == null || !s.equals("")) {
                    this.work = s;
                }
            } else if (this.element.equals("grade")) {
                if (!s.equals("")) {
                    Double d = new Double(s);
                    this.current.grades.put(this.work, d);
                }
            } else if (this.element.equals("maxoccurs")) {
                if (!s.equals("")) {
                    this.item.maxOccurs = Integer.parseInt(s);
                }
            } else if (this.element.equals("countsas")) {
                if (!s.equals("")) {
                    this.item.countsAs = Integer.parseInt(s);
                }
            } else if (this.element.equals("maxgrade")) {
                if (this.item != null) {
                    if (!s.equals("")) {
                        this.item.maxGrade = Double.parseDouble(s);
                    }
                } else if (!s.equals("")) {
                    this.group.maxGrade = Double.parseDouble(s);
                }
            } else if (this.element.equals("weight")) {
                if (this.item != null) {
                    if (!s.equals("")) {
                        this.item.weight = Double.parseDouble(s);
                    }
                } else if (!s.equals("")) {
                    this.group.weight = Double.parseDouble(s);
                }
            } else if (this.element.equals("maxitems")) {
                if (!s.equals("")) {
                    this.group.maxItems = Integer.parseInt(s);
                }
            } else if (this.element.equals("lowerboundfora")) {
                if (!s.equals("")) {
                    this.boundA = Double.parseDouble(s);
                }
            } else if (this.element.equals("lowerboundforb")) {
                if (!s.equals("")) {
                    this.boundB = Double.parseDouble(s);
                }
            } else if (this.element.equals("lowerboundforc")) {
                if (!s.equals("")) {
                    this.boundC = Double.parseDouble(s);
                }
            } else if (this.element.equals("lowerboundford")) {
                if (!s.equals("")) {
                    this.boundD = Double.parseDouble(s);
                }
            } else if (this.element.equals("year")) {
                if (!s.equals("")) {
                    this.newYear = Integer.parseInt(s);
                }
            } else if (this.element.equals("semester")) {
                if (!s.equals("")) {
                    this.newSemester = Integer.parseInt(s);
                }
            } else if (this.element.equals("department")) {
                if (!s.equals("")) {
                    this.newDepartment = s;
                }
            } else if (this.element.equals("section") && !s.equals("")) {
                this.newSection = s;
            }
        }
    }
}

