/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.cs.gradebook.ui;

import edu.uwyo.cs.gradebook.ui.RosterTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.NumberFormatter;

public class GradeBounds
extends JFrame
implements PropertyChangeListener {
    private JFrame parentFrame;
    private RosterTableModel rosterModel;
    private ResourceBundle resbundle;
    private JFormattedTextField boundA;
    private JFormattedTextField boundB;
    private JFormattedTextField boundC;
    private JFormattedTextField boundD;

    public GradeBounds(JFrame parent, RosterTableModel roster, ResourceBundle bundle) {
        super("");
        this.parentFrame = parent;
        this.rosterModel = roster;
        this.resbundle = bundle;
        this.setTitle(this.resbundle.getString("boundsConstructor"));
        Container cp = this.getContentPane();
        JPanel labelPane = new JPanel();
        labelPane.setLayout(new GridLayout(0, 1));
        labelPane.add(new JLabel(this.resbundle.getString("boundA")));
        labelPane.add(new JLabel(this.resbundle.getString("boundB")));
        labelPane.add(new JLabel(this.resbundle.getString("boundC")));
        labelPane.add(new JLabel(this.resbundle.getString("boundD")));
        JPanel fieldPane = new JPanel();
        fieldPane.setLayout(new GridLayout(0, 1));
        NumberFormatter numberformat = new NumberFormatter();
        this.boundA = new JFormattedTextField(numberformat);
        this.boundA.setEditable(true);
        this.boundA.setColumns(5);
        this.boundA.addPropertyChangeListener(this);
        this.boundA.setFocusLostBehavior(1);
        fieldPane.add(this.boundA);
        this.boundB = new JFormattedTextField(numberformat);
        this.boundB.setEditable(true);
        this.boundB.setColumns(5);
        this.boundB.addPropertyChangeListener(this);
        this.boundB.setFocusLostBehavior(1);
        fieldPane.add(this.boundB);
        this.boundC = new JFormattedTextField(numberformat);
        this.boundC.setEditable(true);
        this.boundB.setColumns(5);
        this.boundC.addPropertyChangeListener(this);
        this.boundC.setFocusLostBehavior(1);
        fieldPane.add(this.boundC);
        this.boundD = new JFormattedTextField(numberformat);
        this.boundD.setEditable(true);
        this.boundB.setColumns(5);
        this.boundD.addPropertyChangeListener(this);
        this.boundD.setFocusLostBehavior(1);
        fieldPane.add(this.boundD);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)labelPane, "Center");
        contentPane.add((Component)fieldPane, "East");
        this.setContentPane(contentPane);
        this.setSize(300, 150);
    }

    public void show() {
        this.boundA.setValue(new Double(this.rosterModel.getLowerBoundForA()));
        this.boundB.setValue(new Double(this.rosterModel.getLowerBoundForB()));
        this.boundC.setValue(new Double(this.rosterModel.getLowerBoundForC()));
        this.boundD.setValue(new Double(this.rosterModel.getLowerBoundForD()));
        super.show();
    }

    public void propertyChange(PropertyChangeEvent e) {
        if ("value".equals(e.getPropertyName())) {
            Object source = e.getSource();
            if (source == this.boundA) {
                Number value = (Number)this.boundA.getValue();
                if (this.boundA.getValue() == null) {
                    this.boundA.setValue(new Double(this.rosterModel.getLowerBoundForA()));
                } else {
                    double amount = value.doubleValue();
                    this.rosterModel.setLowerBoundForA(amount);
                }
            } else if (source == this.boundB) {
                Number value = (Number)this.boundB.getValue();
                if (this.boundB.getValue() == null) {
                    this.boundB.setValue(new Double(this.rosterModel.getLowerBoundForB()));
                } else {
                    double amount = value.doubleValue();
                    this.rosterModel.setLowerBoundForB(amount);
                }
            } else if (source == this.boundC) {
                Number value = (Number)this.boundC.getValue();
                if (this.boundC.getValue() == null) {
                    this.boundC.setValue(new Double(this.rosterModel.getLowerBoundForC()));
                } else {
                    double amount = value.doubleValue();
                    this.rosterModel.setLowerBoundForC(amount);
                }
            } else if (source == this.boundD) {
                Number value = (Number)this.boundD.getValue();
                if (this.boundD.getValue() == null) {
                    this.boundD.setValue(new Double(this.rosterModel.getLowerBoundForD()));
                } else {
                    double amount = value.doubleValue();
                    this.rosterModel.setLowerBoundForD(amount);
                }
            }
        }
    }
}

