/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.cs.gradebook.ui;

import edu.uwyo.cs.gradebook.model.GradeGroup;
import edu.uwyo.cs.gradebook.model.GradeItem;
import edu.uwyo.cs.gradebook.model.GradeObject;
import edu.uwyo.cs.gradebook.ui.RosterTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.NumberFormatter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class GradePolicy
extends JFrame
implements PropertyChangeListener {
    private JFrame parentFrame;
    private RosterTableModel rosterModel;
    private ResourceBundle resbundle;
    private JPanel contentPane;
    private JPanel controlPane;
    private DefaultMutableTreeNode root;
    private MyDefaultTreeModel tmodel;
    private JTree tree;
    private JScrollPane treePane;
    private JPanel itemPane;
    private JFormattedTextField itemMaxGrade;
    private JFormattedTextField itemWeight;
    private JFormattedTextField itemMaxOccursOrItems;
    private JLabel itemMaxOccursOrItemsLabel;
    private JFormattedTextField itemCountsAs;
    private JLabel itemCountsAsLabel;
    private double maxGrade = -1.0;
    private double weight = -1.0;
    private int maxOccurs = -1;
    private int countsAs = -1;

    public GradePolicy(JFrame parent, RosterTableModel roster, ResourceBundle bundle) {
        super("");
        this.parentFrame = parent;
        this.rosterModel = roster;
        this.resbundle = bundle;
        this.setTitle(this.resbundle.getString("policyConstructor"));
        Container cp = this.getContentPane();
        this.setSize(600, 450);
        this.show();
    }

    public void rebuildTreePane() {
        GradeGroup rootnode = this.rosterModel.getGradeGroup();
        this.root = new DefaultMutableTreeNode(rootnode, true);
        this.createNodes(this.root, rootnode);
        this.tmodel = new MyDefaultTreeModel(this.root);
        this.tree = new JTree(this.tmodel);
        this.treePane = new JScrollPane(this.tree);
        this.tree.setEditable(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(true);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)GradePolicy.this.tree.getLastSelectedPathComponent();
                if (node == null) {
                    GradePolicy.this.itemMaxGrade.setValue(null);
                    GradePolicy.this.itemMaxGrade.setEditable(false);
                    GradePolicy.this.itemWeight.setValue(null);
                    GradePolicy.this.itemWeight.setEditable(false);
                    GradePolicy.this.itemMaxOccursOrItems.setValue(null);
                    GradePolicy.this.itemMaxOccursOrItems.setEditable(false);
                    GradePolicy.this.itemCountsAs.setValue(null);
                    GradePolicy.this.itemCountsAs.setEditable(false);
                } else {
                    Object nodeInfo = node.getUserObject();
                    if (!node.getAllowsChildren()) {
                        GradeItem item = (GradeItem)nodeInfo;
                        GradePolicy.this.maxGrade = item.maxGrade;
                        GradePolicy.this.weight = item.weight;
                        GradePolicy.this.maxOccurs = item.maxOccurs;
                        GradePolicy.this.itemMaxGrade.setValue(new Double(item.maxGrade));
                        GradePolicy.this.itemMaxGrade.setEditable(true);
                        GradePolicy.this.itemWeight.setValue(new Double(item.weight));
                        GradePolicy.this.itemWeight.setEditable(true);
                        if (item.maxOccurs > 0) {
                            GradePolicy.this.itemMaxOccursOrItems.setValue(new Integer(item.maxOccurs));
                        } else {
                            GradePolicy.this.itemMaxOccursOrItems.setValue(null);
                        }
                        GradePolicy.this.itemMaxOccursOrItems.setEditable(true);
                        GradePolicy.this.itemMaxOccursOrItemsLabel.setText(GradePolicy.this.resbundle.getString("maxOccurs"));
                        GradePolicy.this.itemCountsAsLabel.setVisible(true);
                        GradePolicy.this.itemCountsAs.setVisible(true);
                        GradePolicy.this.itemCountsAs.setValue(new Integer(item.countsAs));
                        GradePolicy.this.itemCountsAs.setEditable(true);
                    } else {
                        GradeGroup group = (GradeGroup)nodeInfo;
                        GradePolicy.this.maxGrade = group.maxGrade;
                        GradePolicy.this.weight = group.weight;
                        GradePolicy.this.maxOccurs = group.maxItems;
                        GradePolicy.this.itemMaxGrade.setValue(new Double(group.maxGrade));
                        GradePolicy.this.itemMaxGrade.setEditable(true);
                        GradePolicy.this.itemWeight.setValue(new Double(group.weight));
                        GradePolicy.this.itemWeight.setEditable(true);
                        if (group.maxItems > 0) {
                            GradePolicy.this.itemMaxOccursOrItems.setValue(new Integer(group.maxItems));
                        } else {
                            GradePolicy.this.itemMaxOccursOrItems.setValue(null);
                        }
                        GradePolicy.this.itemMaxOccursOrItems.setEditable(true);
                        GradePolicy.this.itemMaxOccursOrItemsLabel.setText(GradePolicy.this.resbundle.getString("maxItems"));
                        GradePolicy.this.itemCountsAsLabel.setVisible(true);
                        GradePolicy.this.itemCountsAs.setVisible(true);
                        GradePolicy.this.itemCountsAs.setValue("");
                        GradePolicy.this.itemCountsAs.setEditable(true);
                    }
                }
            }
        });
        this.tmodel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
                try {
                    int index = e.getChildIndices()[0];
                    node = (DefaultMutableTreeNode)node.getChildAt(index);
                }
                catch (NullPointerException index) {
                    // empty catch block
                }
                GradeObject grade = null;
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                grade = parent == null ? GradePolicy.this.rosterModel.getGradeGroup() : ((GradeGroup)parent.getUserObject()).items[parent.getIndex(node)];
                String new_name = (String)node.getUserObject();
                if (GradePolicy.this.rosterModel.setGradeItemName(grade.name, new_name)) {
                    node.setUserObject(GradePolicy.this.rosterModel.getGradeObject(new_name));
                } else {
                    JOptionPane.showMessageDialog(GradePolicy.this, GradePolicy.this.resbundle.getString("existingGradeObject"), GradePolicy.this.resbundle.getString("error"), 0);
                    node.setUserObject(GradePolicy.this.rosterModel.getGradeObject(grade.name));
                }
            }

            public void treeNodesInserted(TreeModelEvent e) {
            }

            public void treeNodesRemoved(TreeModelEvent e) {
            }

            public void treeStructureChanged(TreeModelEvent e) {
            }
        });
        this.itemPane = new JPanel();
        this.itemPane.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.itemPane.setLayout(new BorderLayout());
        JPanel labelPane = new JPanel();
        labelPane.setLayout(new GridLayout(0, 1));
        labelPane.add(new JLabel(this.resbundle.getString("maxGrade")));
        labelPane.add(new JLabel(this.resbundle.getString("weight")));
        this.itemMaxOccursOrItemsLabel = new JLabel(this.resbundle.getString("maxOccurs"));
        labelPane.add(this.itemMaxOccursOrItemsLabel);
        this.itemCountsAsLabel = new JLabel(this.resbundle.getString("countsAs"));
        labelPane.add(this.itemCountsAsLabel);
        JPanel fieldPane = new JPanel();
        fieldPane.setLayout(new GridLayout(0, 1));
        NumberFormatter numberformat = new NumberFormatter();
        NumberFormat intfmt = NumberFormat.getInstance();
        intfmt.setParseIntegerOnly(true);
        NumberFormatter intformat = new NumberFormatter(intfmt);
        this.itemMaxGrade = new JFormattedTextField(numberformat);
        this.itemMaxGrade.setEditable(false);
        this.itemMaxGrade.setColumns(5);
        this.itemMaxGrade.addPropertyChangeListener(this);
        this.itemMaxGrade.setFocusLostBehavior(1);
        fieldPane.add(this.itemMaxGrade);
        this.itemWeight = new JFormattedTextField(numberformat);
        this.itemWeight.setEditable(false);
        this.itemWeight.setColumns(5);
        this.itemWeight.addPropertyChangeListener(this);
        this.itemWeight.setFocusLostBehavior(1);
        fieldPane.add(this.itemWeight);
        this.itemMaxOccursOrItems = new JFormattedTextField(intformat);
        this.itemMaxOccursOrItems.setEditable(false);
        this.itemMaxOccursOrItems.setColumns(5);
        this.itemMaxOccursOrItems.addPropertyChangeListener(this);
        this.itemMaxOccursOrItems.setFocusLostBehavior(1);
        fieldPane.add(this.itemMaxOccursOrItems);
        this.itemCountsAs = new JFormattedTextField(intformat);
        this.itemCountsAs.setEditable(false);
        this.itemCountsAs.setColumns(5);
        this.itemCountsAs.addPropertyChangeListener(this);
        this.itemCountsAs.setFocusLostBehavior(1);
        fieldPane.add(this.itemCountsAs);
        this.itemPane.add((Component)labelPane, "Center");
        this.itemPane.add((Component)fieldPane, "East");
        JPanel buttonPane = new JPanel();
        buttonPane.add(new JButton(new addItemAction()));
        buttonPane.add(new JButton(new addGroupAction()));
        buttonPane.add(new JButton(new delItemAction()));
        this.controlPane = new JPanel();
        this.controlPane.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.controlPane.setLayout(new BorderLayout());
        this.controlPane.add((Component)this.itemPane, "Center");
        this.controlPane.add((Component)buttonPane, "South");
        this.contentPane = new JPanel();
        this.contentPane.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)this.treePane, "Center");
        this.contentPane.add((Component)this.controlPane, "South");
        this.setContentPane(this.contentPane);
        Enumeration<TreeNode> e = this.root.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            this.tree.makeVisible(new TreePath(((DefaultMutableTreeNode)e.nextElement()).getPath()));
        }
        this.tree.makeVisible(new TreePath(this.root.getPath()));
        super.show();
    }

    public void show() {
        this.rebuildTreePane();
    }

    public void createNodes(DefaultMutableTreeNode pnode, GradeGroup group) {
        int i = 0;
        while (i < group.items.length) {
            DefaultMutableTreeNode node;
            if (group.items[i] instanceof GradeGroup) {
                GradeGroup subgroup = (GradeGroup)group.items[i];
                node = new DefaultMutableTreeNode(subgroup, true);
                this.createNodes(node, subgroup);
                pnode.add(node);
            } else {
                GradeItem item = (GradeItem)group.items[i];
                node = new DefaultMutableTreeNode(item, false);
                pnode.add(node);
            }
            ++i;
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        if ("value".equals(e.getPropertyName())) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            Object source = e.getSource();
            if (source == this.itemMaxGrade) {
                Number value = (Number)this.itemMaxGrade.getValue();
                if (value == null) {
                    GradeObject item = (GradeObject)node.getUserObject();
                    this.itemMaxGrade.setValue(new Double(this.rosterModel.getMaxGrade(item.name)));
                } else {
                    double amount = value.doubleValue();
                    if (amount == this.maxGrade) {
                        return;
                    }
                    GradeObject item = (GradeObject)node.getUserObject();
                    this.rosterModel.setMaxGrade(item.name, amount);
                    item.maxGrade = amount;
                }
            } else if (source == this.itemWeight) {
                Number value = (Number)this.itemWeight.getValue();
                if (value == null) {
                    GradeObject item = (GradeObject)node.getUserObject();
                    this.itemWeight.setValue(new Double(this.rosterModel.getWeight(item.name)));
                } else {
                    double amount = value.doubleValue();
                    if (amount == this.weight) {
                        return;
                    }
                    GradeObject item = (GradeObject)node.getUserObject();
                    this.rosterModel.setWeight(item.name, amount);
                    item.weight = amount;
                }
            } else if (source == this.itemMaxOccursOrItems) {
                Number value = (Number)this.itemMaxOccursOrItems.getValue();
                int amount = value == null ? -1 : value.intValue();
                if (amount == this.maxOccurs) {
                    return;
                }
                if (!node.getAllowsChildren()) {
                    GradeItem item = (GradeItem)node.getUserObject();
                    if (this.rosterModel.setMaxOccurs(item.name, amount)) {
                        item.maxOccurs = amount;
                    } else {
                        JOptionPane.showMessageDialog(this, this.resbundle.getString("existingGrades"), this.resbundle.getString("error"), 0);
                        this.itemMaxOccursOrItems.setValue(new Integer(this.rosterModel.getMaxOccurs(item.name)));
                    }
                } else {
                    GradeGroup group = (GradeGroup)node.getUserObject();
                    this.rosterModel.setMaxItems(group.name, amount);
                    group.maxItems = amount;
                }
            } else if (source == this.itemCountsAs) {
                Number value = (Number)this.itemCountsAs.getValue();
                int amount = value == null ? -1 : value.intValue();
                if (amount == this.countsAs) {
                    return;
                }
                GradeItem item = (GradeItem)node.getUserObject();
                this.rosterModel.setCountsAs(item.name, amount);
                item.countsAs = amount;
            }
        }
    }

    private class addItemAction
    extends AbstractAction {
        public addItemAction() {
            super(GradePolicy.this.resbundle.getString("addGradeItem"));
        }

        public void actionPerformed(ActionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)GradePolicy.this.tree.getLastSelectedPathComponent();
            int idx = -1;
            if (node == null) {
                node = GradePolicy.this.root;
            } else if (!node.getAllowsChildren()) {
                TreeNode parent = node.getParent();
                idx = parent.getIndex(node) + 1;
                node = (DefaultMutableTreeNode)parent;
            }
            GradeGroup group = (GradeGroup)node.getUserObject();
            if (idx < 0) {
                idx = group.items.length;
            }
            GradePolicy.this.rosterModel.addGradeItem(group.name, idx);
            GradePolicy.this.rebuildTreePane();
        }
    }

    private class addGroupAction
    extends AbstractAction {
        public addGroupAction() {
            super(GradePolicy.this.resbundle.getString("addGradeGroup"));
        }

        public void actionPerformed(ActionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)GradePolicy.this.tree.getLastSelectedPathComponent();
            int idx = -1;
            if (node == null) {
                node = GradePolicy.this.root;
            } else if (!node.getAllowsChildren()) {
                TreeNode parent = node.getParent();
                idx = parent.getIndex(node) + 1;
                node = (DefaultMutableTreeNode)parent;
            }
            GradeGroup group = (GradeGroup)node.getUserObject();
            if (idx < 0) {
                idx = group.items.length;
            }
            GradePolicy.this.rosterModel.addGradeGroup(group.name, idx);
            GradePolicy.this.rebuildTreePane();
        }
    }

    private class delItemAction
    extends AbstractAction {
        public delItemAction() {
            super(GradePolicy.this.resbundle.getString("deleteGradeItem"));
        }

        public void actionPerformed(ActionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)GradePolicy.this.tree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            GradeObject item = (GradeObject)node.getUserObject();
            if (GradePolicy.this.rosterModel.delGradeObject(item.name)) {
                GradePolicy.this.rebuildTreePane();
            } else {
                JOptionPane.showMessageDialog(GradePolicy.this, GradePolicy.this.resbundle.getString("existingGrades"), GradePolicy.this.resbundle.getString("error"), 0);
            }
        }
    }

    private class MyDefaultTreeModel
    extends DefaultTreeModel {
        public MyDefaultTreeModel(TreeNode node) {
            super(node);
        }

        public void fireTreeStructureChanged(TreeNode root) {
            int num_children = this.getChildCount(root);
            int[] children_idx = new int[num_children];
            int i = 0;
            while (i < num_children) {
                children_idx[i] = i;
                ++i;
            }
            Object[] children = new Object[num_children];
            int i2 = 0;
            while (i2 < num_children) {
                children[i2] = this.getChild(root, i2);
                ++i2;
            }
            this.fireTreeStructureChanged(root, this.getPathToRoot(root), children_idx, children);
        }
    }
}

