/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.cs.gradebook.ui;

import edu.uwyo.cs.gradebook.model.Student;
import edu.uwyo.cs.gradebook.ui.AboutBox;
import edu.uwyo.cs.gradebook.ui.GradeBounds;
import edu.uwyo.cs.gradebook.ui.GradePolicy;
import edu.uwyo.cs.gradebook.ui.Preferences;
import edu.uwyo.cs.gradebook.ui.RosterDownloadParams;
import edu.uwyo.cs.gradebook.ui.RosterImportParams;
import edu.uwyo.cs.gradebook.ui.RosterPasswordParams;
import edu.uwyo.cs.gradebook.ui.RosterTableModel;
import edu.uwyo.cs.gradebook.ui.StudentEditor;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.prefs.BackingStoreException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class Gradebook
extends JFrame {
    private java.util.prefs.Preferences userprefs = java.util.prefs.Preferences.userRoot().node("/edu/uwyo/cs/gradebook/ui/Gradebook");
    private static final String OPTION_DIR_GBK_FILES = "gbkdir";
    private static final String OPTION_DIR_HTML_FILES = "htmldir";
    private static final String OPTION_DIR_TXT_FILES = "txtdir";
    private static final String EXTENSION = "gbk";
    private static final String GBK_DESCRIPTION = "Gradebook Files";
    private static final int NO_GRADES = 1;
    private static final int ALL_GRADES = 2;
    private static final int CURRENT_GRADE = 3;
    private static ArrayList gradebooks = new ArrayList();
    protected ResourceBundle resbundle;
    protected AboutBox aboutBox;
    protected Preferences prefs;
    protected Action newAction;
    protected Action openAction;
    protected Action closeAction;
    protected Action exitAction;
    protected Action saveAction;
    protected Action saveAsAction;
    protected Action exportCSVAction;
    protected Action exportHTMLAction;
    protected Action mergeAction;
    protected Action importAction;
    protected Action newStudentAction;
    protected Action undoAction;
    protected Action cutAction;
    protected Action copyAction;
    protected Action pasteAction;
    protected Action clearAction;
    protected Action selectAllAction;
    protected Action gradePolicyAction;
    protected Action gradeBoundsAction;
    protected JMenuBar mainMenuBar = new JMenuBar();
    protected JMenu fileMenu;
    protected JMenu studentMenu;
    protected JMenu editMenu;
    protected JMenu gradesMenu;
    protected JMenu viewMenu;
    protected JMenu sortMenu;
    private Object macExtensions = null;
    private RosterTableModel roster = null;
    private JTable table = null;
    private GradeBounds boundsBox = null;
    private GradePolicy policyBox = null;
    private RosterDownloadParams downloadBox = null;
    private RosterPasswordParams passwordBox = null;
    private RosterImportParams importBox = null;

    public Gradebook() {
        super("");
        boolean isMacos;
        boolean bl = isMacos = System.getProperty("mrj.version") != null;
        if (isMacos) {
            try {
                Class<?> macExtensionsClass = Class.forName("edu.uwyo.cs.gradebook.ui.GradebookMacExtensions");
                this.macExtensions = macExtensionsClass.getConstructor(null).newInstance(null);
                macExtensionsClass.getDeclaredMethod("init", this.getClass()).invoke(this.macExtensions, this);
            }
            catch (Exception e) {
                System.out.println("Unable to load MacOS Extensions");
            }
        }
        this.resbundle = ResourceBundle.getBundle("gradebookstrings", Locale.getDefault());
        this.setTitle(this.resbundle.getString("frameConstructor"));
        this.createActions();
        this.addMenus(isMacos);
        this.aboutBox = new AboutBox();
        this.prefs = new Preferences();
        Toolkit.getDefaultToolkit();
        Container cp = this.getContentPane();
        this.roster = new RosterTableModel(this.resbundle, this);
        this.table = new JTable(this.roster);
        this.roster.setTable(this.table);
        cp.add(new JScrollPane(this.table));
        this.pack();
        this.setVisible(true);
    }

    public void show() {
        boolean found = false;
        Iterator iter = gradebooks.iterator();
        while (iter.hasNext()) {
            Gradebook g = (Gradebook)iter.next();
            if (g != this) continue;
            found = true;
            break;
        }
        if (!found) {
            gradebooks.add(this);
        }
        super.show();
    }

    public void hide() {
        super.hide();
    }

    public static boolean allGradebooksSaved() {
        boolean allSaved = true;
        Iterator iter = gradebooks.iterator();
        while (iter.hasNext()) {
            Gradebook gradebook = (Gradebook)iter.next();
            if (!gradebook.roster.isDirty()) continue;
            gradebook.show();
            allSaved = false;
        }
        return allSaved;
    }

    public void about() {
        this.aboutBox.setResizable(false);
        this.aboutBox.setVisible(true);
        this.aboutBox.show();
    }

    public void preferences() {
        this.prefs.setResizable(false);
        this.prefs.setVisible(true);
        this.prefs.show();
    }

    public void quit() {
        int answer;
        if (!Gradebook.allGradebooksSaved() && (answer = JOptionPane.showConfirmDialog(this, "Are you sure?\nOne or more gradebooks are not saved.\nProceeding will delete all changes.")) != 0) {
            return;
        }
        System.exit(0);
    }

    public void createActions() {
        int shortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.newAction = new newActionClass(this.resbundle.getString("newItem"), KeyStroke.getKeyStroke(78, shortcutKeyMask));
        this.openAction = new openActionClass(this.resbundle.getString("openItem"), KeyStroke.getKeyStroke(79, shortcutKeyMask));
        this.closeAction = new closeActionClass(this.resbundle.getString("closeItem"), KeyStroke.getKeyStroke(87, shortcutKeyMask));
        this.exitAction = new exitActionClass(this.resbundle.getString("exitItem"), KeyStroke.getKeyStroke(81, shortcutKeyMask));
        this.saveAction = new saveActionClass(this.resbundle.getString("saveItem"), KeyStroke.getKeyStroke(83, shortcutKeyMask));
        this.saveAsAction = new saveAsActionClass(this.resbundle.getString("saveAsItem"));
        this.exportCSVAction = new exportCSVActionClass(this.resbundle.getString("exportCSVItem"));
        this.exportHTMLAction = new exportHTMLActionClass(this.resbundle.getString("exportHTMLItem"));
        this.newStudentAction = new newStudentActionClass(this.resbundle.getString("newStudentItem"));
        this.importAction = new importActionClass(this.resbundle.getString("importItem"));
        this.undoAction = new undoActionClass(this.resbundle.getString("undoItem"), KeyStroke.getKeyStroke(90, shortcutKeyMask));
        this.cutAction = new cutActionClass(this.resbundle.getString("cutItem"), KeyStroke.getKeyStroke(88, shortcutKeyMask));
        this.copyAction = new copyActionClass(this.resbundle.getString("copyItem"), KeyStroke.getKeyStroke(67, shortcutKeyMask));
        this.pasteAction = new pasteActionClass(this.resbundle.getString("pasteItem"), KeyStroke.getKeyStroke(86, shortcutKeyMask));
        this.clearAction = new clearActionClass(this.resbundle.getString("clearItem"));
        this.selectAllAction = new selectAllActionClass(this.resbundle.getString("selectAllItem"), KeyStroke.getKeyStroke(65, shortcutKeyMask));
        this.gradePolicyAction = new gradePolicyActionClass(this.resbundle.getString("gradePolicyItem"));
        this.gradeBoundsAction = new gradeBoundsActionClass(this.resbundle.getString("gradeBoundsItem"));
    }

    public void addMenus(boolean isMacos) {
        this.fileMenu = new JMenu(this.resbundle.getString("fileMenu"));
        this.fileMenu.add(new JMenuItem(this.newAction));
        this.fileMenu.add(new JMenuItem(this.openAction));
        this.fileMenu.add(new JMenuItem(this.closeAction));
        this.fileMenu.add(new JMenuItem(this.saveAction));
        this.fileMenu.add(new JMenuItem(this.saveAsAction));
        this.fileMenu.addSeparator();
        this.fileMenu.add(new JMenuItem(this.exportCSVAction));
        this.fileMenu.add(new JMenuItem(this.exportHTMLAction));
        this.fileMenu.addSeparator();
        this.fileMenu.add(new JMenuItem(this.importAction));
        if (!isMacos) {
            this.fileMenu.addSeparator();
            this.fileMenu.add(new JMenuItem(this.exitAction));
        }
        this.mainMenuBar.add(this.fileMenu);
        this.editMenu = new JMenu(this.resbundle.getString("editMenu"));
        this.editMenu.add(new JMenuItem(this.undoAction));
        this.editMenu.addSeparator();
        this.editMenu.add(new JMenuItem(this.cutAction));
        this.editMenu.add(new JMenuItem(this.copyAction));
        this.editMenu.add(new JMenuItem(this.pasteAction));
        this.editMenu.add(new JMenuItem(this.clearAction));
        this.editMenu.addSeparator();
        this.editMenu.add(new JMenuItem(this.selectAllAction));
        this.studentMenu = new JMenu(this.resbundle.getString("studentsMenu"));
        this.studentMenu.add(new JMenuItem(this.newStudentAction));
        this.mainMenuBar.add(this.studentMenu);
        this.gradesMenu = new JMenu(this.resbundle.getString("gradesMenu"));
        this.gradesMenu.add(new JMenuItem(this.gradePolicyAction));
        this.gradesMenu.add(new JMenuItem(this.gradeBoundsAction));
        this.mainMenuBar.add(this.gradesMenu);
        this.viewMenu = new JMenu(this.resbundle.getString("viewMenu"));
        this.viewMenu.add(new JMenuItem(new setViewActionClass(this.resbundle.getString("viewAll"), new int[]{8, 1, 2, 3, 4, 5, 6, 7}, 2, new int[]{2})));
        this.viewMenu.add(new JMenuItem(new setViewActionClass(this.resbundle.getString("viewAddGrade"), new int[]{8, 2, 6, 7}, 3, new int[]{2})));
        this.viewMenu.add(new JMenuItem(new setViewActionClass(this.resbundle.getString("viewPostGrades"), new int[]{1, 2, 3, 6, 7}, 2, new int[]{1, 2})));
        this.viewMenu.add(new JMenuItem(new setViewActionClass(this.resbundle.getString("viewPublicGrades"), new int[]{4, 6, 7}, 2, new int[]{4})));
        this.mainMenuBar.add(this.viewMenu);
        this.sortMenu = new JMenu(this.resbundle.getString("sortMenu"));
        this.sortMenu.add(new JMenuItem(new setSortActionClass(this.resbundle.getString("sortAscName"), new int[]{2}, true)));
        this.sortMenu.add(new JMenuItem(new setSortActionClass(this.resbundle.getString("sortAscCourseName"), new int[]{1, 2}, true)));
        this.sortMenu.add(new JMenuItem(new setSortActionClass(this.resbundle.getString("sortAscId"), new int[]{4}, true)));
        this.sortMenu.add(new JMenuItem(new setSortActionClass(this.resbundle.getString("sortAscFinalGrade"), new int[]{7}, true)));
        this.sortMenu.add(new JMenuItem(new setSortActionClass(this.resbundle.getString("sortAscCurrentColumn"), new int[]{-1}, true)));
        this.sortMenu.addSeparator();
        this.sortMenu.add(new JMenuItem(new setSortActionClass(this.resbundle.getString("sortDescName"), new int[]{2}, false)));
        this.sortMenu.add(new JMenuItem(new setSortActionClass(this.resbundle.getString("sortDescCourseName"), new int[]{1, 2}, false)));
        this.sortMenu.add(new JMenuItem(new setSortActionClass(this.resbundle.getString("sortDescId"), new int[]{4}, false)));
        this.sortMenu.add(new JMenuItem(new setSortActionClass(this.resbundle.getString("sortDescFinalGrade"), new int[]{7}, false)));
        this.sortMenu.add(new JMenuItem(new setSortActionClass(this.resbundle.getString("sortDescCurrentColumn"), new int[]{-1}, false)));
        this.mainMenuBar.add(this.sortMenu);
        this.setJMenuBar(this.mainMenuBar);
    }

    public Gradebook getGradebookWithFile(String file) {
        Iterator iter = gradebooks.iterator();
        while (iter.hasNext()) {
            Gradebook gradebook = (Gradebook)iter.next();
            if (!file.equals(gradebook.roster.getFilename())) continue;
            return gradebook;
        }
        return null;
    }

    public void openFile(File file) {
        String filename;
        try {
            filename = file.getCanonicalPath();
        }
        catch (IOException ex) {
            System.err.println("Unable to open file: " + ex);
            return;
        }
        Gradebook g = this.getGradebookWithFile(filename);
        if (g == null) {
            g = this.roster.getFilename() == null ? this : new Gradebook();
            g.roster.openFile(filename);
        }
        g.show();
    }

    public String getExtension(String filename) {
        String extension = null;
        int i = filename.lastIndexOf(46);
        if (i > 0 && i < filename.length() - 1) {
            extension = filename.substring(i + 1).toLowerCase();
        }
        return extension;
    }

    public void handleOpen() {
        int answer;
        if (this.roster != null && this.roster.isDirty() && (answer = JOptionPane.showConfirmDialog(this, "Are you sure?\nCurrent gradebook is not saved.\nProceeding will delete all changes.")) != 0) {
            return;
        }
        String defdir = this.userprefs.get(OPTION_DIR_GBK_FILES, null);
        JFileChooser chooser = new JFileChooser(defdir);
        chooser.setFileFilter(new GradebookFileFilter(GBK_DESCRIPTION, EXTENSION));
        chooser.setFileSystemView(new GradebookFileSystemView(chooser.getFileSystemView()));
        int rVal = chooser.showOpenDialog(this);
        if (rVal == 0) {
            try {
                this.roster.openFile(chooser.getSelectedFile().getCanonicalPath());
                File dir = chooser.getSelectedFile().getParentFile();
                if (dir != null) {
                    this.userprefs.put(OPTION_DIR_GBK_FILES, dir.getCanonicalPath());
                }
                try {
                    this.userprefs.flush();
                }
                catch (BackingStoreException ex) {}
            }
            catch (IOException ex) {
                System.err.println("Unable to open file: " + ex);
            }
        }
    }

    public void importFile() {
        String defdir = this.userprefs.get(OPTION_DIR_TXT_FILES, null);
        JFileChooser chooser = new JFileChooser(defdir);
        chooser.setFileFilter(new GradebookFileFilter("Comma-Separated Files", "txt"));
        chooser.setFileSystemView(new GradebookFileSystemView(chooser.getFileSystemView()));
        int rVal = chooser.showOpenDialog(this);
        if (rVal == 0) {
            try {
                File file = chooser.getSelectedFile();
                String filename = chooser.getSelectedFile().getCanonicalPath();
                this.roster.importFile(file.getCanonicalPath());
                File dir = chooser.getSelectedFile().getParentFile();
                if (dir != null) {
                    this.userprefs.put(OPTION_DIR_TXT_FILES, dir.getCanonicalPath());
                }
                try {
                    this.userprefs.flush();
                }
                catch (BackingStoreException ex) {}
            }
            catch (IOException ex) {
                System.err.println("Unable to import file: " + ex);
            }
        }
    }

    public static void main(String[] args) {
        new Gradebook();
    }

    public class GradebookFileSystemView
    extends FileSystemView {
        FileSystemView _parent;

        public GradebookFileSystemView(FileSystemView parent) {
            this._parent = parent;
        }

        public boolean isRoot(File f) {
            return this._parent.isRoot(f);
        }

        public Boolean isTraversable(File f) {
            return this._parent.isTraversable(f);
        }

        public String getSystemDisplayName(File f) {
            return this._parent.getSystemDisplayName(f);
        }

        public String getSystemTypeDescription(File f) {
            return this._parent.getSystemTypeDescription(f);
        }

        public Icon getSystemIcon(File f) {
            return this._parent.getSystemIcon(f);
        }

        public boolean isParent(File folder, File file) {
            return this._parent.isParent(folder, file);
        }

        public File getChild(File folder, String filename) {
            return this._parent.getChild(folder, filename);
        }

        public boolean isFileSystem(File f) {
            return this._parent.isFileSystem(f);
        }

        public File createNewFolder(File containingDir) throws IOException {
            return this._parent.createNewFolder(containingDir);
        }

        public boolean isHiddenFile(File f) {
            if (this._parent.isHiddenFile(f)) {
                return true;
            }
            String name = f.getName();
            return name.endsWith("~");
        }

        public boolean isFileSystemRoot(File dir) {
            return this._parent.isFileSystemRoot(dir);
        }

        public boolean isDrive(File dir) {
            return this._parent.isDrive(dir);
        }

        public boolean isFloppyDrive(File dir) {
            return this._parent.isFloppyDrive(dir);
        }

        public boolean isComputerNode(File dir) {
            return this._parent.isComputerNode(dir);
        }

        public File[] getRoots() {
            return this._parent.getRoots();
        }

        public File getHomeDirectory() {
            return this._parent.getHomeDirectory();
        }

        public File getDefaultDirectory() {
            return this._parent.getDefaultDirectory();
        }

        public File createFileObject(File dir, String filename) {
            return this._parent.createFileObject(dir, filename);
        }

        public File createFileObject(String path) {
            return this._parent.createFileObject(path);
        }

        public File[] getFiles(File dir, boolean useFileHiding) {
            File[] files = this._parent.getFiles(dir, useFileHiding);
            ArrayList<File> filteredFiles = new ArrayList<File>();
            for (int i = 0; i < files.length; ++i) {
                if (this.isHiddenFile(files[i])) continue;
                filteredFiles.add(files[i]);
            }
            return filteredFiles.toArray(new File[0]);
        }

        public File getParentDirectory(File dir) {
            return this._parent.getParentDirectory(dir);
        }

        public File createFileSystemRoot(File f) {
            return super.createFileSystemRoot(f);
        }
    }

    public class GradebookFileFilter
    extends FileFilter {
        String matchExtension = null;
        String description = null;

        public GradebookFileFilter(String desc, String ext) {
            this.matchExtension = ext;
            this.description = desc;
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = Gradebook.this.getExtension(f.getName());
            return extension != null && extension.equals(this.matchExtension);
        }

        public String getDescription() {
            return this.description;
        }
    }

    public class setSortActionClass
    extends AbstractAction {
        int[] sortBy;
        boolean ascending;

        public setSortActionClass(String text, int[] sortBy, boolean ascending) {
            super(text);
            this.sortBy = sortBy;
            this.ascending = ascending;
        }

        public void actionPerformed(ActionEvent e) {
            int[] sort_by = new int[this.sortBy.length];
            for (int i = 0; i < this.sortBy.length; ++i) {
                sort_by[i] = this.sortBy[i];
                if (sort_by[i] != -1) continue;
                int col = Gradebook.this.table.getEditingColumn();
                if (col < 0) {
                    col = Gradebook.this.table.getSelectedColumn();
                }
                if (col < 0) {
                    JOptionPane.showMessageDialog(Gradebook.this, Gradebook.this.resbundle.getString("noSelectedColumn"), Gradebook.this.resbundle.getString("error"), 0);
                    return;
                }
                sort_by[i] = Gradebook.this.roster.getColumnIndex(col);
            }
            Gradebook.this.roster.setSortFields(sort_by, this.ascending);
        }
    }

    public class setViewActionClass
    extends AbstractAction {
        int[] fields;
        int grades;
        int[] sortBy;

        public setViewActionClass(String text, int[] fields, int grades, int[] sortBy) {
            super(text);
            this.fields = fields;
            this.grades = grades;
            this.sortBy = sortBy;
        }

        public void actionPerformed(ActionEvent e) {
            String[] headings;
            if (this.grades == 2) {
                headings = Gradebook.this.roster.getAllGradeHeadings();
            } else if (this.grades == 1) {
                headings = new String[]{};
            } else {
                int col = Gradebook.this.table.getEditingColumn();
                if (col < 0) {
                    col = Gradebook.this.table.getSelectedColumn();
                }
                if (col < 0) {
                    JOptionPane.showMessageDialog(Gradebook.this, Gradebook.this.resbundle.getString("noSelectedColumn"), Gradebook.this.resbundle.getString("error"), 0);
                    return;
                }
                headings = new String[]{Gradebook.this.roster.getColumnName(col)};
            }
            Gradebook.this.roster.setViewFields(this.fields, headings);
            Gradebook.this.roster.setSortFields(this.sortBy, true);
        }
    }

    public class newStudentActionClass
    extends AbstractAction {
        public newStudentActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            Student student = new Student();
            student.isActive = true;
            student.course = Gradebook.this.roster.getCourse();
            StudentEditor editor = new StudentEditor(Gradebook.this, Gradebook.this.roster, student, Gradebook.this.resbundle);
            editor.show();
        }
    }

    public class selectAllActionClass
    extends AbstractAction {
        public selectAllActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            System.out.println("Select All...");
        }
    }

    public class clearActionClass
    extends AbstractAction {
        public clearActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            System.out.println("Clear...");
        }
    }

    public class pasteActionClass
    extends AbstractAction {
        public pasteActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            System.out.println("Paste...");
        }
    }

    public class copyActionClass
    extends AbstractAction {
        public copyActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            System.out.println("Copy...");
        }
    }

    public class cutActionClass
    extends AbstractAction {
        public cutActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            System.out.println("Cut...");
        }
    }

    public class undoActionClass
    extends AbstractAction {
        public undoActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            System.out.println("Undo...");
        }
    }

    public class exportHTMLActionClass
    extends AbstractAction {
        public exportHTMLActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            String defdir = Gradebook.this.userprefs.get(Gradebook.OPTION_DIR_HTML_FILES, null);
            JFileChooser chooser = new JFileChooser(defdir);
            chooser.setFileFilter(new GradebookFileFilter("HTML Files", "html"));
            chooser.setFileSystemView(new GradebookFileSystemView(chooser.getFileSystemView()));
            int rVal = chooser.showSaveDialog(Gradebook.this);
            if (rVal == 0) {
                try {
                    int answer;
                    File file = chooser.getSelectedFile();
                    String filename = chooser.getSelectedFile().getCanonicalPath();
                    String extension = Gradebook.this.getExtension(filename);
                    if (extension == null) {
                        filename = filename + ".html";
                        file = new File(filename);
                    }
                    if (file.exists() && (answer = JOptionPane.showConfirmDialog(Gradebook.this, "File already exists.\nAre you sure you wish to overwrite it?")) != 0) {
                        return;
                    }
                    if (Gradebook.this.roster.saveFileAsHTML(file.getCanonicalPath())) {
                        File dir = chooser.getSelectedFile().getParentFile();
                        if (dir != null) {
                            Gradebook.this.userprefs.put(Gradebook.OPTION_DIR_HTML_FILES, dir.getCanonicalPath());
                        }
                        try {
                            Gradebook.this.userprefs.flush();
                        }
                        catch (BackingStoreException ex) {}
                    } else {
                        JOptionPane.showMessageDialog(Gradebook.this, Gradebook.this.resbundle.getString("postingPrivateInformation"), Gradebook.this.resbundle.getString("error"), 0);
                    }
                }
                catch (IOException ex) {
                    System.err.println("Unable to save file: " + ex);
                }
            }
        }
    }

    public class exportCSVActionClass
    extends AbstractAction {
        public exportCSVActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            String defdir = Gradebook.this.userprefs.get(Gradebook.OPTION_DIR_TXT_FILES, null);
            JFileChooser chooser = new JFileChooser(defdir);
            chooser.setFileFilter(new GradebookFileFilter("Comma-Separated Files", "txt"));
            chooser.setFileSystemView(new GradebookFileSystemView(chooser.getFileSystemView()));
            int rVal = chooser.showSaveDialog(Gradebook.this);
            if (rVal == 0) {
                try {
                    int answer;
                    File file = chooser.getSelectedFile();
                    String filename = chooser.getSelectedFile().getCanonicalPath();
                    String extension = Gradebook.this.getExtension(filename);
                    if (extension == null) {
                        filename = filename + ".txt";
                        file = new File(filename);
                    }
                    if (file.exists() && (answer = JOptionPane.showConfirmDialog(Gradebook.this, "File already exists.\nAre you sure you wish to overwrite it?")) != 0) {
                        return;
                    }
                    Gradebook.this.roster.saveFileAsCSV(file.getCanonicalPath());
                    File dir = chooser.getSelectedFile().getParentFile();
                    if (dir != null) {
                        Gradebook.this.userprefs.put(Gradebook.OPTION_DIR_TXT_FILES, dir.getCanonicalPath());
                    }
                    try {
                        Gradebook.this.userprefs.flush();
                    }
                    catch (BackingStoreException ex) {}
                }
                catch (IOException ex) {
                    System.err.println("Unable to save file: " + ex);
                }
            }
        }
    }

    public class importActionClass
    extends AbstractAction {
        public importActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            if (Gradebook.this.importBox == null) {
                Gradebook.this.importBox = new RosterImportParams(Gradebook.this, Gradebook.this.roster, Gradebook.this.resbundle);
            }
            Gradebook.this.importBox.show();
        }
    }

    public class mergeActionClass
    extends AbstractAction {
        public mergeActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            if (!Gradebook.this.roster.knowsHowToDownload()) {
                if (Gradebook.this.passwordBox == null) {
                    Gradebook.this.passwordBox = new RosterPasswordParams(Gradebook.this, Gradebook.this.roster, Gradebook.this.resbundle);
                }
                if (Gradebook.this.downloadBox == null) {
                    Gradebook.this.downloadBox = new RosterDownloadParams(Gradebook.this, Gradebook.this.passwordBox, Gradebook.this.roster, Gradebook.this.resbundle);
                }
                Gradebook.this.downloadBox.show();
            } else {
                if (Gradebook.this.passwordBox == null) {
                    Gradebook.this.passwordBox = new RosterPasswordParams(Gradebook.this, Gradebook.this.roster, Gradebook.this.resbundle);
                }
                Gradebook.this.passwordBox.show();
            }
        }
    }

    public class saveAsActionClass
    extends AbstractAction {
        public saveAsActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            String defdir = Gradebook.this.userprefs.get(Gradebook.OPTION_DIR_GBK_FILES, null);
            JFileChooser chooser = new JFileChooser(defdir);
            chooser.setFileFilter(new GradebookFileFilter(Gradebook.GBK_DESCRIPTION, Gradebook.EXTENSION));
            chooser.setFileSystemView(new GradebookFileSystemView(chooser.getFileSystemView()));
            int rVal = chooser.showSaveDialog(Gradebook.this);
            if (rVal == 0) {
                try {
                    int answer;
                    File file = chooser.getSelectedFile();
                    String filename = chooser.getSelectedFile().getCanonicalPath();
                    String extension = Gradebook.this.getExtension(filename);
                    if (extension == null || !extension.equals(Gradebook.EXTENSION)) {
                        filename = filename + ".gbk";
                        file = new File(filename);
                    }
                    if (file.exists() && (answer = JOptionPane.showConfirmDialog(Gradebook.this, "File already exists.\nAre you sure you wish to overwrite it?")) != 0) {
                        return;
                    }
                    Gradebook.this.roster.saveFile(file.getCanonicalPath());
                    File dir = chooser.getSelectedFile().getParentFile();
                    if (dir != null) {
                        Gradebook.this.userprefs.put(Gradebook.OPTION_DIR_GBK_FILES, dir.getCanonicalPath());
                    }
                    try {
                        Gradebook.this.userprefs.flush();
                    }
                    catch (BackingStoreException ex) {}
                }
                catch (IOException ex) {
                    System.err.println("Unable to save file: " + ex);
                }
            }
        }
    }

    public class saveActionClass
    extends AbstractAction {
        public saveActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            if (Gradebook.this.roster == null) {
                return;
            }
            if (Gradebook.this.roster.isReadyToSave()) {
                Gradebook.this.roster.saveFile();
            } else {
                String defdir = Gradebook.this.userprefs.get(Gradebook.OPTION_DIR_GBK_FILES, null);
                JFileChooser chooser = new JFileChooser(defdir);
                chooser.setFileFilter(new GradebookFileFilter(Gradebook.GBK_DESCRIPTION, Gradebook.EXTENSION));
                chooser.setFileSystemView(new GradebookFileSystemView(chooser.getFileSystemView()));
                int rVal = chooser.showSaveDialog(Gradebook.this);
                if (rVal == 0) {
                    try {
                        String filename = chooser.getSelectedFile().getCanonicalPath();
                        String extension = Gradebook.this.getExtension(filename);
                        if (extension == null || !extension.equals(Gradebook.EXTENSION)) {
                            filename = filename + ".gbk";
                        }
                        Gradebook.this.roster.saveFile(filename);
                        File dir = chooser.getSelectedFile().getParentFile();
                        if (dir != null) {
                            Gradebook.this.userprefs.put(Gradebook.OPTION_DIR_GBK_FILES, dir.getCanonicalPath());
                        }
                        try {
                            Gradebook.this.userprefs.flush();
                        }
                        catch (BackingStoreException ex) {}
                    }
                    catch (IOException ex) {
                        System.err.println("Unable to save file: " + ex);
                    }
                }
            }
        }
    }

    public class exitActionClass
    extends AbstractAction {
        public exitActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            Gradebook.this.quit();
        }
    }

    public class closeActionClass
    extends AbstractAction {
        public closeActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            int answer;
            if (Gradebook.this.roster != null && Gradebook.this.roster.isDirty() && (answer = JOptionPane.showConfirmDialog(Gradebook.this, "Are you sure?\nCurrent gradebook is not saved.\nProceeding will delete all changes.")) != 0) {
                return;
            }
            Gradebook.this.hide();
        }
    }

    public class openActionClass
    extends AbstractAction {
        public openActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            Gradebook.this.handleOpen();
        }
    }

    public class newActionClass
    extends AbstractAction {
        public newActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            new Gradebook();
        }
    }

    public class gradeBoundsActionClass
    extends AbstractAction {
        public gradeBoundsActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            if (Gradebook.this.boundsBox == null) {
                Gradebook.this.boundsBox = new GradeBounds(Gradebook.this, Gradebook.this.roster, Gradebook.this.resbundle);
            }
            Gradebook.this.boundsBox.show();
        }
    }

    public class gradePolicyActionClass
    extends AbstractAction {
        public gradePolicyActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            if (Gradebook.this.policyBox == null) {
                Gradebook.this.policyBox = new GradePolicy(Gradebook.this, Gradebook.this.roster, Gradebook.this.resbundle);
            }
            Gradebook.this.policyBox.show();
        }
    }
}

