/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.cs.gradebook.ui;

import com.apple.mrj.MRJAboutHandler;
import com.apple.mrj.MRJApplicationUtils;
import com.apple.mrj.MRJOpenApplicationHandler;
import com.apple.mrj.MRJOpenDocumentHandler;
import com.apple.mrj.MRJPrefsHandler;
import com.apple.mrj.MRJQuitHandler;
import edu.uwyo.cs.gradebook.ui.Gradebook;
import java.io.File;
import org.apache.log4j.Logger;

public class GradebookMacExtensions {
    private FinderIntegration finder;
    private static Logger logger = Logger.getLogger("edu.uwyo.cs.gradebook.ui.GradebookMacExtensions");

    public void init(Gradebook gradebook) {
        this.finder = new FinderIntegration(gradebook);
        MRJApplicationUtils.registerPrefsHandler((MRJPrefsHandler)this.finder);
        MRJApplicationUtils.registerQuitHandler((MRJQuitHandler)this.finder);
        MRJApplicationUtils.registerAboutHandler((MRJAboutHandler)this.finder);
        MRJApplicationUtils.registerOpenApplicationHandler((MRJOpenApplicationHandler)this.finder);
        MRJApplicationUtils.registerOpenDocumentHandler((MRJOpenDocumentHandler)this.finder);
    }

    private class FinderIntegration
    implements MRJOpenApplicationHandler,
    MRJQuitHandler,
    MRJPrefsHandler,
    MRJOpenDocumentHandler,
    MRJAboutHandler {
        private Gradebook gradebook;

        public FinderIntegration(Gradebook parentGradebook) {
            this.gradebook = parentGradebook;
        }

        public void handleAbout() {
            this.gradebook.about();
        }

        public void handleOpenApplication() {
            logger.info("handleOpenApplication");
            this.gradebook.handleOpen();
        }

        public void handleOpenFile(File file) {
            logger.info("handleOpen: " + file);
            this.gradebook.openFile(file);
        }

        public void handlePrefs() {
            this.gradebook.preferences();
        }

        public void handleQuit() {
            this.gradebook.quit();
        }
    }
}

