/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.cs.gradebook.ui;

import edu.uwyo.cs.gradebook.ui.Gradebook;
import edu.uwyo.cs.gradebook.ui.RosterPasswordParams;
import edu.uwyo.cs.gradebook.ui.RosterTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RosterDownloadParams
extends JFrame {
    private Gradebook parentFrame;
    private RosterPasswordParams passwordBox;
    private RosterTableModel rosterModel;
    private ResourceBundle resbundle;
    private JComboBox yearbox;
    private JComboBox semesterbox;
    private JTextField dept;
    private JTextField course;
    private JTextField section;
    private int theYear = 2003;
    private int theSemester = 1;
    private String theDept = "COSC";
    private String theCourse = null;
    private String theSection = "01";

    public RosterDownloadParams(Gradebook parent, RosterPasswordParams password, RosterTableModel roster, ResourceBundle bundle) {
        super("");
        this.parentFrame = parent;
        this.passwordBox = password;
        this.rosterModel = roster;
        this.resbundle = bundle;
        this.setTitle(this.resbundle.getString("downloadConstructor"));
        Container cp = this.getContentPane();
        JPanel labelPane = new JPanel();
        labelPane.setLayout(new GridLayout(0, 1));
        labelPane.add(new JLabel(this.resbundle.getString("year")));
        labelPane.add(new JLabel(this.resbundle.getString("semester")));
        labelPane.add(new JLabel(this.resbundle.getString("dept")));
        labelPane.add(new JLabel(this.resbundle.getString("course")));
        labelPane.add(new JLabel(this.resbundle.getString("section")));
        this.yearbox = new JComboBox();
        this.yearbox.addItem("2003");
        this.yearbox.addItem("2004");
        this.yearbox.addItem("2005");
        this.yearbox.addItem("2006");
        this.yearbox.addItem("2007");
        this.yearbox.addItem("2008");
        this.yearbox.addItem("2009");
        this.yearbox.addItem("2010");
        this.yearbox.setSelectedIndex(0);
        this.semesterbox = new JComboBox();
        this.semesterbox.addItem(this.resbundle.getString("spring"));
        this.semesterbox.addItem(this.resbundle.getString("summer"));
        this.semesterbox.addItem(this.resbundle.getString("fall"));
        this.semesterbox.setSelectedIndex(2);
        this.dept = new JTextField();
        this.dept.setEditable(true);
        this.dept.setColumns(5);
        this.dept.setText("COSC");
        this.course = new JTextField();
        this.course.setEditable(true);
        this.course.setColumns(5);
        this.section = new JTextField();
        this.section.setEditable(true);
        this.section.setColumns(5);
        this.section.setText("01");
        JPanel fieldPane = new JPanel();
        fieldPane.setLayout(new GridLayout(0, 1));
        fieldPane.add(this.yearbox);
        fieldPane.add(this.semesterbox);
        fieldPane.add(this.dept);
        fieldPane.add(this.course);
        fieldPane.add(this.section);
        JPanel buttonPane = new JPanel();
        buttonPane.add(new JButton(new okAction()));
        JPanel contentPane = new JPanel();
        contentPane.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)labelPane, "Center");
        contentPane.add((Component)fieldPane, "East");
        contentPane.add((Component)buttonPane, "South");
        this.setContentPane(contentPane);
        this.setSize(400, 250);
    }

    private class okAction
    extends AbstractAction {
        public okAction() {
            super(RosterDownloadParams.this.resbundle.getString("okToDownload"));
        }

        public void actionPerformed(ActionEvent e) {
            String s = (String)RosterDownloadParams.this.yearbox.getSelectedItem();
            RosterDownloadParams.this.theYear = Integer.parseInt(s);
            s = (String)RosterDownloadParams.this.semesterbox.getSelectedItem();
            if (s.equals(RosterDownloadParams.this.resbundle.getString("spring"))) {
                RosterDownloadParams.this.theSemester = 1;
            } else if (s.equals(RosterDownloadParams.this.resbundle.getString("summer"))) {
                RosterDownloadParams.this.theSemester = 2;
            } else if (s.equals(RosterDownloadParams.this.resbundle.getString("fall"))) {
                RosterDownloadParams.this.theSemester = 3;
            } else {
                System.err.println("What semester is [" + s + "]?");
            }
            RosterDownloadParams.this.theDept = RosterDownloadParams.this.dept.getText();
            RosterDownloadParams.this.theCourse = RosterDownloadParams.this.course.getText();
            RosterDownloadParams.this.theSection = RosterDownloadParams.this.section.getText();
            if (!(RosterDownloadParams.this.theDept == null || RosterDownloadParams.this.theDept.equals("") || RosterDownloadParams.this.theCourse == null || RosterDownloadParams.this.theCourse.equals("") || RosterDownloadParams.this.theSection == null || RosterDownloadParams.this.theSection.equals(""))) {
                RosterDownloadParams.this.hide();
                RosterDownloadParams.this.passwordBox.show();
                RosterDownloadParams.this.rosterModel.setDownloadParams(RosterDownloadParams.this.theYear, RosterDownloadParams.this.theSemester, RosterDownloadParams.this.theDept, RosterDownloadParams.this.theCourse, RosterDownloadParams.this.theSection);
            } else {
                JOptionPane.showMessageDialog(RosterDownloadParams.this, RosterDownloadParams.this.resbundle.getString("missingFields"), RosterDownloadParams.this.resbundle.getString("error"), 0);
            }
        }
    }
}

