/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.cs.gradebook.ui;

import com.Ostermiller.util.CSVPrinter;
import edu.uwyo.cs.gradebook.download.Downloader;
import edu.uwyo.cs.gradebook.download.DownloaderFactory;
import edu.uwyo.cs.gradebook.importer.Importer;
import edu.uwyo.cs.gradebook.importer.ImporterFactory;
import edu.uwyo.cs.gradebook.model.GradeGroup;
import edu.uwyo.cs.gradebook.model.GradeObject;
import edu.uwyo.cs.gradebook.model.Roster;
import edu.uwyo.cs.gradebook.model.Student;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;

public class RosterTableModel
extends AbstractTableModel {
    private static Logger logger = Logger.getLogger("edu.uwyo.cs.gradebook.ui.RosterTableModel");
    private ResourceBundle resbundle = null;
    private JFrame jframe = null;
    private JTable jtable = null;
    private int rosterYear;
    private int rosterSemester;
    private String rosterDept;
    private String rosterCourse;
    private String rosterSection;
    Roster roster = new Roster();
    int[] cols = new int[]{8, 1, 2, 3, 4, 5, 6, 7};
    int[] sort = new int[0];
    int[] rows = new int[0];
    String[] gradeNames = new String[0];
    private boolean dirty = false;
    public static final int COURSE = 1;
    public static final int NAME = 2;
    public static final int SSN = 3;
    public static final int ID = 4;
    public static final int EMAIL = 5;
    public static final int LETTER_GRADE = 6;
    public static final int FINAL_GRADE = 7;
    public static final int COUNT = 8;

    public RosterTableModel(ResourceBundle bundle, JFrame frame) {
        this.roster = new Roster();
        this.resbundle = bundle;
        this.jframe = frame;
        this.markAsClean();
    }

    public RosterTableModel(String filename, ResourceBundle bundle, JFrame frame) {
        this.roster = new Roster();
        this.resbundle = bundle;
        this.jframe = frame;
        this.openFile(filename);
    }

    public String getFilename() {
        return this.roster.getFilename();
    }

    public void openFile(String filename) {
        logger.info("Opening..." + filename);
        try {
            this.roster.readFromFile(filename);
        }
        catch (Exception e) {
            System.out.println("Unable to read file: " + e);
            e.printStackTrace();
        }
        this.reinit();
        this.markAsClean();
        this.jframe.setTitle(this.resbundle.getString("frameConstructor") + ": " + filename);
    }

    public void reinit() {
        int i;
        int i2;
        logger.info("Reinitializing...");
        int num_students = this.roster.getNumStudents();
        ArrayList<Integer> active_students = new ArrayList<Integer>();
        for (i2 = 0; i2 < num_students; ++i2) {
            Student st = this.roster.getStudent(i2);
            if (!st.isActive) continue;
            active_students.add(new Integer(i2));
        }
        this.rows = new int[active_students.size()];
        for (i2 = 0; i2 < this.rows.length; ++i2) {
            this.rows[i2] = (Integer)active_students.get(i2);
        }
        this.gradeNames = this.roster.getGradeItems();
        int num_cols = 0;
        for (int i3 = 0; i3 < this.cols.length; ++i3) {
            if (this.cols[i3] <= 0) continue;
            ++num_cols;
        }
        int[] new_cols = new int[num_cols + this.gradeNames.length];
        for (i = 0; i < this.cols.length; ++i) {
            if (this.cols[i] <= 0) continue;
            new_cols[i] = this.cols[i];
        }
        for (i = 0; i < this.gradeNames.length; ++i) {
            new_cols[num_cols + i] = -(i + 1);
        }
        this.cols = new_cols;
        this.setSortFields(new int[]{2}, true);
        this.fireTableStructureChanged();
        this.setDefaultWidths();
        this.markAsDirty();
    }

    public void saveFileAsCSV(String filename) throws IOException {
        int nrows = this.getRowCount();
        int ncols = this.getColumnCount();
        String[][] cells = new String[nrows + 1][ncols];
        for (int j = 0; j < ncols; ++j) {
            cells[0][j] = this.getColumnName(j);
        }
        for (int i = 0; i < nrows; ++i) {
            for (int j = 0; j < ncols; ++j) {
                Object cell = this.getValueAt(i, j);
                cells[i + 1][j] = cell == null ? "" : cell.toString();
            }
        }
        File out_file = new File(filename);
        if (out_file.exists()) {
            int i = 1;
            while (true) {
                File backup_file;
                if (!(backup_file = new File(filename + "~" + i + "~")).exists()) {
                    out_file.renameTo(backup_file);
                    break;
                }
                ++i;
            }
        }
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(out_file)));
        CSVPrinter csv = new CSVPrinter(out);
        csv.println(cells);
        out.close();
    }

    public boolean saveFileAsHTML(String filename) throws IOException {
        int j;
        int nrows = this.getRowCount();
        int ncols = this.getColumnCount();
        boolean isOKToPostPublicly = true;
        block20: for (j = 0; j < ncols; ++j) {
            if (this.cols[j] <= 0) continue;
            switch (this.cols[j]) {
                case 8: {
                    continue block20;
                }
                case 1: {
                    continue block20;
                }
                case 2: {
                    isOKToPostPublicly = false;
                    continue block20;
                }
                case 3: {
                    isOKToPostPublicly = false;
                    continue block20;
                }
                case 4: {
                    continue block20;
                }
                case 5: {
                    isOKToPostPublicly = false;
                    continue block20;
                }
                case 6: {
                    continue block20;
                }
                case 7: {
                    continue block20;
                }
                default: {
                    isOKToPostPublicly = false;
                }
            }
        }
        if (this.sort == null || this.sort.length == 0) {
            isOKToPostPublicly = false;
        } else {
            block21: for (j = 0; j < ncols; ++j) {
                if (this.cols[j] <= 0) continue;
                switch (this.cols[j]) {
                    case 8: {
                        isOKToPostPublicly = false;
                        continue block21;
                    }
                    case 1: {
                        continue block21;
                    }
                    case 2: {
                        isOKToPostPublicly = false;
                        continue block21;
                    }
                    case 3: {
                        isOKToPostPublicly = false;
                        continue block21;
                    }
                    case 4: {
                        continue block21;
                    }
                    case 5: {
                        isOKToPostPublicly = false;
                        continue block21;
                    }
                    case 6: {
                        continue block21;
                    }
                    case 7: {
                        continue block21;
                    }
                    default: {
                        isOKToPostPublicly = false;
                    }
                }
            }
        }
        if (!isOKToPostPublicly) {
            return false;
        }
        File out_file = new File(filename);
        if (out_file.exists()) {
            int i = 1;
            while (true) {
                File backup_file;
                if (!(backup_file = new File(filename + "~" + i + "~")).exists()) {
                    out_file.renameTo(backup_file);
                    break;
                }
                ++i;
            }
        }
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(out_file)));
        String dept = this.roster.getDepartment();
        String course = this.roster.getCourse();
        String section = this.roster.getSection();
        String title = dept == null || course == null || section == null || dept.trim().equals("") || course.trim().equals("") || section.trim().equals("") ? "Grades" : "Grades for " + dept + " " + course + "-" + section;
        Date date = new Date();
        DateFormat df = DateFormat.getDateInstance(1);
        title = title + " as of " + df.format(date);
        out.println("<html>");
        out.println("  <head>");
        out.println("    <title>" + title + "</title>");
        out.println("  </head>");
        out.println("  <body>");
        out.println("    <h1>" + title + "</h1>");
        out.println("    <table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">");
        out.println("      <tr>");
        for (int j2 = 0; j2 < ncols; ++j2) {
            String cell = this.getColumnName(j2);
            if (cell == null) {
                cell = "&nbsp;";
            }
            out.println("        <th>" + cell + "</th>");
        }
        out.println("      </tr>");
        for (int i = 0; i < nrows; ++i) {
            out.println("      <tr>");
            for (int j3 = 0; j3 < ncols; ++j3) {
                Object cell = this.getValueAt(i, j3);
                if (cell == null) {
                    cell = "&nbsp;";
                }
                out.println("        <td>" + cell + "</td>");
            }
            out.println("      </tr>");
        }
        out.println("    </table>");
        out.println("  </body>");
        out.close();
        return true;
    }

    public void saveFile() {
        this.saveFile(this.roster.getFilename());
    }

    public void saveFile(String filename) {
        if (filename != null) {
            try {
                this.roster.writeToFile(filename);
                this.markAsClean();
                this.jframe.setTitle(this.resbundle.getString("frameConstructor") + ": " + filename);
            }
            catch (IOException e) {
                System.err.println("Unable to save file: " + e);
            }
        }
    }

    public boolean knowsHowToDownload() {
        String course = this.roster.getCourse();
        return course != null && !course.equals("");
    }

    public String getCourse() {
        return this.roster.getCourse();
    }

    public void setCourses(String course) {
        this.roster.setCourse(course);
    }

    public void setDownloadParams(int year, int semester, String dept, String course, String section) {
        this.rosterYear = year;
        this.rosterSemester = semester;
        this.rosterDept = dept;
        this.rosterCourse = course;
        this.rosterSection = section;
    }

    public void download(String username, String password) {
        try {
            Downloader downloader = DownloaderFactory.getNewInstance();
            Student[] st = this.knowsHowToDownload() ? downloader.downloadClassRoster(username, password, this.roster.getYear(), this.roster.getSemester(), this.roster.getDepartment(), this.roster.getCourse(), this.roster.getSection()) : downloader.downloadClassRoster(username, password, this.rosterYear, this.rosterSemester, this.rosterDept, this.rosterCourse, this.rosterSection);
            this.roster.mergeClassRoster(st);
            if (!this.knowsHowToDownload()) {
                this.roster.setYear(this.rosterYear);
                this.roster.setSemester(this.rosterSemester);
                this.roster.setDepartment(this.rosterDept);
                this.roster.setCourse(this.rosterCourse);
                this.roster.setSection(this.rosterSection);
            }
            this.reinit();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.jframe, this.resbundle.getString("unableToDownload"), this.resbundle.getString("error"), 0);
            logger.error("Unable to download: " + ex);
        }
    }

    public void importFile(String filename) {
        try {
            Importer importer = ImporterFactory.getNewInstance();
            Student[] st = this.knowsHowToDownload() ? importer.importClassRoster(filename, this.roster.getDepartment(), this.roster.getCourse(), this.roster.getSection()) : importer.importClassRoster(filename, this.rosterDept, this.rosterCourse, this.rosterSection);
            this.roster.mergeClassRoster(st);
            if (!this.knowsHowToDownload()) {
                this.roster.setYear(this.rosterYear);
                this.roster.setSemester(this.rosterSemester);
                this.roster.setDepartment(this.rosterDept);
                this.roster.setCourse(this.rosterCourse);
                this.roster.setSection(this.rosterSection);
            }
            this.reinit();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.jframe, this.resbundle.getString("unableToImport"), this.resbundle.getString("error"), 0);
            logger.error("Unable to import: " + ex);
        }
    }

    public boolean isReadyToSave() {
        String file = this.roster.getFilename();
        return file != null;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private void markAsDirty() {
        this.dirty = true;
        this.jframe.getRootPane().putClientProperty("windowModified", Boolean.TRUE);
    }

    private void markAsClean() {
        this.dirty = false;
        this.jframe.getRootPane().putClientProperty("windowModified", Boolean.FALSE);
    }

    public double getLowerBoundForA() {
        return this.roster.getLowerBoundForA();
    }

    public double getLowerBoundForB() {
        return this.roster.getLowerBoundForB();
    }

    public double getLowerBoundForC() {
        return this.roster.getLowerBoundForC();
    }

    public double getLowerBoundForD() {
        return this.roster.getLowerBoundForD();
    }

    public GradeGroup getGradeGroup() {
        return this.roster.getGradeGroup();
    }

    public int getColumnCount() {
        return this.cols.length;
    }

    private void fireUpdateComputedCells() {
        for (int i = 0; i < this.rows.length; ++i) {
            for (int j = 0; j < this.cols.length; ++j) {
                if (this.cols[j] == 7 || this.cols[j] == 6) {
                    this.fireTableCellUpdated(i, j);
                }
                if (this.cols[j] >= 0 && this.cols[j] != 7 && this.cols[j] != 6) continue;
                for (int k = 0; k < 9; ++k) {
                    this.fireTableCellUpdated(this.rows.length + k, this.cols[j]);
                }
            }
        }
    }

    public void setLowerBoundForA(double bound) {
        this.roster.setLowerBoundForA(bound);
        this.fireUpdateComputedCells();
        this.markAsDirty();
    }

    public void setLowerBoundForB(double bound) {
        this.roster.setLowerBoundForB(bound);
        this.fireUpdateComputedCells();
        this.markAsDirty();
    }

    public void setLowerBoundForC(double bound) {
        this.roster.setLowerBoundForC(bound);
        this.fireUpdateComputedCells();
        this.markAsDirty();
    }

    public void setLowerBoundForD(double bound) {
        this.roster.setLowerBoundForD(bound);
        this.fireUpdateComputedCells();
        this.markAsDirty();
    }

    public double getMaxGrade(String name) {
        return this.roster.getMaxGrade(name);
    }

    public void setMaxGrade(String name, double amount) {
        this.roster.setMaxGrade(name, amount);
    }

    public double getWeight(String name) {
        return this.roster.getWeight(name);
    }

    public void setWeight(String name, double amount) {
        this.roster.setWeight(name, amount);
    }

    public int getMaxOccurs(String name) {
        return this.roster.getMaxOccurs(name);
    }

    public boolean setMaxOccurs(String name, int amount) {
        if (this.roster.setMaxOccurs(name, amount)) {
            this.reinit();
            return true;
        }
        return false;
    }

    public int getCountsAs(String name) {
        return this.roster.getCountsAs(name);
    }

    public void setCountsAs(String name, int amount) {
        this.roster.setCountsAs(name, amount);
    }

    public int getMaxItems(String name) {
        return this.roster.getMaxItems(name);
    }

    public void setMaxItems(String name, int amount) {
        this.roster.setMaxItems(name, amount);
    }

    public int getRowCount() {
        if (this.rows.length == 0) {
            return 1;
        }
        return this.rows.length + 9;
    }

    public boolean delGradeObject(String name) {
        if (this.roster.delGradeObject(name)) {
            this.reinit();
            return true;
        }
        return false;
    }

    public void addGradeItem(String parent, int idx) {
        this.roster.addGradeItem(parent, idx);
        this.reinit();
    }

    public void addGradeGroup(String parent, int idx) {
        this.roster.addGradeGroup(parent, idx);
    }

    public boolean setGradeItemName(String oldName, String newName) {
        if (this.roster.setGradeItemName(oldName, newName)) {
            this.reinit();
            this.markAsDirty();
            return true;
        }
        return false;
    }

    public GradeObject getGradeObject(String name) {
        return this.roster.getGradeObject(name);
    }

    public Class getColumnClass(int col) {
        if (this.cols[col] < 0) {
            return Double.class;
        }
        if (this.cols[col] == 7) {
            return Double.class;
        }
        if (this.cols[col] == 4) {
            return Integer.class;
        }
        if (this.cols[col] == 8) {
            return Integer.class;
        }
        return String.class;
    }

    public String[] getAllGradeHeadings() {
        return this.roster.getGradeItems();
    }

    public int getColumnIndex(int col) {
        return this.cols[col];
    }

    public String getColumnName(int col) {
        String col_name = null;
        if (this.cols[col] > 0) {
            switch (this.cols[col]) {
                case 8: {
                    col_name = this.resbundle.getString("count");
                    break;
                }
                case 1: {
                    col_name = this.resbundle.getString("course");
                    break;
                }
                case 2: {
                    col_name = this.resbundle.getString("name");
                    break;
                }
                case 3: {
                    col_name = this.resbundle.getString("ssn");
                    break;
                }
                case 4: {
                    col_name = this.resbundle.getString("id");
                    break;
                }
                case 5: {
                    col_name = this.resbundle.getString("email");
                    break;
                }
                case 6: {
                    col_name = this.resbundle.getString("letterGrade");
                    break;
                }
                case 7: {
                    col_name = this.resbundle.getString("finalGrade");
                    break;
                }
                default: {
                    col_name = "XXXXX" + this.cols[col];
                    break;
                }
            }
        } else {
            col_name = this.gradeNames[-(this.cols[col] + 1)];
        }
        return col_name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getValueAt(int row, int col) {
        if (row < this.rows.length) {
            Student student = this.roster.getStudent(this.rows[row]);
            if (this.cols[col] <= 0) return student.grades.get(this.gradeNames[-(this.cols[col] + 1)]);
            switch (this.cols[col]) {
                case 8: {
                    return new Integer(row + 1);
                }
                case 1: {
                    return student.course;
                }
                case 2: {
                    return student.name;
                }
                case 3: {
                    return student.ssn;
                }
                case 4: {
                    return new Integer(student.id);
                }
                case 5: {
                    return student.email;
                }
                case 6: {
                    Double d = this.roster.getFinalPercentGrade(this.rows[row]);
                    if (d == null) {
                        return null;
                    }
                    double dg = d;
                    if (dg >= this.roster.getLowerBoundForA()) {
                        return "A";
                    }
                    if (dg >= this.roster.getLowerBoundForB()) {
                        return "B";
                    }
                    if (dg >= this.roster.getLowerBoundForC()) {
                        return "C";
                    }
                    if (!(dg >= this.roster.getLowerBoundForD())) return "F";
                    return "D";
                }
                case 7: {
                    return this.roster.getFinalPercentGrade(this.rows[row]);
                }
            }
            return "NaN";
        } else {
            if (row == this.rows.length) {
                return null;
            }
            if (this.cols[col] > 0 && this.cols[col] != 7) {
                int i;
                for (i = 0; i < this.cols.length && this.cols[i] >= 0 && this.cols[i] != 7; ++i) {
                }
                if (col != --i) return null;
                if (row == this.rows.length + 1) {
                    return "Avg";
                }
                if (row == this.rows.length + 2) {
                    return "Min";
                }
                if (row == this.rows.length + 3) {
                    return "Max";
                }
                if (row == this.rows.length + 4) {
                    return "As";
                }
                if (row == this.rows.length + 5) {
                    return "Bs";
                }
                if (row == this.rows.length + 6) {
                    return "Cs";
                }
                if (row == this.rows.length + 7) {
                    return "Ds";
                }
                if (row != this.rows.length + 8) return "NaN";
                return "Fs";
            }
            double sum = 0.0;
            double min = 0.0;
            double max = 0.0;
            int count = 0;
            int countA = 0;
            int countB = 0;
            int countC = 0;
            int countD = 0;
            int countF = 0;
            double maxGrade = this.cols[col] == 7 ? 100.0 : this.roster.getMaxGrade(this.gradeNames[-(this.cols[col] + 1)]);
            for (int i = 0; i < this.rows.length; ++i) {
                Double g = this.cols[col] == 7 ? this.roster.getFinalPercentGrade(this.rows[i]) : this.roster.getGrade(this.rows[i], this.gradeNames[-(this.cols[col] + 1)]);
                if (g == null) continue;
                double dg = g;
                sum += dg;
                if (count == 0) {
                    min = dg;
                    max = dg;
                }
                if (min > dg) {
                    min = dg;
                }
                if (max < dg) {
                    max = dg;
                }
                ++count;
                if ((dg = 100.0 * (dg / maxGrade)) >= this.roster.getLowerBoundForA()) {
                    ++countA;
                    continue;
                }
                if (dg >= this.roster.getLowerBoundForB()) {
                    ++countB;
                    continue;
                }
                if (dg >= this.roster.getLowerBoundForC()) {
                    ++countC;
                    continue;
                }
                if (dg >= this.roster.getLowerBoundForD()) {
                    ++countD;
                    continue;
                }
                ++countF;
            }
            if (count == 0) {
                return null;
            }
            if (row == this.rows.length + 1) {
                return new Double(sum / (double)count);
            }
            if (row == this.rows.length + 2) {
                return new Double(min);
            }
            if (row == this.rows.length + 3) {
                return new Double(max);
            }
            if (row == this.rows.length + 4) {
                return new Integer(countA);
            }
            if (row == this.rows.length + 5) {
                return new Integer(countB);
            }
            if (row == this.rows.length + 6) {
                return new Integer(countC);
            }
            if (row == this.rows.length + 7) {
                return new Integer(countD);
            }
            if (row != this.rows.length + 8) return new Integer(-99);
            return new Integer(countF);
        }
    }

    public void setValueAt(Object val, int row, int col) {
        if (this.isCellEditable(row, col)) {
            int i;
            this.roster.setGrade(this.rows[row], this.gradeNames[-(this.cols[col] + 1)], (Double)val);
            for (i = 0; i < 9; ++i) {
                this.fireTableCellUpdated(this.rows.length + i, col);
            }
            for (i = 0; i < this.rows.length; ++i) {
                for (int j = 0; j < this.cols.length; ++j) {
                    if (this.cols[j] != 7 && this.cols[j] != 6) continue;
                    this.fireTableCellUpdated(i, j);
                }
            }
            this.markAsDirty();
        }
    }

    public boolean isCellEditable(int row, int col) {
        if (this.cols[col] > 0) {
            return false;
        }
        return row < this.rows.length;
    }

    public void setViewFields(int[] fields, String[] grades) {
        int i;
        int[] new_cols = new int[fields.length + grades.length];
        for (i = 0; i < fields.length; ++i) {
            new_cols[i] = fields[i];
        }
        for (i = 0; i < grades.length; ++i) {
            new_cols[fields.length + i] = -(i + 1);
        }
        this.cols = new_cols;
        this.gradeNames = grades;
        this.fireTableStructureChanged();
        this.setDefaultWidths();
    }

    public void setSortFields(final int[] sortBy, final boolean ascending) {
        int i;
        this.sort = new int[sortBy.length];
        for (int i2 = 0; i2 < this.sort.length; ++i2) {
            this.sort[i2] = sortBy[i2];
        }
        Integer[] Rows = new Integer[this.rows.length];
        for (i = 0; i < this.rows.length; ++i) {
            Rows[i] = new Integer(this.rows[i]);
        }
        Arrays.sort(Rows, new Comparator(){

            public int compare(Object o1, Object o2) {
                int i1 = (Integer)o1;
                int i2 = (Integer)o2;
                Student s1 = RosterTableModel.this.roster.getStudent(i1);
                Student s2 = RosterTableModel.this.roster.getStudent(i2);
                int cmp = 0;
                for (int i = 0; i < sortBy.length; ++i) {
                    Double d2;
                    Double d1;
                    if (sortBy[i] < 0) {
                        double dg2;
                        double dg1;
                        d1 = (Double)s1.grades.get(RosterTableModel.this.gradeNames[-(sortBy[i] + 1)]);
                        d2 = (Double)s2.grades.get(RosterTableModel.this.gradeNames[-(sortBy[i] + 1)]);
                        cmp = d1 == null ? (d2 == null ? 0 : -1) : (d2 == null ? 1 : ((dg1 = d1.doubleValue()) > (dg2 = d2.doubleValue()) ? 1 : (dg1 == dg2 ? 0 : -1)));
                    } else {
                        switch (sortBy[i]) {
                            case 8: {
                                if (i1 < i2) {
                                    cmp = -1;
                                    break;
                                }
                                if (i1 == i2) {
                                    cmp = 0;
                                    break;
                                }
                                cmp = 1;
                                break;
                            }
                            case 1: {
                                cmp = s1.course.compareTo(s2.course);
                                break;
                            }
                            case 2: {
                                cmp = s1.name.compareTo(s2.name);
                                break;
                            }
                            case 3: {
                                cmp = s1.ssn.compareTo(s2.ssn);
                                break;
                            }
                            case 4: {
                                if (s1.id < s2.id) {
                                    cmp = -1;
                                    break;
                                }
                                if (s1.id == s2.id) {
                                    cmp = 0;
                                    break;
                                }
                                cmp = 1;
                                break;
                            }
                            case 5: {
                                cmp = s1.email.compareTo(s2.email);
                                break;
                            }
                            case 6: {
                                double dg;
                                d1 = RosterTableModel.this.roster.getFinalPercentGrade(i1);
                                d2 = RosterTableModel.this.roster.getFinalPercentGrade(i2);
                                String a1 = d1 == null ? "" : ((dg = d1.doubleValue()) >= RosterTableModel.this.roster.getLowerBoundForA() ? "A" : (dg >= RosterTableModel.this.roster.getLowerBoundForB() ? "B" : (dg >= RosterTableModel.this.roster.getLowerBoundForC() ? "C" : (dg >= RosterTableModel.this.roster.getLowerBoundForD() ? "D" : "F"))));
                                String a2 = d2 == null ? "" : ((dg = d2.doubleValue()) >= RosterTableModel.this.roster.getLowerBoundForA() ? "A" : (dg >= RosterTableModel.this.roster.getLowerBoundForB() ? "B" : (dg >= RosterTableModel.this.roster.getLowerBoundForC() ? "C" : (dg >= RosterTableModel.this.roster.getLowerBoundForD() ? "D" : "F"))));
                                cmp = a1.compareTo(a2);
                                break;
                            }
                            case 7: {
                                double dg2;
                                double dg1;
                                d1 = RosterTableModel.this.roster.getFinalPercentGrade(i1);
                                d2 = RosterTableModel.this.roster.getFinalPercentGrade(i2);
                                if (d1 == null) {
                                    if (d2 == null) {
                                        cmp = 0;
                                        break;
                                    }
                                    cmp = -1;
                                    break;
                                }
                                cmp = d2 == null ? 1 : ((dg1 = d1.doubleValue()) > (dg2 = d2.doubleValue()) ? 1 : (dg1 == dg2 ? 0 : -1));
                            }
                        }
                    }
                    if (cmp != 0) break;
                }
                if (!ascending) {
                    cmp = -cmp;
                }
                return cmp;
            }
        });
        for (i = 0; i < this.rows.length; ++i) {
            this.rows[i] = Rows[i];
        }
        this.fireTableStructureChanged();
        this.setDefaultWidths();
    }

    public void setTable(JTable table) {
        this.jtable = table;
        this.setDefaultWidths();
    }

    private void setDefaultWidths() {
        for (int i = 0; i < this.cols.length; ++i) {
            int maxwidth;
            int width;
            TableColumn tcol = this.jtable.getColumnModel().getColumn(i);
            if (this.cols[i] < 0) {
                width = 50;
                maxwidth = 100;
            } else {
                switch (this.cols[i]) {
                    case 8: {
                        width = 40;
                        maxwidth = 40;
                        break;
                    }
                    case 1: {
                        width = 90;
                        maxwidth = 90;
                        break;
                    }
                    case 2: {
                        width = 200;
                        maxwidth = 400;
                        break;
                    }
                    case 3: {
                        width = 90;
                        maxwidth = 130;
                        break;
                    }
                    case 4: {
                        width = 40;
                        maxwidth = 60;
                        break;
                    }
                    case 5: {
                        width = 150;
                        maxwidth = 200;
                        break;
                    }
                    case 6: {
                        width = 40;
                        maxwidth = 60;
                        break;
                    }
                    case 7: {
                        width = 50;
                        maxwidth = 100;
                        break;
                    }
                    default: {
                        width = 100;
                        maxwidth = 100;
                    }
                }
            }
            maxwidth *= 4;
            tcol.setPreferredWidth(width *= 4);
        }
    }

    public void mergeStudent(Student studentModel) {
        this.roster.mergeStudent(studentModel);
        this.reinit();
    }
}

