/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.cs.gradebook.ui;

import edu.uwyo.cs.gradebook.model.Student;
import edu.uwyo.cs.gradebook.ui.RosterTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class StudentEditor
extends JFrame
implements PropertyChangeListener {
    private JFrame parentFrame;
    private RosterTableModel rosterModel;
    private Student studentModel;
    private ResourceBundle resbundle;
    private JTextField name;
    private JTextField course;
    private JTextField ssn;
    private JTextField email;
    private JCheckBox isActive;

    public StudentEditor(JFrame parent, RosterTableModel roster, Student student, ResourceBundle bundle) {
        super("");
        this.parentFrame = parent;
        this.rosterModel = roster;
        this.studentModel = student;
        this.resbundle = bundle;
        this.setTitle(this.resbundle.getString("studentEditor"));
        Container cp = this.getContentPane();
        JPanel labelPane = new JPanel();
        labelPane.setLayout(new GridLayout(0, 1));
        labelPane.add(new JLabel(this.resbundle.getString("name")));
        labelPane.add(new JLabel(this.resbundle.getString("course")));
        labelPane.add(new JLabel(this.resbundle.getString("ssn")));
        labelPane.add(new JLabel(this.resbundle.getString("email")));
        labelPane.add(new JLabel(this.resbundle.getString("active")));
        JPanel fieldPane = new JPanel();
        fieldPane.setLayout(new GridLayout(0, 1));
        this.name = new JTextField();
        this.name.setEditable(true);
        this.name.setColumns(20);
        this.name.addPropertyChangeListener(this);
        fieldPane.add(this.name);
        this.course = new JTextField();
        this.course.setEditable(true);
        this.course.setColumns(8);
        this.course.addPropertyChangeListener(this);
        fieldPane.add(this.course);
        this.ssn = new JTextField();
        this.ssn.setEditable(true);
        this.ssn.setColumns(11);
        this.ssn.addPropertyChangeListener(this);
        fieldPane.add(this.ssn);
        this.email = new JTextField();
        this.email.setEditable(true);
        this.email.setColumns(11);
        this.email.addPropertyChangeListener(this);
        fieldPane.add(this.email);
        this.isActive = new JCheckBox();
        this.isActive.addPropertyChangeListener(this);
        fieldPane.add(this.isActive);
        JPanel buttonPane = new JPanel();
        buttonPane.add(new JButton(new commitAction()));
        JPanel contentPane = new JPanel();
        contentPane.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)labelPane, "Center");
        contentPane.add((Component)fieldPane, "East");
        contentPane.add((Component)buttonPane, "South");
        this.setContentPane(contentPane);
        this.pack();
    }

    public void show() {
        this.name.setText(this.studentModel.name);
        this.course.setText(this.studentModel.course);
        this.ssn.setText(this.studentModel.ssn);
        this.email.setText(this.studentModel.email);
        this.isActive.setSelected(this.studentModel.isActive);
        super.show();
    }

    public void propertyChange(PropertyChangeEvent e) {
        if ("text".equals(e.getPropertyName()) || "selected".equals(e.getPropertyName())) {
            Object source = e.getSource();
            if (source == this.name) {
                this.studentModel.name = this.name.getText();
            } else if (source == this.course) {
                this.studentModel.course = this.course.getText();
            } else if (source == this.ssn) {
                this.studentModel.ssn = this.ssn.getText();
            } else if (source == this.email) {
                this.studentModel.email = this.email.getText();
            } else if (source == this.isActive) {
                this.studentModel.isActive = this.isActive.isSelected();
            }
        }
    }

    private class commitAction
    extends AbstractAction {
        public commitAction() {
            super(StudentEditor.this.resbundle.getString("commit"));
        }

        public void actionPerformed(ActionEvent e) {
            ((StudentEditor)StudentEditor.this).studentModel.name = StudentEditor.this.name.getText();
            ((StudentEditor)StudentEditor.this).studentModel.course = StudentEditor.this.course.getText();
            ((StudentEditor)StudentEditor.this).studentModel.ssn = StudentEditor.this.ssn.getText();
            ((StudentEditor)StudentEditor.this).studentModel.email = StudentEditor.this.email.getText();
            ((StudentEditor)StudentEditor.this).studentModel.email = StudentEditor.this.email.getText();
            StudentEditor.this.rosterModel.mergeStudent(StudentEditor.this.studentModel);
            if (!StudentEditor.this.rosterModel.knowsHowToDownload()) {
                StudentEditor.this.rosterModel.setCourses(((StudentEditor)StudentEditor.this).studentModel.course);
            }
            StudentEditor.this.hide();
        }
    }
}

