/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.cs.gradebook.utils;

import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;

public class AttrParser {
    private static Logger logger = Logger.getLogger("edu.uwyo.cs.gradebook.utils.AttrParser");

    public Properties parseAttrList(String attrs) {
        String name;
        logger.debug("AttrParser: [" + attrs + "]");
        Properties props = new Properties();
        String attrs0 = attrs.trim();
        while (!attrs0.equals("")) {
            String value;
            int eqidx = attrs0.indexOf(61);
            if (eqidx == -1) {
                logger.error("String with missing '=' passed to AttrParser: [" + attrs + "]");
                break;
            }
            name = attrs0.substring(0, eqidx).trim().toLowerCase();
            if ((attrs0 = attrs0.substring(eqidx + 1).trim()).startsWith("\"")) {
                int quoteidx = attrs0.indexOf(34, 1);
                if (quoteidx == -1) {
                    logger.error("String with unterminated attribute value passed to AttrParser: [" + attrs + "]");
                    break;
                }
                String value2 = attrs0.substring(1, quoteidx);
                props.setProperty(name, value2);
                attrs0 = attrs0.substring(quoteidx + 1).trim();
                continue;
            }
            int wsidx = -1;
            int idx = attrs0.indexOf(" ");
            if (idx >= 0 && (wsidx < 0 || idx < wsidx)) {
                wsidx = idx;
            }
            if ((idx = attrs0.indexOf("\t")) >= 0 && (wsidx < 0 || idx < wsidx)) {
                wsidx = idx;
            }
            if ((idx = attrs0.indexOf("\r")) >= 0 && (wsidx < 0 || idx < wsidx)) {
                wsidx = idx;
            }
            if ((idx = attrs0.indexOf("\n")) >= 0 && (wsidx < 0 || idx < wsidx)) {
                wsidx = idx;
            }
            if (wsidx >= 0) {
                value = attrs0.substring(0, wsidx);
                props.setProperty(name, value);
                attrs0 = attrs0.substring(wsidx + 1).trim();
                continue;
            }
            value = attrs0;
            props.setProperty(name, value);
            break;
        }
        if (logger.isDebugEnabled()) {
            Enumeration<?> names = props.propertyNames();
            while (names.hasMoreElements()) {
                name = (String)names.nextElement();
                logger.debug("Parsed [" + name + "] = [" + props.getProperty(name) + "]");
            }
        }
        return props;
    }
}

