/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.cs.gradebook.utils;

import com.sun.net.ssl.internal.ssl.Provider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.Security;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;

public class HTTPPoster {
    private static HTTPPoster instance;
    private static Logger logger;

    static {
        logger = Logger.getLogger("edu.uwyo.cs.gradebook.utils.HTTPPoster");
    }

    private HTTPPoster() {
        Security.addProvider((java.security.Provider)new Provider());
    }

    public static synchronized HTTPPoster getInstance() {
        if (instance == null) {
            instance = new HTTPPoster();
        }
        return instance;
    }

    public String doPost(String urlstring) {
        return this.doPost(urlstring, null);
    }

    public String doPost(String urlstring, Properties args) {
        logger.info("HTTPPoster: [" + urlstring + "]");
        if (logger.isDebugEnabled() && args != null) {
            Enumeration<?> argnames = args.propertyNames();
            while (argnames.hasMoreElements()) {
                String name = (String)argnames.nextElement();
                String value = args.getProperty(name);
                logger.debug("    [" + name + "] = [" + value + "]");
            }
        }
        String content = null;
        try {
            String line;
            URL url = new URL(urlstring);
            URLConnection con = url.openConnection();
            StringBuffer argsbuf = new StringBuffer();
            OutputStreamWriter wr = null;
            if (args != null) {
                Enumeration<?> argnames = args.propertyNames();
                while (argnames.hasMoreElements()) {
                    String name = (String)argnames.nextElement();
                    String value = args.getProperty(name);
                    try {
                        argsbuf.append(URLEncoder.encode(name, "UTF-8"));
                        argsbuf.append("=");
                        argsbuf.append(URLEncoder.encode(value, "UTF-8"));
                        if (!argnames.hasMoreElements()) continue;
                        argsbuf.append("&");
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.error("Unable to use 'UTF-8' encoding");
                        e.printStackTrace();
                    }
                }
                con.setDoOutput(true);
                wr = new OutputStreamWriter(con.getOutputStream());
                wr.write(argsbuf.toString());
                wr.flush();
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer buf = new StringBuffer();
            while ((line = in.readLine()) != null) {
                buf.append(line);
                buf.append("\n");
            }
            content = buf.toString();
            if (wr != null) {
                wr.close();
            }
            in.close();
        }
        catch (MalformedURLException e) {
            logger.error("Invalid URL passed to HTTPPoster.doPost: [" + urlstring + "]");
        }
        catch (IOException e) {
            logger.error("Unable to connect to server in HTTPPoster.doPost: [" + urlstring + "]");
        }
        return content;
    }

    public static void main(String[] args) {
        HTTPPoster poster = HTTPPoster.getInstance();
        if (args.length == 0) {
            String url = "https://matilda.uwyo.edu/HoleInTheWall/cgi-bin/sisget.pl?/awosgnon";
            System.err.println("Accessing: " + url);
            String content = poster.doPost(url, null);
            System.err.println("Returned:");
            System.err.println(content);
            System.err.println("------------");
        } else {
            int i = 0;
            while (i < args.length) {
                String url = args[i];
                System.err.println("Accessing: " + url);
                String content = poster.doPost(url, null);
                System.err.println("Returned:");
                System.err.println(content);
                System.err.println("------------");
                ++i;
            }
        }
    }
}

