package html;

import html.lexer.*;
import html.node.*;
import html.analysis.*;
import html.parser.*;
import java.io.*;
import java.net.*;
import java.util.*;

public class Extract {
    public static void main(String[] arguments) 
    {
     	try
	    { MyParser p = new MyParser(
			 new MyLexer(
	  	         new PushbackReader(
  		         new InputStreamReader(
		         (new FileInputStream(arguments[0]))),1024)));
	    Start tree = p.parse();
	    Extractor ex = new Extractor();
	    tree.apply(ex);
	    System.out.println("Title: " + ex.title);
	    System.out.println("Total word count is " + ex.totalWords);
	    Iterator i = ex.words.entrySet().iterator();
	    while (i.hasNext()) {
		Map.Entry e = (Map.Entry)i.next(); 
		System.out.print(e.getKey() + " " + e.getValue());
	    }
	    System.out.println(" ");
	    while (!ex.refs.isEmpty()) System.out.println(ex.refs.remove(0));
	    }
	catch(Exception e)
	    { 
		System.out.println(e.getMessage());
		e.printStackTrace();
		if (((ParserException)e).stack != null) {
		    ListIterator stack = ((ParserException)e).stack;
		    while(stack.hasPrevious()) {
			Node node = ((Node)((State)stack.previous()).node);
			System.out.println(node.getClass().getName() + node);
		    }
		}
	    }
    }
}
