package html;

import html.lexer.*;
import html.node.*;
import html.analysis.*;
import html.parser.*;
import java.io.*;
import java.util.*;
import java.net.*;

public class ParsePage {
    public static void main(String[] arguments) 
    {
     	try
	    { MyParser p = new MyParser(
		         new MyLexer (
	  	         new PushbackReader(
  		         new InputStreamReader(
		         (new URL(arguments[0])).openStream()),1024)));
	    Start tree = p.parse();
	    System.out.println("Done.");
	    }
        catch(ParserException e)
	    { 
		System.out.println(e.getMessage());
		e.printStackTrace();
		if (((ParserException)e).stack != null) {
		    ListIterator stack = ((ParserException)e).stack;
		    while(stack.hasPrevious()) {
			Node node = ((Node)((State)stack.previous()).node);
			System.out.println(node.getClass().getName() + node);
		    }
		}
	    }
       catch(Exception e)
            {	
              System.out.println(e.getMessage());
	      e.printStackTrace();
            }
    }
}










