package html;

import html.lexer.*;
import html.node.*;
import html.analysis.*;
import html.parser.*;
import java.io.*;
import java.util.*;

//Run with the following command "java Translator (input path) (*2Xml path)"

public class Translator {
    public static void main(String[] arguments) 
    {
     	try
	    { MyParser p = new MyParser(
		         new MyLexer (
	  	         new PushbackReader(
  		         new InputStreamReader(
		         new FileInputStream(arguments[0])),1024)));
	    Start tree = p.parse();
	    tree.apply(new DisplayAST("Abstract Syntax Tree"));
	    }
        catch(ParserException e)
	    { 
		System.out.println(e.getMessage());
		e.printStackTrace();
		if (((ParserException)e).stack != null) {
		    ListIterator stack = ((ParserException)e).stack;
		    while(stack.hasPrevious()) {
			Node node = ((Node)((State)stack.previous()).node);
			System.out.println(node.getClass().getName() + node);
		    }
		}
	    }
       catch(Exception e)
            {	
              System.out.println(e.getMessage());
	      e.printStackTrace();
            }
    }
}










