package html.analysis;

import java.util.*;
import html.analysis.*;
import html.node.*;

public class Directory2Xml extends DepthFirstAdapter
{
    private boolean inTable = false;
    private boolean inPerson = false;

    private boolean htmlBlockType(ANormalBlock node, String type)
    { return
	  ((AOpentag) node.getOpentag()).getTag().toString().trim().equalsIgnoreCase(type);
    }

    private String getContents(AMixedBlock node) {
	return node.getWord().toString();
    }

    public void inATbl(ATbl node)
    { inTable = true; }

    public void outATbl(ATbl node) 
    { inTable = false; output(node.getBlock()); }

    static private String getTagName(ANormalBlock node) {
	return getTagName((AMixedBlock) node.getBlock().getFirst());
    }

    static private String getTagName(AMixedBlock node) {
	return node.getWord().toString().replace(':',' ').trim();
    }

    static private ANormalBlock makeTagBlock(String name) {
	return new ANormalBlock(new AOpentag(new TOpen(),
					     new TTag(name.toLowerCase()),null,
					      new TClose()),
				new TypedLinkedList(),
				new AClosetag(new TOpen(),
					      new TSlash(),
					      new TTag(name.toLowerCase()),null,
					      new TClose()));
    }

    // Replace a "td" block with a "person" block.
    public void outANormalBlock(ANormalBlock node) {
	if (inTable) {
	    if (htmlBlockType(node,"td")) {
		ListIterator itr = node.getBlock().listIterator();
		LinkedList newBlock = new LinkedList();
		ANormalBlock newInnerBlock = makeTagBlock("name");
		while (itr.hasNext()) {
		    PBlock thisBlock = (PBlock)itr.next();
		    if (thisBlock instanceof ANormalBlock) {
			// This means its a block with a tag in <strong>'s
			String name = getTagName((ANormalBlock)thisBlock);
			if (!name.equals("name"))
			    newInnerBlock = makeTagBlock(getTagName((ANormalBlock)thisBlock));
			newBlock.add(newInnerBlock);
		    }
		    else newInnerBlock.getBlock().add(thisBlock);
		}
		if (newBlock.size() != 0) 
		    node.replaceBy(new ANormalBlock(new AOpentag(new TOpen(),
								 new TTag("person"),null,
								 new TClose()),
						    newBlock,
						    new AClosetag(new TOpen(),
								  new TSlash(),
								  new TTag("person"),null,
								  new TClose())));
		else node.parent().removeChild(node);
	    }
	    else if (htmlBlockType(node,"tr")) 
		{
		    if (node.getBlock().size() == 0)
			node.parent().removeChild(node);
		    else node.replaceBy((ANormalBlock)node.getBlock().getFirst());
		}
	    }
    }

    public void inABreakBlock(ABreakBlock node) {
	node.parent().removeChild(node);
    }

    private static void output(ANormalBlock node) {
	System.out.print("<" + ((AOpentag)node.getOpentag()).getTag() + "> ");
	output(node.getBlock());
	System.out.print("</" + ((AOpentag)node.getOpentag()).getTag() + "> ");
    }

    private static void output(AMixedBlock node) {
	System.out.print(node);
    }

    private static void output(List list) {
	ListIterator itr = list.listIterator();
	while(itr.hasNext()) {
	    PBlock bl = (PBlock)itr.next();
	    if (bl instanceof AMixedBlock) output((AMixedBlock)bl);
	    else output((ANormalBlock)bl);
	}
    }

}
