package html.analysis;

import html.analysis.*;
import html.node.*;
import javax.swing.tree.*;
import java.util.*;

public class DisplayAST extends DepthFirstAdapter
{
    private Hashtable table = new Hashtable();
    private String title;

    public DisplayAST(String theTitle)
    {
	title = theTitle;
    }

        public void defaultIn(Node node) {
	    //	System.out.println("Creating tree node " + node.getClass().getName());
	table.put(node,new DefaultMutableTreeNode(node.getClass().getName()));
	}
    public void outStart(Start node)
    {	
	 new DisplayTree((DefaultMutableTreeNode)table.get(node.getPDoc()),title);
	 
    }
    public void outADoc(ADoc node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	itr = node.getBlock().listIterator();
	while (itr.hasNext()) dnode.add((DefaultMutableTreeNode)table.get(itr.next()));
	dnode.add((DefaultMutableTreeNode)table.get(node.getBhtml()));
	if (node.getHd() != null)
	    dnode.add((DefaultMutableTreeNode)table.get(node.getHd()));
	itr = node.getBlock2().listIterator();
	while (itr.hasNext()) dnode.add((DefaultMutableTreeNode)table.get(itr.next()));
	dnode.add((DefaultMutableTreeNode)table.get(node.getBdy()));
	dnode.add((DefaultMutableTreeNode)table.get(node.getEhtml()));
	if (node.getEnd() != null)
	    dnode.add((DefaultMutableTreeNode)table.get(node.getEnd()));

    }
    public void outAHd(AHd node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add((DefaultMutableTreeNode)table.get(node.getBhead()));
	itr = node.getBlock().listIterator();
	while (itr.hasNext()) dnode.add((DefaultMutableTreeNode)table.get(itr.next()));
	dnode.add((DefaultMutableTreeNode)table.get(node.getEhead()));

    }
    public void outANormalBdy(ANormalBdy node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add((DefaultMutableTreeNode)table.get(node.getBbody()));
	itr = node.getBlock().listIterator();
	while (itr.hasNext()) dnode.add((DefaultMutableTreeNode)table.get(itr.next()));
	dnode.add((DefaultMutableTreeNode)table.get(node.getEbody()));

    }
    public void outAFramesetBdy(AFramesetBdy node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add((DefaultMutableTreeNode)table.get(node.getBfset()));
	itr = node.getFsblock().listIterator();
	while (itr.hasNext()) dnode.add((DefaultMutableTreeNode)table.get(itr.next()));
	dnode.add((DefaultMutableTreeNode)table.get(node.getEfset()));

    }
    public void outANormalBlock(ANormalBlock node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add((DefaultMutableTreeNode)table.get(node.getOpentag()));
	itr = node.getBlock().listIterator();
	while (itr.hasNext()) dnode.add((DefaultMutableTreeNode)table.get(itr.next()));
	dnode.add((DefaultMutableTreeNode)table.get(node.getClosetag()));

    }
    public void outAUlBlock(AUlBlock node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add((DefaultMutableTreeNode)table.get(node.getOpenul()));
	itr = node.getBlock().listIterator();
	while (itr.hasNext()) dnode.add((DefaultMutableTreeNode)table.get(itr.next()));
	dnode.add((DefaultMutableTreeNode)table.get(node.getCloseul()));

    }
    public void outAMixedBlock(AMixedBlock node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getWord()));

    }
    public void outAImgBlock(AImgBlock node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getImg()));
	if (node.getTb() != null)
		dnode.add(new DefaultMutableTreeNode(node.getTb()));	

    }
    public void outACommentBlock(ACommentBlock node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	if (node.getCs() != null)
		dnode.add(new DefaultMutableTreeNode(node.getCs()));	

    }
    public void outAHrBlock(AHrBlock node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getHr()));
	if (node.getTb() != null)
		dnode.add(new DefaultMutableTreeNode(node.getTb()));	

    }
    public void outAFrameBlock(AFrameBlock node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getFrame()));
	if (node.getTb() != null)
		dnode.add(new DefaultMutableTreeNode(node.getTb()));	

    }
    public void outAAreaBlock(AAreaBlock node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getArea()));
	if (node.getTb() != null)
		dnode.add(new DefaultMutableTreeNode(node.getTb()));	

    }
    public void outAOpenheaderBlock(AOpenheaderBlock node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getH()));
	dnode.add(new DefaultMutableTreeNode(node.getNumber()));
	if (node.getTb() != null)
		dnode.add(new DefaultMutableTreeNode(node.getTb()));	

    }
    public void outACloseheaderBlock(ACloseheaderBlock node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getH()));
	dnode.add(new DefaultMutableTreeNode(node.getNumber()));

    }
    public void outAOpenpBlock(AOpenpBlock node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getP()));
	if (node.getTb() != null)
		dnode.add(new DefaultMutableTreeNode(node.getTb()));	

    }
    public void outABaseBlock(ABaseBlock node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getBase()));
	if (node.getTb() != null)
		dnode.add(new DefaultMutableTreeNode(node.getTb()));	

    }
    public void outADoctypeBlock(ADoctypeBlock node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getDt()));
	if (node.getTb() != null)
		dnode.add(new DefaultMutableTreeNode(node.getTb()));	

    }
    public void outAOpenmetaBlock(AOpenmetaBlock node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getMeta()));
	if (node.getTb() != null)
		dnode.add(new DefaultMutableTreeNode(node.getTb()));	

    }
    public void outAClosepBlock(AClosepBlock node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getP()));

    }
    public void outALiBlock(ALiBlock node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getLi()));
	if (node.getTb() != null)
		dnode.add(new DefaultMutableTreeNode(node.getTb()));	

    }
    public void outACloseliBlock(ACloseliBlock node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getLi()));

    }
    public void outAOpenoptBlock(AOpenoptBlock node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getOption()));
	if (node.getTb() != null)
		dnode.add(new DefaultMutableTreeNode(node.getTb()));	

    }
    public void outACloseoptBlock(ACloseoptBlock node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getOption()));

    }
    public void outAInputBlock(AInputBlock node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getInput()));
	if (node.getTb() != null)
		dnode.add(new DefaultMutableTreeNode(node.getTb()));	

    }
    public void outAScriptBlock(AScriptBlock node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add((DefaultMutableTreeNode)table.get(node.getScr()));

    }
    public void outABreakBlock(ABreakBlock node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getBr()));
	if (node.getTb() != null)
		dnode.add(new DefaultMutableTreeNode(node.getTb()));	

    }
    public void outAOlBlock(AOlBlock node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add((DefaultMutableTreeNode)table.get(node.getOpenol()));
	itr = node.getBlock().listIterator();
	while (itr.hasNext()) dnode.add((DefaultMutableTreeNode)table.get(itr.next()));
	dnode.add((DefaultMutableTreeNode)table.get(node.getCloseol()));

    }
    public void outAFsFsblock(AFsFsblock node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add((DefaultMutableTreeNode)table.get(node.getBfset()));
	itr = node.getFsblock().listIterator();
	while (itr.hasNext()) dnode.add((DefaultMutableTreeNode)table.get(itr.next()));
	dnode.add((DefaultMutableTreeNode)table.get(node.getEfset()));

    }
    public void outANormalFsblock(ANormalFsblock node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add((DefaultMutableTreeNode)table.get(node.getBlock()));

    }
    public void outABodyFsblock(ABodyFsblock node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add((DefaultMutableTreeNode)table.get(node.getBbody()));
	itr = node.getBlock().listIterator();
	while (itr.hasNext()) dnode.add((DefaultMutableTreeNode)table.get(itr.next()));
	dnode.add((DefaultMutableTreeNode)table.get(node.getEbody()));

    }
    public void outAOpentag(AOpentag node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getTag()));
	if (node.getNumber() != null)
		dnode.add(new DefaultMutableTreeNode(node.getNumber()));	
	if (node.getTb() != null)
		dnode.add(new DefaultMutableTreeNode(node.getTb()));	

    }
    public void outAClosetag(AClosetag node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getTag()));
	if (node.getNumber() != null)
		dnode.add(new DefaultMutableTreeNode(node.getNumber()));	
	if (node.getTb() != null)
		dnode.add(new DefaultMutableTreeNode(node.getTb()));	

    }
    public void outAComment(AComment node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	if (node.getCs() != null)
		dnode.add(new DefaultMutableTreeNode(node.getCs()));	

    }
    public void outABscript(ABscript node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getScript()));
	if (node.getTb2() != null)
		dnode.add(new DefaultMutableTreeNode(node.getTb2()));	

    }
    public void outAScr(AScr node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add((DefaultMutableTreeNode)table.get(node.getBscript()));
	if (node.getSctext() != null)
		dnode.add(new DefaultMutableTreeNode(node.getSctext()));	
	dnode.add(new DefaultMutableTreeNode(node.getEscript()));

    }
    public void outAOpenul(AOpenul node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getUl()));
	if (node.getTb() != null)
		dnode.add(new DefaultMutableTreeNode(node.getTb()));	

    }
    public void outACloseul(ACloseul node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getUl()));
	if (node.getTb() != null)
		dnode.add(new DefaultMutableTreeNode(node.getTb()));	

    }
    public void outAOpenol(AOpenol node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getOl()));
	if (node.getTb() != null)
		dnode.add(new DefaultMutableTreeNode(node.getTb()));	

    }
    public void outACloseol(ACloseol node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getOl()));
	if (node.getTb() != null)
		dnode.add(new DefaultMutableTreeNode(node.getTb()));	

    }
    public void outABhtml(ABhtml node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getHtml()));
	if (node.getTb() != null)
		dnode.add(new DefaultMutableTreeNode(node.getTb()));	

    }
    public void outAEhtml(AEhtml node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getHtml()));
	if (node.getTb() != null)
		dnode.add(new DefaultMutableTreeNode(node.getTb()));	

    }
    public void outABhead(ABhead node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getHead()));
	if (node.getTb() != null)
		dnode.add(new DefaultMutableTreeNode(node.getTb()));	

    }
    public void outAEhead(AEhead node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getHead()));
	if (node.getTb() != null)
		dnode.add(new DefaultMutableTreeNode(node.getTb()));	

    }
    public void outABbody(ABbody node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getBody()));
	if (node.getTb() != null)
		dnode.add(new DefaultMutableTreeNode(node.getTb()));	

    }
    public void outAEbody(AEbody node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getBody()));
	if (node.getTb() != null)
		dnode.add(new DefaultMutableTreeNode(node.getTb()));	

    }
    public void outABfset(ABfset node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getFrameset()));
	if (node.getTb() != null)
		dnode.add(new DefaultMutableTreeNode(node.getTb()));	

    }
    public void outAEfset(AEfset node) {
	DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)table.get(node);
	ListIterator itr;
	dnode.add(new DefaultMutableTreeNode(node.getFrameset()));
	if (node.getTb() != null)
		dnode.add(new DefaultMutableTreeNode(node.getTb()));	

    }
}
