package html.analysis;

import html.analysis.*;
import html.node.*;

public class FindTables extends DepthFirstAdapter
{
    private boolean inTable = false;
    private boolean inPerson = false;

    private boolean tdBlock(ANormalBlock node)
    { return
	  ((AOpentag) node.getOpentag()).getTag().toString().equalsIgnoreCase("td ");
    }

    private String getContents(AMixedBlock node) {
	return node.getWord().toString();
    }

    public void inATbl(ATbl node)
    { inTable = true; System.out.println("Entering table");}

    public void outATbl(ATbl node) 
    { inTable = false; System.out.println("Exiting table"); }

    static private String getTagName(ANormalBlock node) {
	return getTagName(node.getBlock().getFirst());
    }

    static private String getTagName(AMixedBlock node) {
	return node.getWord().toString();
    }

    static private ANormalBlock makeTagBlock(String name) {
	return new ANormalBlock(new AOpentag(new TOpen(),
					      new TTag(name),
					      new TClose()),
				new TypedLinkedList(),
				new AClosetag(new TClose(),
					      new TSlash(),
					      new TTag(name),
					      new TClose()));
    }

    // Replace a "td" block with a "person" block.
    public void outANormalBlock(ANormalBlock node) {
	if (inTable && tdBlock(node)) {
	    ListIterator itr = node.getBlock().listIterator();
	    LinkedList newBlock = new TypedLinkedList(new Block_Cast());
	    while (itr.hasNext()) {
		Block thisBlock = itr.next();
		if (thisBlock instanceof ANormalBlock) {
		    // This means its a block with a tag in <strong>'s
		    ANormalBlock newInnerBlock = makeTagBlock(getTagName(thisBlock));
		    newBlock.add(newInnerBlock);
		}
		else newInnerBlock.getBlock().add(thisBlock);
	    }
	    node.replaceBy(
		new ANormalBlock(new AOpentag(new TOpen(),
					      new TTag("person"),
					      new TClose()),
				 newBlock,
				 new AClosetag(new TClose(),
					       new TSlash(),
					       new TTag("person"),
					       new TClose())));
	}
    }
					       


