package html.analysis;

import html.lexer.*;
import html.node.*;
import html.analysis.*;
import html.parser.*;
import java.io.*;
import java.util.*;
import java.util.regex.*;

public class GetExits extends DepthFirstAdaptor {

    private static hrefPattern = Pattern.compile("href=(\S*)");

    private static String getHref(String atts) {
	Matcher m = hrefPattern.matcher(atts);
	if ( m.find() ) { return m.group(1); }
	return null;
    } 
    
    public void caseANormalBlock(ANormalBlock node) {
	String opentagName = node.getOpentag() != null ? 
	    ((AOpentag)node.getOpentag()).getTag().getText().toLowerCase() : null;
	if ( opentagName.equals("form") ) { System.out.println(node);
	//	node.apply(new DepthFirstAdaptor() { })
	} else if ( opentagName.equals("a") ) { 
	    System.out.println(getHref((AOpentag)node.getOpentag()).getTb().getText());
	} else { super.caseANormalBlock(node); }
    }
}
