/* This file was generated by SableCC (http://www.sable.mcgill.ca/sablecc/). */

package html.lexer;

import java.io.*;
import java.util.*;
import html.node.*;

public class Lexer
{
    protected Token token;
    protected State state = State.NORMAL;

    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();

    protected void filter() throws LexerException, IOException
    {
    }

    public Lexer(PushbackReader in)
    {
        this.in = in;

        if(gotoTable == null)
        {
            try
            {
                DataInputStream s = new DataInputStream(
                    new BufferedInputStream(
                    Lexer.class.getResourceAsStream("lexer.dat")));

                // read gotoTable
                int length = s.readInt();
                gotoTable = new int[length][][][];
                for(int i = 0; i < gotoTable.length; i++)
                {
                    length = s.readInt();
                    gotoTable[i] = new int[length][][];
                    for(int j = 0; j < gotoTable[i].length; j++)
                    {
                        length = s.readInt();
                        gotoTable[i][j] = new int[length][3];
                        for(int k = 0; k < gotoTable[i][j].length; k++)
                        {
                            for(int l = 0; l < 3; l++)
                            {
                                gotoTable[i][j][k][l] = s.readInt();
                            }
                        }
                    }
                }

                // read accept
                length = s.readInt();
                accept = new int[length][];
                for(int i = 0; i < accept.length; i++)
                {
                    length = s.readInt();
                    accept[i] = new int[length];
                    for(int j = 0; j < accept[i].length; j++)
                    {
                        accept[i][j] = s.readInt();
                    }
                }

                s.close();
            }
            catch(Exception e)
            {
                throw new RuntimeException("Unable to read lexer.dat.");
            }
        }
    }

    public Token peek() throws LexerException, IOException
    {
        while(token == null)
        {
            token = getToken();
            filter();
        }

        return token;
    }

    public Token next() throws LexerException, IOException
    {
        while(token == null)
        {
            token = getToken();
            filter();
        }

        Token result = token;
        token = null;
        return result;
    }

    protected Token getToken() throws IOException, LexerException
    {
        int dfa_state = 0;

        int start_pos = pos;
        int start_line = line;

        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;

        int[][][] gotoTable = this.gotoTable[state.id()];
        int[] accept = this.accept[state.id()];
        text.setLength(0);

        while(true)
        {
            int c = getChar();

            if(c != -1)
            {
                switch(c)
                {
                case 10:
                    if(cr)
                    {
                        cr = false;
                    }
                    else
                    {
                        line++;
                        pos = 0;
                    }
                    break;
                case 13:
                    line++;
                    pos = 0;
                    cr = true;
                    break;
                default:
                    pos++;
                    cr = false;
                    break;
                };

                text.append((char) c);

                do
                {
                    int oldState = (dfa_state < -1) ? (-2 -dfa_state) : dfa_state;

                    dfa_state = -1;

                    int[][] tmp1 =  gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;

                    while(low <= high)
                    {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];

                        if(c < tmp2[0])
                        {
                            high = middle - 1;
                        }
                        else if(c > tmp2[1])
                        {
                            low = middle + 1;
                        }
                        else
                        {
                            dfa_state = tmp2[2];
                            break;
                        }
                    }
                }while(dfa_state < -1);
            }
            else
            {
                dfa_state = -1;
            }

            if(dfa_state >= 0)
            {
                if(accept[dfa_state] != -1)
                {
                    accept_state = dfa_state;
                    accept_token = accept[dfa_state];
                    accept_length = text.length();
                    accept_pos = pos;
                    accept_line = line;
                }
            }
            else
            {
                if(accept_state != -1)
                {
                    switch(accept_token)
                    {
                    case 0:
                        {
                            Token token = new0(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 1:
                        {
                            Token token = new1(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 7: state = State.SPECIAL; break;
                            }
                            return token;
                        }
                    case 2:
                        {
                            Token token = new2(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 7: state = State.SPECIAL; break;
                            }
                            return token;
                        }
                    case 3:
                        {
                            Token token = new3(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.TAG; break;
                                case 6: state = State.SCRIPT; break;
                                case 1: state = State.TAG; break;
                                case 2: state = State.TAGBAGGAGE; break;
                                case 4: state = State.TAGBAGGAGE2; break;
                            }
                            return token;
                        }
                    case 4:
                        {
                            Token token = new4(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 6: state = State.SCRIPT; break;
                            }
                            return token;
                        }
                    case 5:
                        {
                            Token token = new5(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.NORMAL; break;
                                case 6: state = State.SCRIPT; break;
                            }
                            return token;
                        }
                    case 6:
                        {
                            Token token = new6(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.TAG; break;
                            }
                            return token;
                        }
                    case 7:
                        {
                            Token token = new7(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.TAGBAGGAGE; break;
                            }
                            return token;
                        }
                    case 8:
                        {
                            Token token = new8(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.TAGBAGGAGE; break;
                            }
                            return token;
                        }
                    case 9:
                        {
                            Token token = new9(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.TAGBAGGAGE; break;
                            }
                            return token;
                        }
                    case 10:
                        {
                            Token token = new10(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.TAGBAGGAGE; break;
                            }
                            return token;
                        }
                    case 11:
                        {
                            Token token = new11(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.TAGBAGGAGE; break;
                            }
                            return token;
                        }
                    case 12:
                        {
                            Token token = new12(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.TAGBAGGAGE; break;
                            }
                            return token;
                        }
                    case 13:
                        {
                            Token token = new13(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.TAGBAGGAGE; break;
                            }
                            return token;
                        }
                    case 14:
                        {
                            Token token = new14(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.TAGBAGGAGE; break;
                            }
                            return token;
                        }
                    case 15:
                        {
                            Token token = new15(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.TAGBAGGAGE; break;
                            }
                            return token;
                        }
                    case 16:
                        {
                            Token token = new16(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.TAGBAGGAGE; break;
                            }
                            return token;
                        }
                    case 17:
                        {
                            Token token = new17(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.TAGBAGGAGE; break;
                            }
                            return token;
                        }
                    case 18:
                        {
                            Token token = new18(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.TAGBAGGAGE; break;
                            }
                            return token;
                        }
                    case 19:
                        {
                            Token token = new19(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.TAGBAGGAGE; break;
                            }
                            return token;
                        }
                    case 20:
                        {
                            Token token = new20(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.TAGBAGGAGE; break;
                            }
                            return token;
                        }
                    case 21:
                        {
                            Token token = new21(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.TAGBAGGAGE; break;
                            }
                            return token;
                        }
                    case 22:
                        {
                            Token token = new22(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.TAGBAGGAGE; break;
                            }
                            return token;
                        }
                    case 23:
                        {
                            Token token = new23(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.TAGBAGGAGE2; break;
                            }
                            return token;
                        }
                    case 24:
                        {
                            Token token = new24(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.TAGBAGGAGE1; break;
                            }
                            return token;
                        }
                    case 25:
                        {
                            Token token = new25(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.TAGBAGGAGE; break;
                            }
                            return token;
                        }
                    case 26:
                        {
                            Token token = new26(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.TAGBAGGAGE; break;
                            }
                            return token;
                        }
                    case 27:
                        {
                            Token token = new27(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 5: state = State.COMMENT; break;
                                case 1: state = State.COMMENT; break;
                            }
                            return token;
                        }
                    case 28:
                        {
                            Token token = new28(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 5: state = State.COMMENT; break;
                            }
                            return token;
                        }
                    case 29:
                        {
                            Token token = new29(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 5: state = State.COMMENT; break;
                            }
                            return token;
                        }
                    case 30:
                        {
                            Token token = new30(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 5: state = State.COMMENT; break;
                            }
                            return token;
                        }
                    case 31:
                        {
                            Token token = new31(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 5: state = State.COMMENT; break;
                            }
                            return token;
                        }
                    case 32:
                        {
                            Token token = new32(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.TAGBAGGAGE; break;
                            }
                            return token;
                        }
                    case 33:
                        {
                            Token token = new33(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.TAGBAGGAGE; break;
                            }
                            return token;
                        }
                    case 34:
                        {
                            Token token = new34(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.TAGBAGGAGE; break;
                            }
                            return token;
                        }
                    case 35:
                        {
                            Token token = new35(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.TAGBAGGAGE; break;
                            }
                            return token;
                        }
                    case 36:
                        {
                            Token token = new36(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 4: state = State.TAGBAGGAGE2; break;
                            }
                            return token;
                        }
                    case 37:
                        {
                            Token token = new37(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.TAGBAGGAGE; break;
                                case 4: state = State.SCRIPT; break;
                            }
                            return token;
                        }
                    case 38:
                        {
                            Token token = new38(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 39:
                        {
                            Token token = new39(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            switch(state.id())
                            {
                                case 3: state = State.TAGBAGGAGE; break;
                            }
                            return token;
                        }
                    }
                }
                else
                {
                    if(text.length() > 0)
                    {
                        throw new LexerException(
                            "[" + (start_line + 1) + "," + (start_pos + 1) + "]" +
                            " Unknown token: " + text);
                    }
                    else
                    {
                        EOF token = new EOF(
                            start_line + 1,
                            start_pos + 1);
                        return token;
                    }
                }
            }
        }
    }

    Token new0(String text, int line, int pos) { return new TBlank(text, line, pos); }
    Token new1(String text, int line, int pos) { return new TSpec(text, line, pos); }
    Token new2(int line, int pos) { return new TSemi(line, pos); }
    Token new3(int line, int pos) { return new TOpen(line, pos); }
    Token new4(String text, int line, int pos) { return new TSctext(text, line, pos); }
    Token new5(String text, int line, int pos) { return new TEscript(text, line, pos); }
    Token new6(int line, int pos) { return new TSlash(line, pos); }
    Token new7(String text, int line, int pos) { return new THtml(text, line, pos); }
    Token new8(String text, int line, int pos) { return new TMeta(text, line, pos); }
    Token new9(String text, int line, int pos) { return new THead(text, line, pos); }
    Token new10(String text, int line, int pos) { return new TBody(text, line, pos); }
    Token new11(String text, int line, int pos) { return new TArea(text, line, pos); }
    Token new12(String text, int line, int pos) { return new TBase(text, line, pos); }
    Token new13(String text, int line, int pos) { return new TBr(text, line, pos); }
    Token new14(String text, int line, int pos) { return new TP(text, line, pos); }
    Token new15(String text, int line, int pos) { return new TImg(text, line, pos); }
    Token new16(String text, int line, int pos) { return new TOption(text, line, pos); }
    Token new17(String text, int line, int pos) { return new TInput(text, line, pos); }
    Token new18(String text, int line, int pos) { return new TDt(text, line, pos); }
    Token new19(String text, int line, int pos) { return new TLi(text, line, pos); }
    Token new20(String text, int line, int pos) { return new THr(text, line, pos); }
    Token new21(String text, int line, int pos) { return new TUl(text, line, pos); }
    Token new22(String text, int line, int pos) { return new TOl(text, line, pos); }
    Token new23(String text, int line, int pos) { return new TScript(text, line, pos); }
    Token new24(String text, int line, int pos) { return new TH(text, line, pos); }
    Token new25(String text, int line, int pos) { return new TFrame(text, line, pos); }
    Token new26(String text, int line, int pos) { return new TFrameset(text, line, pos); }
    Token new27(int line, int pos) { return new TCom(line, pos); }
    Token new28(int line, int pos) { return new TDash(line, pos); }
    Token new29(int line, int pos) { return new TBang(line, pos); }
    Token new30(String text, int line, int pos) { return new TCs(text, line, pos); }
    Token new31(int line, int pos) { return new TEcom(line, pos); }
    Token new32(int line, int pos) { return new TAmp(line, pos); }
    Token new33(String text, int line, int pos) { return new TTag(text, line, pos); }
    Token new34(String text, int line, int pos) { return new TTb(text, line, pos); }
    Token new35(String text, int line, int pos) { return new TBad(text, line, pos); }
    Token new36(String text, int line, int pos) { return new TTb2(text, line, pos); }
    Token new37(int line, int pos) { return new TClose(line, pos); }
    Token new38(String text, int line, int pos) { return new TWord(text, line, pos); }
    Token new39(String text, int line, int pos) { return new TNumber(text, line, pos); }

    public void forceEOF() { eof = true; token = new EOF(); }

    private int getChar() throws IOException
    {
        if(eof)
        {
            return -1;
        }

        int result = in.read();

        if(result == -1)
        {
            eof = true;
        }

        return result;
    }

    private void pushBack(int acceptLength) throws IOException
    {
        int length = text.length();
        for(int i = length - 1; i >= acceptLength; i--)
        {
            eof = false;

            in.unread(text.charAt(i));
        }
    }

    protected void unread(Token token) throws IOException
    {
        String text = token.getText();
        int length = text.length();

        for(int i = length - 1; i >= 0; i--)
        {
            eof = false;

            in.unread(text.charAt(i));
        }

        pos = token.getPos() - 1;
        line = token.getLine() - 1;
    }

    private String getText(int acceptLength)
    {
        StringBuffer s = new StringBuffer(acceptLength);
        for(int i = 0; i < acceptLength; i++)
        {
            s.append(text.charAt(i));
        }

        return s.toString();
    }

    private static int[][][][] gotoTable;
/*  {
        { // NORMAL
            {{0, 8, 1}, {9, 9, 2}, {10, 10, 3}, {11, 12, 1}, {13, 13, 4}, {14, 31, 1}, {32, 32, 5}, {33, 43, 1}, {44, 44, 6}, {45, 45, 1}, {46, 46, 7}, {47, 57, 1}, {58, 58, 8}, {59, 59, 9}, {60, 60, 10}, {61, 65535, 1}, },
            {{0, 8, 1}, {11, 12, 1}, {14, 31, 1}, {33, 43, 1}, {45, 45, 1}, {47, 57, 1}, {61, 65535, 1}, },
            {{9, 10, -2}, {13, 13, 4}, {32, 32, 5}, {44, 44, 6}, {46, 46, 7}, {58, 59, -2}, },
            {{9, 59, -4}, },
            {{9, 9, 2}, {10, 10, 11}, {13, 59, -4}, },
            {{9, 59, -4}, },
            {{9, 59, -4}, },
            {{9, 59, -4}, },
            {{9, 59, -4}, },
            {{9, 59, -4}, },
            {{47, 47, 12}, },
            {{9, 59, -4}, },
            {{83, 83, 13}, {115, 115, 13}, },
            {{67, 67, 14}, {99, 99, 14}, },
            {{82, 82, 15}, {114, 114, 15}, },
            {{73, 73, 16}, {105, 105, 16}, },
            {{80, 80, 17}, {112, 112, 17}, },
            {{84, 84, 18}, {116, 116, 18}, },
            {{62, 62, 19}, },
            {},
        }
        { // TAG
            {{33, 33, 1}, {47, 47, 2}, {58, 58, 3}, {60, 60, 4}, {65, 65, 5}, {66, 66, 6}, {67, 69, 7}, {70, 70, 8}, {71, 71, 7}, {72, 72, 9}, {73, 73, 10}, {74, 75, 7}, {76, 76, 11}, {77, 77, 12}, {78, 78, 7}, {79, 79, 13}, {80, 80, 14}, {81, 82, 7}, {83, 83, 15}, {84, 84, 7}, {85, 85, 16}, {86, 90, 7}, {95, 95, 17}, {97, 97, 18}, {98, 98, 19}, {99, 101, 20}, {102, 102, 21}, {103, 103, 20}, {104, 104, 22}, {105, 105, 23}, {106, 107, 20}, {108, 108, 24}, {109, 109, 25}, {110, 110, 20}, {111, 111, 26}, {112, 112, 27}, {113, 114, 20}, {115, 115, 28}, {116, 116, 20}, {117, 117, 29}, {118, 122, 20}, },
            {{33, 33, 30}, {45, 45, 31}, {58, 58, 3}, {65, 67, 7}, {68, 68, 32}, {69, 90, 7}, {95, 95, 17}, {97, 99, 20}, {100, 100, 33}, {101, 122, 20}, },
            {},
            {{33, 33, 30}, {58, 58, 3}, {65, 90, 7}, {95, 95, 17}, {97, 122, 20}, },
            {},
            {{33, 58, -5}, {65, 81, 7}, {82, 82, 34}, {83, 90, 7}, {95, 95, 17}, {97, 113, 20}, {114, 114, 35}, {115, 122, 20}, },
            {{33, 58, -5}, {65, 65, 36}, {66, 78, 7}, {79, 79, 37}, {80, 81, 7}, {82, 82, 38}, {83, 95, -7}, {97, 97, 39}, {98, 110, 20}, {111, 111, 40}, {112, 113, 20}, {114, 114, 41}, {115, 122, 20}, },
            {{33, 122, -5}, },
            {{33, 81, -7}, {82, 82, 42}, {83, 113, -7}, {114, 114, 43}, {115, 122, 20}, },
            {{33, 58, -5}, {65, 68, 7}, {69, 69, 44}, {70, 81, 7}, {82, 82, 45}, {83, 83, 7}, {84, 84, 46}, {85, 90, 7}, {95, 95, 17}, {97, 100, 20}, {101, 101, 47}, {102, 113, 20}, {114, 114, 48}, {115, 115, 20}, {116, 116, 49}, {117, 122, 20}, },
            {{33, 58, -5}, {65, 76, 7}, {77, 77, 50}, {78, 78, 51}, {79, 90, 7}, {95, 95, 17}, {97, 108, 20}, {109, 109, 52}, {110, 110, 53}, {111, 122, 20}, },
            {{33, 58, -5}, {65, 72, 7}, {73, 73, 54}, {74, 90, 7}, {95, 95, 17}, {97, 104, 20}, {105, 105, 55}, {106, 122, 20}, },
            {{33, 68, -11}, {69, 69, 56}, {70, 90, 7}, {95, 100, -11}, {101, 101, 57}, {102, 122, 20}, },
            {{33, 58, -5}, {65, 75, 7}, {76, 76, 58}, {77, 79, 7}, {80, 80, 59}, {81, 90, 7}, {95, 95, 17}, {97, 107, 20}, {108, 108, 60}, {109, 111, 20}, {112, 112, 61}, {113, 122, 20}, },
            {{33, 122, -5}, },
            {{33, 58, -5}, {65, 66, 7}, {67, 67, 62}, {68, 90, 7}, {95, 95, 17}, {97, 98, 20}, {99, 99, 63}, {100, 122, 20}, },
            {{33, 75, -15}, {76, 76, 64}, {77, 90, 7}, {95, 107, -15}, {108, 108, 65}, {109, 122, 20}, },
            {{33, 122, -5}, },
            {{33, 122, -7}, },
            {{33, 122, -8}, },
            {{33, 122, -5}, },
            {{33, 122, -10}, },
            {{33, 122, -11}, },
            {{33, 122, -12}, },
            {{33, 122, -13}, },
            {{33, 122, -14}, },
            {{33, 122, -15}, },
            {{33, 122, -5}, },
            {{33, 122, -17}, },
            {{33, 122, -18}, },
            {{33, 122, -5}, },
            {{45, 45, 66}, },
            {{33, 58, -5}, {65, 78, 7}, {79, 79, 67}, {80, 90, 7}, {95, 95, 17}, {97, 110, 20}, {111, 111, 68}, {112, 122, 20}, },
            {{33, 122, -34}, },
            {{33, 68, -11}, {69, 69, 69}, {70, 100, -14}, {101, 101, 70}, {102, 122, 20}, },
            {{33, 122, -36}, },
            {{33, 58, -5}, {65, 82, 7}, {83, 83, 71}, {84, 90, 7}, {95, 95, 17}, {97, 114, 20}, {115, 115, 72}, {116, 122, 20}, },
            {{33, 58, -5}, {65, 67, 7}, {68, 68, 73}, {69, 99, -3}, {100, 100, 74}, {101, 122, 20}, },
            {{33, 122, -5}, },
            {{33, 122, -38}, },
            {{33, 122, -39}, },
            {{33, 122, -5}, },
            {{33, 58, -5}, {65, 65, 75}, {66, 90, 7}, {95, 95, 17}, {97, 97, 76}, {98, 122, 20}, },
            {{33, 122, -44}, },
            {{33, 58, -5}, {65, 65, 77}, {66, 95, -44}, {97, 97, 78}, {98, 122, 20}, },
            {{33, 122, -5}, },
            {{33, 76, -12}, {77, 77, 79}, {78, 90, 7}, {95, 108, -12}, {109, 109, 80}, {110, 122, 20}, },
            {{33, 122, -46}, },
            {{33, 122, -5}, },
            {{33, 122, -48}, },
            {{33, 58, -5}, {65, 70, 7}, {71, 71, 81}, {72, 90, 7}, {95, 95, 17}, {97, 102, 20}, {103, 103, 82}, {104, 122, 20}, },
            {{33, 58, -5}, {65, 79, 7}, {80, 80, 83}, {81, 95, -15}, {97, 111, 20}, {112, 112, 84}, {113, 122, 20}, },
            {{33, 122, -52}, },
            {{33, 122, -53}, },
            {{33, 122, -5}, },
            {{33, 122, -5}, },
            {{33, 58, -5}, {65, 83, 7}, {84, 84, 85}, {85, 95, -11}, {97, 115, 20}, {116, 116, 86}, {117, 122, 20}, },
            {{33, 122, -58}, },
            {{33, 122, -5}, },
            {{33, 83, -58}, {84, 84, 87}, {85, 115, -58}, {116, 116, 88}, {117, 122, 20}, },
            {{33, 122, -5}, },
            {{33, 122, -61}, },
            {{33, 81, -7}, {82, 82, 89}, {83, 113, -7}, {114, 114, 90}, {115, 122, 20}, },
            {{33, 122, -64}, },
            {{33, 122, -5}, },
            {{33, 122, -5}, },
            {},
            {{33, 66, -17}, {67, 67, 91}, {68, 98, -17}, {99, 99, 92}, {100, 122, 20}, },
            {{33, 122, -69}, },
            {{33, 58, -5}, {65, 65, 93}, {66, 95, -44}, {97, 97, 94}, {98, 122, 20}, },
            {{33, 122, -71}, },
            {{33, 68, -11}, {69, 69, 95}, {70, 100, -14}, {101, 101, 96}, {102, 122, 20}, },
            {{33, 122, -73}, },
            {{33, 58, -5}, {65, 88, 7}, {89, 89, 97}, {90, 90, 7}, {95, 95, 17}, {97, 120, 20}, {121, 121, 98}, {122, 122, 20}, },
            {{33, 122, -75}, },
            {{33, 76, -12}, {77, 77, 99}, {78, 108, -48}, {109, 109, 100}, {110, 122, 20}, },
            {{33, 122, -77}, },
            {{33, 67, -39}, {68, 68, 101}, {69, 99, -3}, {100, 100, 102}, {101, 122, 20}, },
            {{33, 122, -79}, },
            {{33, 75, -15}, {76, 76, 103}, {77, 107, -18}, {108, 108, 104}, {109, 122, 20}, },
            {{33, 122, -81}, },
            {{33, 122, -5}, },
            {{33, 122, -5}, },
            {{33, 58, -5}, {65, 84, 7}, {85, 85, 105}, {86, 95, -2}, {97, 116, 20}, {117, 117, 106}, {118, 122, 20}, },
            {{33, 122, -85}, },
            {{33, 58, -5}, {65, 65, 107}, {66, 95, -44}, {97, 97, 108}, {98, 122, 20}, },
            {{33, 122, -87}, },
            {{33, 72, -13}, {73, 73, 109}, {74, 104, -13}, {105, 105, 110}, {106, 122, 20}, },
            {{33, 122, -89}, },
            {{33, 72, -13}, {73, 73, 111}, {74, 104, -13}, {105, 105, 112}, {106, 122, 20}, },
            {{33, 122, -91}, },
            {{33, 83, -58}, {84, 84, 113}, {85, 115, -58}, {116, 116, 114}, {117, 122, 20}, },
            {{33, 122, -93}, },
            {{33, 122, -5}, },
            {{33, 122, -5}, },
            {{33, 122, -5}, },
            {{33, 122, -5}, },
            {{33, 122, -5}, },
            {{33, 122, -5}, },
            {{33, 68, -11}, {69, 69, 115}, {70, 100, -14}, {101, 101, 116}, {102, 122, 20}, },
            {{33, 122, -101}, },
            {{33, 122, -5}, },
            {{33, 122, -5}, },
            {{33, 122, -5}, },
            {{33, 122, -5}, },
            {{33, 83, -58}, {84, 84, 117}, {85, 115, -58}, {116, 116, 118}, {117, 122, 20}, },
            {{33, 122, -107}, },
            {{33, 122, -5}, },
            {{33, 122, -5}, },
            {{33, 78, -34}, {79, 79, 119}, {80, 110, -34}, {111, 111, 120}, {112, 122, 20}, },
            {{33, 122, -111}, },
            {{33, 79, -53}, {80, 80, 121}, {81, 111, -53}, {112, 112, 122}, {113, 122, 20}, },
            {{33, 122, -113}, },
            {{33, 88, -75}, {89, 89, 123}, {90, 120, -75}, {121, 121, 124}, {122, 122, 20}, },
            {{33, 122, -115}, },
            {{33, 82, -38}, {83, 83, 125}, {84, 114, -38}, {115, 115, 126}, {116, 122, 20}, },
            {{33, 122, -117}, },
            {{33, 122, -5}, },
            {{33, 122, -5}, },
            {{33, 58, -5}, {65, 77, 7}, {78, 78, 127}, {79, 95, -12}, {97, 109, 20}, {110, 110, 128}, {111, 122, 20}, },
            {{33, 122, -121}, },
            {{33, 83, -58}, {84, 84, 129}, {85, 115, -58}, {116, 116, 130}, {117, 122, 20}, },
            {{33, 122, -123}, },
            {{33, 79, -53}, {80, 80, 131}, {81, 111, -53}, {112, 112, 132}, {113, 122, 20}, },
            {{33, 122, -125}, },
            {{33, 68, -11}, {69, 69, 133}, {70, 100, -14}, {101, 101, 134}, {102, 122, 20}, },
            {{33, 122, -127}, },
            {{33, 122, -5}, },
            {{33, 122, -5}, },
            {{33, 122, -5}, },
            {{33, 122, -5}, },
            {{33, 68, -11}, {69, 69, 135}, {70, 100, -14}, {101, 101, 136}, {102, 122, 20}, },
            {{33, 122, -133}, },
            {{33, 83, -58}, {84, 84, 137}, {85, 115, -58}, {116, 116, 138}, {117, 122, 20}, },
            {{33, 122, -135}, },
            {{33, 122, -5}, },
            {{33, 122, -5}, },
            {{33, 122, -5}, },
            {{33, 122, -5}, },
        }
        { // TAGBAGGAGE
            {{0, 9, 1}, {10, 10, 2}, {11, 12, 1}, {13, 13, 2}, {14, 31, 1}, {32, 37, 3}, {38, 38, 4}, {39, 59, 3}, {60, 60, 5}, {61, 61, 3}, {62, 62, 6}, {63, 127, 3}, {128, 65535, 1}, },
            {},
            {{10, 10, 3}, {13, 13, 3}, {32, 37, 3}, {39, 59, 3}, {61, 61, 3}, {63, 127, 3}, },
            {{10, 127, -4}, },
            {},
            {},
            {},
        }
        { // TAGBAGGAGE1
            {{48, 57, 1}, },
            {{48, 57, 1}, },
        }
        { // TAGBAGGAGE2
            {{0, 59, 1}, {60, 60, 2}, {61, 61, 1}, {62, 62, 3}, {63, 65535, 1}, },
            {{0, 59, 1}, {61, 61, 1}, {63, 65535, 1}, },
            {},
            {},
        }
        { // COMMENT
            {{0, 32, 1}, {33, 33, 2}, {34, 44, 1}, {45, 45, 3}, {46, 65535, 1}, },
            {{0, 32, 1}, {34, 44, 1}, {46, 65535, 1}, },
            {{45, 45, 4}, },
            {{45, 45, 5}, },
            {{45, 45, 6}, },
            {{62, 62, 7}, },
            {},
            {},
        }
        { // SCRIPT
            {{0, 59, 1}, {60, 60, 2}, {61, 65535, 1}, },
            {{0, 59, 1}, {61, 65535, 1}, },
            {{47, 47, 3}, },
            {{83, 83, 4}, {115, 115, 4}, },
            {{67, 67, 5}, {99, 99, 5}, },
            {{82, 82, 6}, {114, 114, 6}, },
            {{73, 73, 7}, {105, 105, 7}, },
            {{80, 80, 8}, {112, 112, 8}, },
            {{84, 84, 9}, {116, 116, 9}, },
            {{62, 62, 10}, },
            {},
        }
        { // SPECIAL
            {{35, 35, 1}, {48, 57, 2}, {59, 59, 3}, {65, 90, 4}, {97, 122, 5}, },
            {{35, 57, -2}, {65, 122, -2}, },
            {{35, 122, -3}, },
            {},
            {{35, 122, -3}, },
            {{35, 122, -3}, },
        }
    };*/

    private static int[][] accept;
/*  {
        // NORMAL
        {-1, 38, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, -1, -1, -1, -1, -1, -1, -1, 5, },
        // TAG
        {-1, 33, 6, 33, 3, 33, 33, 33, 33, 24, 33, 33, 33, 33, 14, 33, 33, 33, 33, 33, 33, 33, 24, 33, 33, 33, 33, 14, 33, 33, 33, -1, 33, 33, 33, 33, 33, 33, 13, 33, 33, 13, 33, 33, 33, 20, 33, 33, 20, 33, 33, 33, 33, 33, 19, 19, 33, 33, 22, 33, 22, 33, 33, 33, 21, 21, 27, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 15, 15, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 11, 11, 12, 12, 10, 10, 33, 33, 9, 9, 7, 7, 33, 33, 8, 8, 33, 33, 33, 33, 33, 33, 25, 25, 17, 17, 33, 33, 33, 33, 33, 33, 33, 33, 16, 16, 23, 23, 33, 33, 33, 33, 18, 18, 26, 26, },
        // TAGBAGGAGE
        {34, 35, 34, 34, 32, 3, 37, },
        // TAGBAGGAGE1
        {-1, 39, },
        // TAGBAGGAGE2
        {36, 36, 3, 37, },
        // COMMENT
        {30, 30, 29, 28, -1, -1, 27, 31, },
        // SCRIPT
        {4, 4, 3, -1, -1, -1, -1, -1, -1, -1, 5, },
        // SPECIAL
        {-1, 1, 1, 2, 1, 1, },

    };*/

    public static class State
    {
        public final static State NORMAL = new State(0);
        public final static State TAG = new State(1);
        public final static State TAGBAGGAGE = new State(2);
        public final static State TAGBAGGAGE1 = new State(3);
        public final static State TAGBAGGAGE2 = new State(4);
        public final static State COMMENT = new State(5);
        public final static State SCRIPT = new State(6);
        public final static State SPECIAL = new State(7);

        private int id;

        private State(int id)
        {
            this.id = id;
        }

        public int id()
        {
            return id;
        }
    }
}
