package html.lexer;

import html.lexer.Lexer;
import html.lexer.Lexer.State;
import java.io.IOException;
import html.node.*;
import java.util.HashMap;
public class MyLexer extends Lexer
{
    private int counter = 0;
    private int counter1 = 1;
    private TCs comment;
    private TTb tagBaggage;
    private Token scText;
    private StringBuffer text = new StringBuffer();
    HashMap specialCharTable;

    public MyLexer(java.io.PushbackReader in) { 
	super(in);
	// Temporary solution to filling specialCharTable
	specialCharTable = new HashMap();
	specialCharTable.put("AMP","&");
	specialCharTable.put("QUOT","\"");	
	specialCharTable.put("NBSP"," ");
    }

    public void setState(State state) { this.state = state; }

    public State getState() { return this.state; }

    public void smashToken() { token = null; }

    private void doTagBaggage() {
	if (token instanceof TTb) {
	    if (tagBaggage == null) {
		tagBaggage = (TTb)token;
		text.setLength(0); text.append(token.getText());
	    } else { text.append(token.getText()); token = null; }
	} else if ( token instanceof TClose ) {
	    if ( tagBaggage != null ) tagBaggage.setText(text.toString()); 
	    tagBaggage = null; state = state.NORMAL;
	} else if ( token instanceof TOpen) { 
	    if ( tagBaggage != null ) tagBaggage.setText(text.toString()); 
	    tagBaggage = null; state = state.NORMAL; 
	    try { unread(token); } catch (IOException e) {}
	}
    }	    

    protected void filter() {
	if ( token instanceof EOF ) { return; }
	if ((state.equals(State.COMMENT))) {
	    if (comment == null) {
		comment = new TCs("",token.getLine(),token.getPos());
		text.setLength(0);
		counter = 1;
	    } 
	    else 
		{  
		    text.append(token.getText());
		    if (token instanceof TOpen) counter++;
		    else if (token instanceof TEcom) counter --;
		    if (counter != 0) token = null;
		    else
			{
			    comment.setText(text.toString());
			    token = comment; comment = null;  
			    state = state.NORMAL;
			}
		}
	} else if ( state.equals(State.TAGBAGGAGE) ) { 
	    if ( token instanceof TAmp ) 
		{ token = null; state = state.SPECIAL; }
	    else doTagBaggage();
	}
	else if ( state.equals(State.SPECIAL) ) {
	    Token next = null;
	    try { next = getToken(); } catch (Exception e) { }
	    if ( next != null && next instanceof TSemi ) {
		String replacementText = (String)specialCharTable.get((token.getText()).toUpperCase());
		if ( replacementText != null ) token = new TTb(replacementText);
		else token = new TTb("&" + token.getText() + ";");
	    } else { 
		if ( next != null) { try { unread(next); } catch (IOException e) {} }
		token = new TTb("&" + token.getText()); }
	    state = state.TAGBAGGAGE;
	    doTagBaggage();
	}	
	else if ( state.equals(State.TAGBAGGAGE2) ) {
	    if ( token instanceof TOpen ) { 
		try { unread(token); } catch (IOException e) {}
		state = state.SCRIPT;
	    }
	}
	else if ((state.equals(State.SCRIPT)) && !(token instanceof TClose)) {
	    if (scText == null) {
		scText = new TSctext(token.getText(),token.getLine(),token.getPos());
		text.setLength(0);
		if (!(token instanceof TEscript)) token = scText;
	    }
	    if (token instanceof TEscript) {
		scText.setText(text.toString()); state = state.NORMAL; 
		scText = null;
	    } else {text.append(token.getText()); token = null; }
	}
    }
}
