package html.parser;

import html.lexer.*;
import html.node.*;
import html.analysis.*;
import java.util.*;
import java.io.IOException;

public class MyParser extends Parser {

    public MyParser(Lexer lexer) {super(lexer);}

    private boolean stackContains(String clss) {
	ListIterator i = initScanStack();
	while (i.hasPrevious()) {
	    try {
		State s = (State)i.previous();
		if (s.node.getClass().getName().equals(clss)) return true; 
	    }
	    catch (NullPointerException e) { return false; }
	}
	return false;
    }	    

    protected void recover(int errorIndex, Token tok) throws ParserException, LexerException, IOException {
	//System.out.println("Recover case " + errorIndex +errorMessages[errorIndex] + " at position [" +
	//last_line + "," + last_pos + "], Next Token: " + tok + " " + tok.getClass());
	switch (errorIndex)
	    {
  	    // 0	"TOpen TWord expected."
	    case 0: { find(new TOpen()); push(action[1], new TOpen(), true);
	    last_shift = action[1]; break; }
	    // 1	"TSlash THtml TMeta TArea TBase TBr TP TImg TOption TInput TDt TLi THr TUl TH
	    // TFrame TCom TTag expected.",
	    case 1: {
		    insertedTokens = new TypedLinkedList(NodeCast.instance);
		    find(new THtml("html"));
		    push(action[1],new THtml("html"), true);
		    insertedTokens.add(new TClose());
		    insertedTokens.add(new TOpen());
		    last_shift = action[1];
		    break;
	            }
	    //	2	"EOF expected.",
	    case 2: { lexer.forceEOF(); insertedTokens = null; break; }
	   // 3         "TSctext TEscript expected."
	    case 3: { ((MyLexer)lexer).setState(Lexer.State.SCRIPT); ((MyLexer)lexer).smashToken(); break; }

	   // 4         "TP TOption TLi TH expected."
	    case 4: {
                    stack.previous(); stack.previous();
                    lexer.next(); lexer.next(); break;
	    }
	    // 5        "TTb TClose expected."
	    // 6        "TTb2 TClose expected.",
	    // 7        "TNumber expected."
 	    // 8	"TOpen TCs TWord expected.",
	    case 8: { find(new TCs("cs")); push(action[1], new TCs("cs"), true); 
	    last_shift = action[1]; break; }
	    // 9        "TTb TClose TNumber expected.
	    // 10        "TSlash TMeta TArea TBase TBr TP TImg TOption TInput TDt TLi THr TUl TScript TH TFrame TCom 
	    //           TTag expected."
	    case 10:
		{   
		    /* if (tok instanceof TBody) {
			boolean slashDone = false;
			insertedTokens = new TypedLinkedList(NodeCast.instance);
			Token openTag = fix.topTag();
			while (openTag != null) {
			    //System.out.println("Top tag: " + openTag);
			    if (!slashDone) {
				find(new TSlash());
				push(action[1],new TSlash(),true);
				slashDone = true;
			    }
			    else insertedTokens.add(new TSlash());
			    insertedTokens.add(new TTag(openTag.getText()));
			    insertedTokens.add(new TClose());
			    insertedTokens.add(new TOpen());
			    fix.popTopTag(openTag);
			    openTag = fix.topTag();
			}
			if (stackContains("html.node.ABhead")) {
			    if (!slashDone) {
				find(new TSlash());
				push(action[1],new TSlash(),true);
				slashDone = true;
			    }
			    else insertedTokens.add(new TSlash());
			    insertedTokens.add(new THead("head"));
			    insertedTokens.add(new TClose());
			    insertedTokens.add(new TOpen());
			}
			else if (stackContains("html.node.ABbody")) {
			    stack.previous(); stack.previous();
			    lexer.next(); lexer.next();
			    if (lexer.peek() instanceof TClose)
				lexer.next();
			}
			break;
			} */
		    if (tok instanceof THtml || tok instanceof THead || tok instanceof TBody) {
			find(new TP("P",0,0)); push(action[1], new TP("P",tok.getLine(),tok.getPos()), true);
			lexer.next(); last_shift = action[1]; break;
		    }
		    else throw new ParserException(stack,
					  "[" + last_line + "," + last_pos + "] Next Token: " +
						   lexer.peek() + " " + lexer.peek().getClass() + " " +
					  errorMessages[errorIndex]);
		}
	    // 11       "TEscript expected."
	    //  12	"TSlash THtml TMeta TArea TBase TBr TP TImg TOption TInput TLi THr TUl TH TCom
	    //           TTag expected.",
	    case 12:
		{ 
		    throw new ParserException(stack,
					  "[" + last_line + "," + last_pos + "] Next Token: " +
					      lexer.peek() + " " + lexer.peek().getClass() + " " +
					  errorMessages[errorIndex]);
		}
	    // 13	"TOpen expected.",
	    case 13: { if (tok instanceof EOF) {
			   insertedTokens = new TypedLinkedList(NodeCast.instance);
			   insertedTokens.add(new TSlash());
			   insertedTokens.add(new THtml("html"));
			   insertedTokens.add(new TClose());
		       }
	             find(new TOpen()); push(action[1], new TOpen(), true);
		     last_shift = action[1]; 
		     break; }
	    //14	"TClose expected."
	    case 14: { insertedTokens = new TypedLinkedList(NodeCast.instance);
	               insertedTokens.add(new TClose());
		       if ( ((MyLexer)lexer).getState().equals(Lexer.State.TAGBAGGAGE) ) ((MyLexer)lexer).setState(Lexer.State.NORMAL);
		       ((MyLexer)lexer).smashToken();
	               break;
	             }

	    // 15	"TP TOption TLi TH TTag expected.",
	    case 15: { Token openTag = fix.topTag();
	               if (openTag == null) {
			   stack.previous(); stack.previous();
			   lexer.next(); lexer.next(); break;
		       }
	               String openTagText =  openTag.getText();
		       insertedTokens = new TypedLinkedList(NodeCast.instance);
		       insertedTokens.add(new TTag(openTagText));
		       insertedTokens.add(new TClose());
		       insertedTokens.add(new TOpen());
		       insertedTokens.add(new TSlash());
		       break; }
	    // 16	"TP TOption TLi TUl TH expected.",
	    case 16: { Token openTag = (Token) fix.topTag();
	               if (openTag == null) {
			   stack.previous(); stack.previous();
			   lexer.next(); lexer.next(); break;
		       }
 	               insertedTokens = new TypedLinkedList(NodeCast.instance);
		       insertedTokens.add(openTag.clone());
		       insertedTokens.add(new TClose());
		       insertedTokens.add(new TOpen());
		       insertedTokens.add(new TSlash());
		       break;}
	    // 17       "TP TOption TLi TOl TH expected.",
	    case 17: { Token openTag = (Token) fix.topTag();
	               if (openTag == null) {
			   stack.previous(); stack.previous();
			   lexer.next(); lexer.next(); break;
		       }
 	               insertedTokens = new TypedLinkedList(NodeCast.instance);
		       insertedTokens.add(openTag.clone());
		       insertedTokens.add(new TClose());
		       insertedTokens.add(new TOpen());
		       insertedTokens.add(new TSlash());
		       break;}
	    // 18       "TSlash TMeta TBody TArea TBase TBr TP TImg TOption TInput TDt TLi THr TUl TScript TH TFrame
	    //		        "TFrameset TCom TTag expected."
	    case 18: 
		{
		    if (tok instanceof THead) {
			stack.previous(); stack.previous();
			insertedTokens = new TypedLinkedList(NodeCast.instance);
			insertedTokens.add(new TOpen());
			insertedTokens.add(tok);
			lexer.next();
			break;
		    }
		    else if (tok instanceof THtml) {
			State topState = (State)stack.previous();
			while (!(topState.node instanceof ABhtml))
			    topState = (State)stack.previous();
			stack.next(); lexer.next(); lexer.next();
		    }
		    else throw new ParserException(stack,
					  "[" + last_line + "," + last_pos + "] Next Token: " +
					  tok + " of class " + tok.getClass() + " Case " + errorIndex 
					  + " " + errorMessages[errorIndex]);
		}
	    // 19     "TSlash expected."
	    case 19:
		{ stack.previous(); lexer.next(); lexer.next(); break; }
	    //20 	   "TOpen EOF expected."
	    //21 	   "THtml expected."
	    case 21:
		{
		    stack.previous(); lexer.forceEOF(); insertedTokens = null; break;
		}
	   //22		   "TCom expected."
	    case 22:
		{
		    stack.previous(); lexer.forceEOF(); insertedTokens = null; break;
		}
	    // 23	"TCs EOF expected.",
	    case 23:
		{
		    lexer.forceEOF(); insertedTokens = null; break;
		}
	    // 24	"THead TP TOption TLi TH expected.",
	    case 24:
		{
		    stack.previous(); stack.previous();
		    lexer.next(); lexer.next(); break;
		}
	   // 25	  "TBody TP TOption TLi TH expected."
	    case 25: 
		{   
                    stack.previous(); stack.previous();
                    lexer.next(); lexer.next(); insertedTokens = null;
		    break;
		} 
	    // 26	"TP TOption TLi TH TTag expected.",
	    case 26: { Token openTag = fix.topTag();
	               if (openTag == null) {
			   stack.previous(); stack.previous();
			   lexer.next(); lexer.next(); break;
		       }
	               String openTagText =  openTag.getText();
		       insertedTokens = new TypedLinkedList(NodeCast.instance);
		       insertedTokens.add(new TTag(openTagText));
		       insertedTokens.add(new TClose());
		       insertedTokens.add(new TOpen());
		       insertedTokens.add(new TSlash());
		       fix.popTopTag(openTag);
		       break; }
	    default:
		throw new ParserException(stack,
					  "[" + last_line + "," + last_pos + "] Next Token: " +
					  tok + " of class " + tok.getClass() + " Case " + errorIndex 
					  + " " + errorMessages[errorIndex]);
	    }
    }

    private class Stack {
	private ListIterator sp;
	private LinkedList spList;
	private ListIterator enumerator = null;
	public Stack() {spList = new LinkedList(); sp = spList.listIterator();}
	public void push(Object o) { sp.add(o); }
	public boolean hasTop(){ return sp.hasPrevious(); }
        public Object top() { Object top = sp.previous(); sp.next(); return top; }
	public Object pop() 
	{ Object top = sp.previous(); sp.remove(); return top; }
	public Object enumerate() {
	    if (enumerator == null) 
		enumerator = spList.listIterator(sp.previousIndex()+1);
	    if (!enumerator.hasPrevious()){ enumerator = null; return null; }
	    return enumerator.previous();
	}
	public void flushEnumerator() { enumerator = null; }
    }

    private class AstFix extends AnalysisAdapter
    { 
	private Stack hstack = new Stack();
	private Stack pstack = new Stack();
	private Stack listack = new Stack();
	private Stack optionstack = new Stack();
	private Stack tagstack = new Stack();
	private Stack deletedtokenstack = new Stack();

	private ANormalBlock mkANormalBlock(String tag, String Tb, LinkedList resultList) {
	    return new ANormalBlock(new AOpentag(new TOpen(),new TTag(tag),null,new TTb(Tb),
						 new TClose()),
				    resultList,
				    new AClosetag(new TOpen(),new TSlash(),new TTag(tag),null,null,
					          new TClose()));
	}

	private ANormalBlock mkANormalBlock(String tag, LinkedList resultList) {
	    return new ANormalBlock(new AOpentag(new TOpen(),new TTag(tag),null, null,
						 new TClose()),
				    resultList,
				    new AClosetag(new TOpen(),new TSlash(),new TTag(tag),null,null,
					          new TClose()));
	}

	public void caseAUlBlock(AUlBlock nde) {
	    node = mkANormalBlock("ul",nde.getBlock());
	}

	public void caseAOlBlock(AOlBlock nde) {
	    node = mkANormalBlock("ol",nde.getBlock());
	}

	private boolean later(Token t1, Token t2) {
	    if (t1.getLine() > t2.getLine()) return true;
	    if ((t1.getLine() == t2.getLine()) && (t1.getPos() > t2.getPos())) return true;
	    return false;
	}

	public Token topTag() { 
	    Token tag1 = null; Token tag2 = null;
	    if (listack.hasTop()) {
		if (listack.top() instanceof ALiBlock)
		    tag1 = ((ALiBlock)listack.top()).getLi();
		else if (listack.top() instanceof AOpenol) tag1 = ((AOpenol)listack.top()).getOl();
		else tag1 = ((AOpenul)listack.top()).getUl();
	    }
	    if (tagstack.hasTop()) tag2 = ((AOpentag)tagstack.top()).getTag();
	    if (tag1 == null) return tag2;
	    if (tag2 == null) return tag1;
	    if (later(tag1,tag2)) return tag1;
	    return tag2;
	}

	public void popTopTag(Token t) {
	    if (t instanceof TTag) tagstack.pop();
	    else listack.pop();
	}

	public void caseAOpentag(AOpentag node) { tagstack.push(node); }

	public void caseAClosetag(AClosetag nde) { 
	    String closeTagText = nde.getTag().getText();
	    if ((deletedtokenstack.hasTop()) &&
		(closeTagText.equalsIgnoreCase(((AOpentag)deletedtokenstack.top()).getTag().getText())))
		{
		    deletedtokenstack.pop();
		    State topState = (State)stack.previous();
		    state = topState.state; node = (Node)topState.node;
		} else {
		    Token openTag = fix.topTag();
		    //    System.out.println(nde + " at [" + nde.getTag().getLine() + "," +
		    //	       nde.getTag().getLine() + "]");
		    //System.out.println("Top tag: " + openTag + " at [" + openTag.getLine() + ","
		    //	       + openTag.getPos() + "]");
		    if (openTag != null) {
			String openTagText = openTag.getText();
			if (!(closeTagText.equalsIgnoreCase(openTagText))) {
			    AOpentag nd = (AOpentag) tagstack.enumerate();
			    boolean matchingTagFound = false;
			    while (nd != null) {
				if (nd.getTag().getText().equalsIgnoreCase(closeTagText)) {
				    tagstack.flushEnumerator();
				    // System.out.println("Found matching open " + nd + " at [" + 
				    // nd.getTag().getLine() + "," + nd.getTag().getPos() +
				    //       "]");
				    matchingTagFound = true; break;
				}
				nd = (AOpentag)tagstack.enumerate();
			    }		  
			    if (matchingTagFound) {
				//System.out.println("Put a " + openTagText + " into the input stream at [" +
				//  nde.getTag().getLine() + "," + nde.getTag().getPos() + "]");
				if (openTag instanceof TLi) {
				    closeLiBlock((ALiBlock)listack.pop());
				    tagstack.pop();
				}
				else { 
				    nde.getTag().setText(openTagText); 
				    if ((openTag instanceof TUl) || (openTag instanceof TOl)) listack.pop();
				    else tagstack.pop(); 
				    insertedTokens = new TypedLinkedList(NodeCast.instance);
				    insertedTokens.add(new TOpen());
				    insertedTokens.add(new TSlash());
				    insertedTokens.add(new TTag(closeTagText,
								nde.getTag().getLine(),
								nde.getTag().getPos()));
				    insertedTokens.add(new TClose());
				}
			    }
			    else {  
				State topState = (State)stack.previous();
				state = topState.state; node = (Node)topState.node;
			    }
			}
			else { tagstack.pop(); }
		    }
		}
	}
	
	private void closeLiBlock(ALiBlock node) { 
	    //System.out.println("LI node is " + node + "at position [" + node.getLi().getLine()
	    //	       + "," + node.getLi().getPos() + "]"); 
	    LinkedList resultList = new TypedLinkedList();
	    State topState = (State)stack.previous();
	    XPBlock cNode = (XPBlock)topState.node;
	    while((cNode instanceof X1PBlock) && 
		  ((X1PBlock)cNode).getPBlock() != node) {
		resultList.addFirst(((X1PBlock)cNode).getPBlock());
		cNode = ((X1PBlock)cNode).getXPBlock();
	    }
	    ANormalBlock newnode = mkANormalBlock("li",resultList);
	    if (cNode instanceof X1PBlock) 
		topState.node = new X1PBlock(((X1PBlock)cNode).getXPBlock(),newnode);
	    else 
		topState.node = new X2PBlock(newnode);
	    stack.next();
	}
	    
	public void caseALiBlock(ALiBlock node) {
	    if (listack.hasTop()) {
		if (listack.top() instanceof ALiBlock)
		    closeLiBlock((ALiBlock)listack.pop());
	    }
	    // else listack.push(new AOpenul(new TOpen(),
	    //			  new TUl("ul",node.getLi().getLine(),
	    //				  node.getLi().getPos()),null, new TClose()));
	    listack.push(node);
	}

	public void caseACloseliBlock (ACloseliBlock nde) {
	    if (listack.hasTop()) {
		ALiBlock openBlock = (ALiBlock)listack.pop();
		LinkedList resultList = new TypedLinkedList();
		State topState = (State)stack.previous();
		XPBlock cNode = (XPBlock)topState.node;
		while((cNode instanceof X1PBlock) && 
		      ((X1PBlock)cNode).getPBlock() != openBlock) {
		    resultList.addFirst(((X1PBlock)cNode).getPBlock());
		    cNode = ((X1PBlock)cNode).getXPBlock();
		}
		node = mkANormalBlock("li",resultList);
		if (cNode instanceof X1PBlock) {
		    topState.node = ((X1PBlock)cNode).getXPBlock();
		    stack.next();
		}
		else { node = new X2PBlock((PBlock)node); state = topState.state; }
	    }
	}

	public void caseACloseul(ACloseul node) { 
	    if (listack.hasTop() && (listack.top() instanceof ALiBlock))
		closeLiBlock((ALiBlock)listack.pop());
	    listack.pop();
	}

	public void caseACloseol(ACloseol node) { 
	    if (listack.hasTop() && (listack.top() instanceof ALiBlock))
		closeLiBlock((ALiBlock)listack.pop());
	    listack.pop();
	}

	public void caseAOpenul(AOpenul node) { listack.push(node); }
	
	public void caseAOpenol(AOpenol node) { listack.push(node); }
	
	public void caseAOpenheaderBlock(AOpenheaderBlock node) { hstack.push(node); }

	public void caseAOpenpBlock(AOpenpBlock node) { pstack.push(node); }

	public void caseAOpenoptBlock(AOpenoptBlock node) { optionstack.push(node); }

	public void caseACloseheaderBlock(ACloseheaderBlock nde) {
	    if (hstack.hasTop()) {
		AOpenheaderBlock openBlock = (AOpenheaderBlock)hstack.pop();
		LinkedList resultList = new TypedLinkedList();
		State topState = (State)stack.previous();
		Node cNode1 = (Node)topState.node;
		while (cNode1 instanceof AOpentag) {
		    topState = (State) stack.previous();
		    deletedtokenstack.push(tagstack.pop());
		    cNode1 = (Node)topState.node; 
		    state = 48;
		}
		XPBlock cNode = (XPBlock)cNode1;
		while((cNode instanceof X1PBlock) && 
		      ((X1PBlock)cNode).getPBlock() != openBlock) {
		    resultList.addFirst(((X1PBlock)cNode).getPBlock());
		    cNode = ((X1PBlock)cNode).getXPBlock();
		}
		node = new ANormalBlock(
			       new AOpentag(new TOpen(),new TTag("h"),
					    new TNumber(openBlock.getNumber().toString()),
					    null, new TClose()),
			       resultList,
			       new AClosetag(new TOpen(),new TSlash(),new TTag("h"),
					     new TNumber(nde.getNumber().toString()),null,
					     new TClose()));
		if (cNode instanceof X1PBlock) {
		    topState.node = ((X1PBlock)cNode).getXPBlock();
		    stack.next();
		}
		else { node = new X2PBlock((PBlock)node); state = topState.state; }
		if (deletedtokenstack.hasTop()) {
		    insertedTokens = new TypedLinkedList(NodeCast.instance);		    
		    while (deletedtokenstack.hasTop()) {
			AOpentag tag = (AOpentag)deletedtokenstack.pop();
			insertedTokens.add(tag.getOpen());
			insertedTokens.add(tag.getTag());
			insertedTokens.add(tag.getClose());
		    }
		}
	    }
	}

	public void caseAClosepBlock(AClosepBlock nde) {
	    if (pstack.hasTop()) {
		AOpenpBlock openBlock = (AOpenpBlock)pstack.pop();
		LinkedList resultList = new TypedLinkedList();
		State topState = (State)stack.previous();
		Node cNode1 = (Node)topState.node;
		State savedTopState = topState;
		while (cNode1 instanceof AOpentag) {
		    topState = (State) stack.previous();
		    deletedtokenstack.push(tagstack.pop());
		    cNode1 = (Node)topState.node; 
		    state = 48;
		} 
		XPBlock cNode = (XPBlock)cNode1;
		while((cNode instanceof X1PBlock) && 
		      ((X1PBlock)cNode).getPBlock() != openBlock) {
		    resultList.addFirst(((X1PBlock)cNode).getPBlock());
		    cNode = ((X1PBlock)cNode).getXPBlock();
		}
		node = mkANormalBlock("p",resultList);
		if (cNode instanceof X1PBlock) {
		    topState.node = ((X1PBlock)cNode).getXPBlock();
		    stack.next();
		}
		else { node = new X2PBlock((PBlock)node); state = topState.state; }
		if (deletedtokenstack.hasTop()) {
		    insertedTokens = new TypedLinkedList(NodeCast.instance);		    
		    while (deletedtokenstack.hasTop()) {
			AOpentag tag = (AOpentag)deletedtokenstack.pop();
			insertedTokens.add(tag.getOpen());
			insertedTokens.add(tag.getTag());
			insertedTokens.add(tag.getClose());
		    }
		}
	    }
	    //  System.out.println("Exit closePblock, state = " + state + ", node is " + node +
	    //	       " of class " + node.getClass());
	}

	public void caseACloseoptBlock(ACloseoptBlock nde) {
	    if (optionstack.hasTop()) {
		AOpenoptBlock openBlock = (AOpenoptBlock)optionstack.pop();
		LinkedList resultList = new TypedLinkedList();
		State topState = (State)stack.previous();
		XPBlock cNode = (XPBlock)topState.node;
		while((cNode instanceof X1PBlock) && 
		      ((X1PBlock)cNode).getPBlock() != openBlock) {
		    resultList.addFirst(((X1PBlock)cNode).getPBlock());
		    cNode = ((X1PBlock)cNode).getXPBlock();
		}
		if ((openBlock.getTb() != null) && (openBlock.getTb().getText() != null))
		    node = mkANormalBlock("option",openBlock.getTb().getText(),resultList);
		else node = mkANormalBlock("option",resultList);
		if (cNode instanceof X1PBlock) {
		    topState.node = ((X1PBlock)cNode).getXPBlock();
		    stack.next();
		}
		else { node = new X2PBlock((PBlock)node); state = topState.state; }
	    }
	}

    }

    AstFix fix = new AstFix();

    protected void filter() throws IOException { node.apply(fix); }

}

