/* This file was generated by SableCC (http://www.sable.mcgill.ca/sablecc/). */

package html.parser;

import html.lexer.*;
import html.node.*;
import html.analysis.*;
import java.util.*;

import java.io.DataInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;

public class Parser
{
    public final Analysis ignoredTokens = new AnalysisAdapter();

    protected Node node;
    protected int state;

    protected final Lexer lexer;
    protected final LinkedList stackEls = new LinkedList();
    protected final ListIterator stack = stackEls.listIterator();
    protected int last_shift;
    protected int last_pos;
    protected int last_line;
    private final TokenIndex converter = new TokenIndex();
    protected final int[] action = new int[2];

    private final static int SHIFT = 0;
    private final static int REDUCE = 1;
    private final static int ACCEPT = 2;
    private final static int ERROR = 3;

    public void printStack() {
	int count = 0;
	while (stack.hasPrevious()) {
	    State state = (State) stack.previous();
	    Node node = ((Node)state.node);
	    count++;
	    if (node != null)
		System.out.println(state.state + " " + node.getClass().getName() + node);
	}
	while (count > 0) {
	    count--; stack.next();
	}
    }

    protected ListIterator initScanStack() {
	return stackEls.listIterator(stack.previousIndex());
    }

    protected void filter() throws ParserException, LexerException, IOException
    {
    }

    public Parser(Lexer lexer)
    {
        this.lexer = lexer;

        if(actionTable == null)
        {
            try
            {
                DataInputStream s = new DataInputStream(
                    new BufferedInputStream(
                    Parser.class.getResourceAsStream("parser.dat")));

                // read actionTable
                int length = s.readInt();
                actionTable = new int[length][][];
                for(int i = 0; i < actionTable.length; i++)
                {
                    length = s.readInt();
                    actionTable[i] = new int[length][3];
                    for(int j = 0; j < actionTable[i].length; j++)
                    {
                        for(int k = 0; k < 3; k++)
                        {
                            actionTable[i][j][k] = s.readInt();
                        }
                    }
                }

                // read gotoTable
                length = s.readInt();
                gotoTable = new int[length][][];
                for(int i = 0; i < gotoTable.length; i++)
                {
                    length = s.readInt();
                    gotoTable[i] = new int[length][2];
                    for(int j = 0; j < gotoTable[i].length; j++)
                    {
                        for(int k = 0; k < 2; k++)
                        {
                            gotoTable[i][j][k] = s.readInt();
                        }
                    }
                }

                // read errorMessages
                length = s.readInt();
                errorMessages = new String[length];
                for(int i = 0; i < errorMessages.length; i++)
                {
                    length = s.readInt();
                    StringBuffer buffer = new StringBuffer();

                    for(int j = 0; j < length; j++)
                    {
                        buffer.append(s.readChar());
                    }
                    errorMessages[i] = buffer.toString();
                }

                // read errors
                length = s.readInt();
                errors = new int[length];
                for(int i = 0; i < errors.length; i++)
                {
                    errors[i] = s.readInt();
                }

                s.close();
            }
            catch(Exception e)
            {
                throw new RuntimeException("Unable to read parser.dat.");
            }
        }
    }

    private int goTo(int index)
    {
        int state = state();
        int low = 1;
        int high = gotoTable[index].length - 1;
        int value = gotoTable[index][0][1];

        while(low <= high)
        {
            int middle = (low + high) / 2;

            if(state < gotoTable[index][middle][0])
            {
                high = middle - 1;
            }
            else if(state > gotoTable[index][middle][0])
            {
                low = middle + 1;
            }
            else
            {
                value = gotoTable[index][middle][1];
                break;
            }
        }

        return value;
    }

    protected void push(int state, Node node, boolean filter) throws ParserException, LexerException, IOException
    {
        this.node = node;
	this.state = state;

        if(filter)
        {
            filter();
        }

        if(!stack.hasNext())
        {
            stack.add(new State(this.state, this.node));
            return;
        }

        State s = (State) stack.next();
        s.state = this.state;
        s.node = this.node;
    }

    private int state()
    {
        State s = (State) stack.previous();
        stack.next();
        return s.state;
    }

    private Node pop()
    {
        return (Node) ((State) stack.previous()).node;
    }

    private int index(Switchable token)
    {
        converter.index = -1;
        token.apply(converter);
        return converter.index;
    }

    protected void find(Token tok) {
	int index = index(tok);
	action[0] = actionTable[state()][0][1];
	action[1] = actionTable[state()][0][2];
	
	int low = 1;
	int high = actionTable[state()].length - 1;
	
	while(low <= high)
        {
	    int middle = (low + high) / 2;
	    
	    if(index < actionTable[state()][middle][0])
            {
		high = middle - 1;
            }
	    else if(index > actionTable[state()][middle][0])
            {
		low = middle + 1;
	    }
	    else
            {
		action[0] = actionTable[state()][middle][1];
		action[1] = actionTable[state()][middle][2];
		break;
	    }
	}
    }

    protected LinkedList insertedTokens = null;

    protected void recover(int errorIndex,Token tok) throws ParserException, LexerException, IOException {
	throw new ParserException(stack,
				  "[" + last_line + "," + last_pos + "] Error type " +
				  errorIndex + " Next token: " + tok + " " +
				  errorMessages[errorIndex]);
    }

    public Start parse() throws ParserException, LexerException, IOException
    {
        push(0, null, false);

        List ign = null;
	Token tok;
	boolean insertedToken;
        while(true)
        {
            while(index(lexer.peek()) == -1)
            {
                if(ign == null)
                {
                    ign = new TypedLinkedList(NodeCast.instance);
                }

                ign.add(lexer.next());
            }

            if(ign != null)
            {
                ignoredTokens.setIn(lexer.peek(), ign);
                ign = null;
            }

            last_pos = lexer.peek().getPos();
            last_line = lexer.peek().getLine();
	    insertedToken = false;

	    if ((insertedTokens != null) && (insertedTokens.size() != 0))
		{ tok = (Token)insertedTokens.getFirst(); insertedToken = true; }
	    else tok = lexer.peek();
	    find(tok);
            switch(action[0])
            {
                case SHIFT:
		    if (insertedToken) {
			insertedTokens.removeFirst(); 
			if (insertedTokens.size() == 0) insertedTokens = null;
		    }
		    else lexer.next();
                    push(action[1], tok, true);
                    last_shift = action[1];
                    break;
                case REDUCE:
                    switch(action[1])
                    {
                    case 0: { Node node = new0(); push(goTo(0), node, true); } break;
                    case 1: { Node node = new1(); push(goTo(0), node, true); } break;
                    case 2: { Node node = new2(); push(goTo(22), node, false); } break;
                    case 3: { Node node = new3(); push(goTo(22), node, false); } break;
                    case 4: { Node node = new4(); push(goTo(0), node, true); } break;
                    case 5: { Node node = new5(); push(goTo(0), node, true); } break;
                    case 6: { Node node = new6(); push(goTo(0), node, true); } break;
                    case 7: { Node node = new7(); push(goTo(0), node, true); } break;
                    case 8: { Node node = new8(); push(goTo(0), node, true); } break;
                    case 9: { Node node = new9(); push(goTo(0), node, true); } break;
                    case 10: { Node node = new10(); push(goTo(0), node, true); } break;
                    case 11: { Node node = new11(); push(goTo(0), node, true); } break;
                    case 12: { Node node = new12(); push(goTo(0), node, true); } break;
                    case 13: { Node node = new13(); push(goTo(0), node, true); } break;
                    case 14: { Node node = new14(); push(goTo(0), node, true); } break;
                    case 15: { Node node = new15(); push(goTo(0), node, true); } break;
                    case 16: { Node node = new16(); push(goTo(0), node, true); } break;
                    case 17: { Node node = new17(); push(goTo(0), node, true); } break;
                    case 18: { Node node = new18(); push(goTo(1), node, true); } break;
                    case 19: { Node node = new19(); push(goTo(2), node, true); } break;
                    case 20: { Node node = new20(); push(goTo(2), node, true); } break;
                    case 21: { Node node = new21(); push(goTo(23), node, false); } break;
                    case 22: { Node node = new22(); push(goTo(23), node, false); } break;
                    case 23: { Node node = new23(); push(goTo(3), node, true); } break;
                    case 24: { Node node = new24(); push(goTo(3), node, true); } break;
                    case 25: { Node node = new25(); push(goTo(3), node, true); } break;
                    case 26: { Node node = new26(); push(goTo(3), node, true); } break;
                    case 27: { Node node = new27(); push(goTo(3), node, true); } break;
                    case 28: { Node node = new28(); push(goTo(3), node, true); } break;
                    case 29: { Node node = new29(); push(goTo(3), node, true); } break;
                    case 30: { Node node = new30(); push(goTo(3), node, true); } break;
                    case 31: { Node node = new31(); push(goTo(3), node, true); } break;
                    case 32: { Node node = new32(); push(goTo(3), node, true); } break;
                    case 33: { Node node = new33(); push(goTo(3), node, true); } break;
                    case 34: { Node node = new34(); push(goTo(3), node, true); } break;
                    case 35: { Node node = new35(); push(goTo(3), node, true); } break;
                    case 36: { Node node = new36(); push(goTo(3), node, true); } break;
                    case 37: { Node node = new37(); push(goTo(3), node, true); } break;
                    case 38: { Node node = new38(); push(goTo(3), node, true); } break;
                    case 39: { Node node = new39(); push(goTo(3), node, true); } break;
                    case 40: { Node node = new40(); push(goTo(3), node, true); } break;
                    case 41: { Node node = new41(); push(goTo(3), node, true); } break;
                    case 42: { Node node = new42(); push(goTo(3), node, true); } break;
                    case 43: { Node node = new43(); push(goTo(3), node, true); } break;
                    case 44: { Node node = new44(); push(goTo(3), node, true); } break;
                    case 45: { Node node = new45(); push(goTo(3), node, true); } break;
                    case 46: { Node node = new46(); push(goTo(3), node, true); } break;
                    case 47: { Node node = new47(); push(goTo(3), node, true); } break;
                    case 48: { Node node = new48(); push(goTo(3), node, true); } break;
                    case 49: { Node node = new49(); push(goTo(3), node, true); } break;
                    case 50: { Node node = new50(); push(goTo(3), node, true); } break;
                    case 51: { Node node = new51(); push(goTo(3), node, true); } break;
                    case 52: { Node node = new52(); push(goTo(3), node, true); } break;
                    case 53: { Node node = new53(); push(goTo(3), node, true); } break;
                    case 54: { Node node = new54(); push(goTo(3), node, true); } break;
                    case 55: { Node node = new55(); push(goTo(3), node, true); } break;
                    case 56: { Node node = new56(); push(goTo(3), node, true); } break;
                    case 57: { Node node = new57(); push(goTo(3), node, true); } break;
                    case 58: { Node node = new58(); push(goTo(3), node, true); } break;
                    case 59: { Node node = new59(); push(goTo(3), node, true); } break;
                    case 60: { Node node = new60(); push(goTo(3), node, true); } break;
                    case 61: { Node node = new61(); push(goTo(3), node, true); } break;
                    case 62: { Node node = new62(); push(goTo(3), node, true); } break;
                    case 63: { Node node = new63(); push(goTo(4), node, true); } break;
                    case 64: { Node node = new64(); push(goTo(4), node, true); } break;
                    case 65: { Node node = new65(); push(goTo(4), node, true); } break;
                    case 66: { Node node = new66(); push(goTo(5), node, true); } break;
                    case 67: { Node node = new67(); push(goTo(5), node, true); } break;
                    case 68: { Node node = new68(); push(goTo(5), node, true); } break;
                    case 69: { Node node = new69(); push(goTo(5), node, true); } break;
                    case 70: { Node node = new70(); push(goTo(6), node, true); } break;
                    case 71: { Node node = new71(); push(goTo(6), node, true); } break;
                    case 72: { Node node = new72(); push(goTo(6), node, true); } break;
                    case 73: { Node node = new73(); push(goTo(6), node, true); } break;
                    case 74: { Node node = new74(); push(goTo(7), node, true); } break;
                    case 75: { Node node = new75(); push(goTo(7), node, true); } break;
                    case 76: { Node node = new76(); push(goTo(8), node, true); } break;
                    case 77: { Node node = new77(); push(goTo(8), node, true); } break;
                    case 78: { Node node = new78(); push(goTo(9), node, true); } break;
                    case 79: { Node node = new79(); push(goTo(9), node, true); } break;
                    case 80: { Node node = new80(); push(goTo(10), node, true); } break;
                    case 81: { Node node = new81(); push(goTo(10), node, true); } break;
                    case 82: { Node node = new82(); push(goTo(11), node, true); } break;
                    case 83: { Node node = new83(); push(goTo(11), node, true); } break;
                    case 84: { Node node = new84(); push(goTo(12), node, true); } break;
                    case 85: { Node node = new85(); push(goTo(12), node, true); } break;
                    case 86: { Node node = new86(); push(goTo(13), node, true); } break;
                    case 87: { Node node = new87(); push(goTo(13), node, true); } break;
                    case 88: { Node node = new88(); push(goTo(14), node, true); } break;
                    case 89: { Node node = new89(); push(goTo(14), node, true); } break;
                    case 90: { Node node = new90(); push(goTo(15), node, true); } break;
                    case 91: { Node node = new91(); push(goTo(15), node, true); } break;
                    case 92: { Node node = new92(); push(goTo(16), node, true); } break;
                    case 93: { Node node = new93(); push(goTo(16), node, true); } break;
                    case 94: { Node node = new94(); push(goTo(17), node, true); } break;
                    case 95: { Node node = new95(); push(goTo(17), node, true); } break;
                    case 96: { Node node = new96(); push(goTo(18), node, true); } break;
                    case 97: { Node node = new97(); push(goTo(18), node, true); } break;
                    case 98: { Node node = new98(); push(goTo(19), node, true); } break;
                    case 99: { Node node = new99(); push(goTo(19), node, true); } break;
                    case 100: { Node node = new100(); push(goTo(20), node, true); } break;
                    case 101: { Node node = new101(); push(goTo(20), node, true); } break;
                    case 102: { Node node = new102(); push(goTo(21), node, true); } break;
                    case 103: { Node node = new103(); push(goTo(21), node, true); } break;
                    }
                    break;
                case ACCEPT:
                    {
                        EOF node2 = (EOF) lexer.next();
                        PDoc node1 = (PDoc) pop();
                        Start node = new Start(node1, node2);
                        return node;
                    }
                case ERROR:
		    recover(errors[action[1]],tok);
            }
        }
    }

    Node new0()
    {
        PComment node7 = null;
        PEhtml node6 = (PEhtml) pop();
        PBdy node5 = (PBdy) pop();
        XPBlock node4 = null;
        PHd node3 = null;
        PBhtml node2 = (PBhtml) pop();
        XPBlock node1 = null;
        ADoc node = new ADoc(node1, node2, node3, node4, node5, node6, node7);
        return node;
    }

    Node new1()
    {
        PComment node7 = null;
        PEhtml node6 = (PEhtml) pop();
        PBdy node5 = (PBdy) pop();
        XPBlock node4 = null;
        PHd node3 = null;
        PBhtml node2 = (PBhtml) pop();
        XPBlock node1 = (XPBlock) pop();
        ADoc node = new ADoc(node1, node2, node3, node4, node5, node6, node7);
        return node;
    }

    Node new2()
    {
        PBlock node2 = (PBlock) pop();
        XPBlock node1 = (XPBlock) pop();
        X1PBlock node = new X1PBlock(node1, node2);
        return node;
    }

    Node new3()
    {
        PBlock node1 = (PBlock) pop();
        X2PBlock node = new X2PBlock(node1);
        return node;
    }

    Node new4()
    {
        PComment node7 = null;
        PEhtml node6 = (PEhtml) pop();
        PBdy node5 = (PBdy) pop();
        XPBlock node4 = null;
        PHd node3 = (PHd) pop();
        PBhtml node2 = (PBhtml) pop();
        XPBlock node1 = null;
        ADoc node = new ADoc(node1, node2, node3, node4, node5, node6, node7);
        return node;
    }

    Node new5()
    {
        PComment node7 = null;
        PEhtml node6 = (PEhtml) pop();
        PBdy node5 = (PBdy) pop();
        XPBlock node4 = null;
        PHd node3 = (PHd) pop();
        PBhtml node2 = (PBhtml) pop();
        XPBlock node1 = (XPBlock) pop();
        ADoc node = new ADoc(node1, node2, node3, node4, node5, node6, node7);
        return node;
    }

    Node new6()
    {
        PComment node7 = null;
        PEhtml node6 = (PEhtml) pop();
        PBdy node5 = (PBdy) pop();
        XPBlock node4 = (XPBlock) pop();
        PHd node3 = null;
        PBhtml node2 = (PBhtml) pop();
        XPBlock node1 = null;
        ADoc node = new ADoc(node1, node2, node3, node4, node5, node6, node7);
        return node;
    }

    Node new7()
    {
        PComment node7 = null;
        PEhtml node6 = (PEhtml) pop();
        PBdy node5 = (PBdy) pop();
        XPBlock node4 = (XPBlock) pop();
        PHd node3 = null;
        PBhtml node2 = (PBhtml) pop();
        XPBlock node1 = (XPBlock) pop();
        ADoc node = new ADoc(node1, node2, node3, node4, node5, node6, node7);
        return node;
    }

    Node new8()
    {
        PComment node7 = null;
        PEhtml node6 = (PEhtml) pop();
        PBdy node5 = (PBdy) pop();
        XPBlock node4 = (XPBlock) pop();
        PHd node3 = (PHd) pop();
        PBhtml node2 = (PBhtml) pop();
        XPBlock node1 = null;
        ADoc node = new ADoc(node1, node2, node3, node4, node5, node6, node7);
        return node;
    }

    Node new9()
    {
        PComment node7 = null;
        PEhtml node6 = (PEhtml) pop();
        PBdy node5 = (PBdy) pop();
        XPBlock node4 = (XPBlock) pop();
        PHd node3 = (PHd) pop();
        PBhtml node2 = (PBhtml) pop();
        XPBlock node1 = (XPBlock) pop();
        ADoc node = new ADoc(node1, node2, node3, node4, node5, node6, node7);
        return node;
    }

    Node new10()
    {
        PComment node7 = (PComment) pop();
        PEhtml node6 = (PEhtml) pop();
        PBdy node5 = (PBdy) pop();
        XPBlock node4 = null;
        PHd node3 = null;
        PBhtml node2 = (PBhtml) pop();
        XPBlock node1 = null;
        ADoc node = new ADoc(node1, node2, node3, node4, node5, node6, node7);
        return node;
    }

    Node new11()
    {
        PComment node7 = (PComment) pop();
        PEhtml node6 = (PEhtml) pop();
        PBdy node5 = (PBdy) pop();
        XPBlock node4 = null;
        PHd node3 = null;
        PBhtml node2 = (PBhtml) pop();
        XPBlock node1 = (XPBlock) pop();
        ADoc node = new ADoc(node1, node2, node3, node4, node5, node6, node7);
        return node;
    }

    Node new12()
    {
        PComment node7 = (PComment) pop();
        PEhtml node6 = (PEhtml) pop();
        PBdy node5 = (PBdy) pop();
        XPBlock node4 = null;
        PHd node3 = (PHd) pop();
        PBhtml node2 = (PBhtml) pop();
        XPBlock node1 = null;
        ADoc node = new ADoc(node1, node2, node3, node4, node5, node6, node7);
        return node;
    }

    Node new13()
    {
        PComment node7 = (PComment) pop();
        PEhtml node6 = (PEhtml) pop();
        PBdy node5 = (PBdy) pop();
        XPBlock node4 = null;
        PHd node3 = (PHd) pop();
        PBhtml node2 = (PBhtml) pop();
        XPBlock node1 = (XPBlock) pop();
        ADoc node = new ADoc(node1, node2, node3, node4, node5, node6, node7);
        return node;
    }

    Node new14()
    {
        PComment node7 = (PComment) pop();
        PEhtml node6 = (PEhtml) pop();
        PBdy node5 = (PBdy) pop();
        XPBlock node4 = (XPBlock) pop();
        PHd node3 = null;
        PBhtml node2 = (PBhtml) pop();
        XPBlock node1 = null;
        ADoc node = new ADoc(node1, node2, node3, node4, node5, node6, node7);
        return node;
    }

    Node new15()
    {
        PComment node7 = (PComment) pop();
        PEhtml node6 = (PEhtml) pop();
        PBdy node5 = (PBdy) pop();
        XPBlock node4 = (XPBlock) pop();
        PHd node3 = null;
        PBhtml node2 = (PBhtml) pop();
        XPBlock node1 = (XPBlock) pop();
        ADoc node = new ADoc(node1, node2, node3, node4, node5, node6, node7);
        return node;
    }

    Node new16()
    {
        PComment node7 = (PComment) pop();
        PEhtml node6 = (PEhtml) pop();
        PBdy node5 = (PBdy) pop();
        XPBlock node4 = (XPBlock) pop();
        PHd node3 = (PHd) pop();
        PBhtml node2 = (PBhtml) pop();
        XPBlock node1 = null;
        ADoc node = new ADoc(node1, node2, node3, node4, node5, node6, node7);
        return node;
    }

    Node new17()
    {
        PComment node7 = (PComment) pop();
        PEhtml node6 = (PEhtml) pop();
        PBdy node5 = (PBdy) pop();
        XPBlock node4 = (XPBlock) pop();
        PHd node3 = (PHd) pop();
        PBhtml node2 = (PBhtml) pop();
        XPBlock node1 = (XPBlock) pop();
        ADoc node = new ADoc(node1, node2, node3, node4, node5, node6, node7);
        return node;
    }

    Node new18()
    {
        PEhead node3 = (PEhead) pop();
        XPBlock node2 = (XPBlock) pop();
        PBhead node1 = (PBhead) pop();
        AHd node = new AHd(node1, node2, node3);
        return node;
    }

    Node new19()
    {
        PEbody node3 = (PEbody) pop();
        XPBlock node2 = (XPBlock) pop();
        PBbody node1 = (PBbody) pop();
        ANormalBdy node = new ANormalBdy(node1, node2, node3);
        return node;
    }

    Node new20()
    {
        PEfset node3 = (PEfset) pop();
        XPFsblock node2 = (XPFsblock) pop();
        PBfset node1 = (PBfset) pop();
        AFramesetBdy node = new AFramesetBdy(node1, node2, node3);
        return node;
    }

    Node new21()
    {
        PFsblock node2 = (PFsblock) pop();
        XPFsblock node1 = (XPFsblock) pop();
        X1PFsblock node = new X1PFsblock(node1, node2);
        return node;
    }

    Node new22()
    {
        PFsblock node1 = (PFsblock) pop();
        X2PFsblock node = new X2PFsblock(node1);
        return node;
    }

    Node new23()
    {
        PClosetag node3 = (PClosetag) pop();
        XPBlock node2 = null;
        POpentag node1 = (POpentag) pop();
        ANormalBlock node = new ANormalBlock(node1, node2, node3);
        return node;
    }

    Node new24()
    {
        PClosetag node3 = (PClosetag) pop();
        XPBlock node2 = (XPBlock) pop();
        POpentag node1 = (POpentag) pop();
        ANormalBlock node = new ANormalBlock(node1, node2, node3);
        return node;
    }

    Node new25()
    {
        PCloseul node3 = (PCloseul) pop();
        XPBlock node2 = null;
        POpenul node1 = (POpenul) pop();
        AUlBlock node = new AUlBlock(node1, node2, node3);
        return node;
    }

    Node new26()
    {
        PCloseul node3 = (PCloseul) pop();
        XPBlock node2 = (XPBlock) pop();
        POpenul node1 = (POpenul) pop();
        AUlBlock node = new AUlBlock(node1, node2, node3);
        return node;
    }

    Node new27()
    {
        TWord node1 = (TWord) pop();
        AMixedBlock node = new AMixedBlock(node1);
        return node;
    }

    Node new28()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = null;
        TImg node2 = (TImg) pop();
        TOpen node1 = (TOpen) pop();
        AImgBlock node = new AImgBlock(node1, node2, node3, node4);
        return node;
    }

    Node new29()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = (TTb) pop();
        TImg node2 = (TImg) pop();
        TOpen node1 = (TOpen) pop();
        AImgBlock node = new AImgBlock(node1, node2, node3, node4);
        return node;
    }

    Node new30()
    {
        TCs node3 = null;
        TCom node2 = (TCom) pop();
        TOpen node1 = (TOpen) pop();
        ACommentBlock node = new ACommentBlock(node1, node2, node3);
        return node;
    }

    Node new31()
    {
        TCs node3 = (TCs) pop();
        TCom node2 = (TCom) pop();
        TOpen node1 = (TOpen) pop();
        ACommentBlock node = new ACommentBlock(node1, node2, node3);
        return node;
    }

    Node new32()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = null;
        THr node2 = (THr) pop();
        TOpen node1 = (TOpen) pop();
        AHrBlock node = new AHrBlock(node1, node2, node3, node4);
        return node;
    }

    Node new33()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = (TTb) pop();
        THr node2 = (THr) pop();
        TOpen node1 = (TOpen) pop();
        AHrBlock node = new AHrBlock(node1, node2, node3, node4);
        return node;
    }

    Node new34()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = null;
        TFrame node2 = (TFrame) pop();
        TOpen node1 = (TOpen) pop();
        AFrameBlock node = new AFrameBlock(node1, node2, node3, node4);
        return node;
    }

    Node new35()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = (TTb) pop();
        TFrame node2 = (TFrame) pop();
        TOpen node1 = (TOpen) pop();
        AFrameBlock node = new AFrameBlock(node1, node2, node3, node4);
        return node;
    }

    Node new36()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = null;
        TArea node2 = (TArea) pop();
        TOpen node1 = (TOpen) pop();
        AAreaBlock node = new AAreaBlock(node1, node2, node3, node4);
        return node;
    }

    Node new37()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = (TTb) pop();
        TArea node2 = (TArea) pop();
        TOpen node1 = (TOpen) pop();
        AAreaBlock node = new AAreaBlock(node1, node2, node3, node4);
        return node;
    }

    Node new38()
    {
        TClose node5 = (TClose) pop();
        TTb node4 = null;
        TNumber node3 = (TNumber) pop();
        TH node2 = (TH) pop();
        TOpen node1 = (TOpen) pop();
        AOpenheaderBlock node = new AOpenheaderBlock(node1, node2, node3, node4, node5);
        return node;
    }

    Node new39()
    {
        TClose node5 = (TClose) pop();
        TTb node4 = (TTb) pop();
        TNumber node3 = (TNumber) pop();
        TH node2 = (TH) pop();
        TOpen node1 = (TOpen) pop();
        AOpenheaderBlock node = new AOpenheaderBlock(node1, node2, node3, node4, node5);
        return node;
    }

    Node new40()
    {
        TClose node5 = (TClose) pop();
        TNumber node4 = (TNumber) pop();
        TH node3 = (TH) pop();
        TSlash node2 = (TSlash) pop();
        TOpen node1 = (TOpen) pop();
        ACloseheaderBlock node = new ACloseheaderBlock(node1, node2, node3, node4, node5);
        return node;
    }

    Node new41()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = null;
        TP node2 = (TP) pop();
        TOpen node1 = (TOpen) pop();
        AOpenpBlock node = new AOpenpBlock(node1, node2, node3, node4);
        return node;
    }

    Node new42()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = (TTb) pop();
        TP node2 = (TP) pop();
        TOpen node1 = (TOpen) pop();
        AOpenpBlock node = new AOpenpBlock(node1, node2, node3, node4);
        return node;
    }

    Node new43()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = null;
        TBase node2 = (TBase) pop();
        TOpen node1 = (TOpen) pop();
        ABaseBlock node = new ABaseBlock(node1, node2, node3, node4);
        return node;
    }

    Node new44()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = (TTb) pop();
        TBase node2 = (TBase) pop();
        TOpen node1 = (TOpen) pop();
        ABaseBlock node = new ABaseBlock(node1, node2, node3, node4);
        return node;
    }

    Node new45()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = null;
        TDt node2 = (TDt) pop();
        TOpen node1 = (TOpen) pop();
        ADoctypeBlock node = new ADoctypeBlock(node1, node2, node3, node4);
        return node;
    }

    Node new46()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = (TTb) pop();
        TDt node2 = (TDt) pop();
        TOpen node1 = (TOpen) pop();
        ADoctypeBlock node = new ADoctypeBlock(node1, node2, node3, node4);
        return node;
    }

    Node new47()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = null;
        TMeta node2 = (TMeta) pop();
        TOpen node1 = (TOpen) pop();
        AOpenmetaBlock node = new AOpenmetaBlock(node1, node2, node3, node4);
        return node;
    }

    Node new48()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = (TTb) pop();
        TMeta node2 = (TMeta) pop();
        TOpen node1 = (TOpen) pop();
        AOpenmetaBlock node = new AOpenmetaBlock(node1, node2, node3, node4);
        return node;
    }

    Node new49()
    {
        TClose node4 = (TClose) pop();
        TP node3 = (TP) pop();
        TSlash node2 = (TSlash) pop();
        TOpen node1 = (TOpen) pop();
        AClosepBlock node = new AClosepBlock(node1, node2, node3, node4);
        return node;
    }

    Node new50()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = null;
        TLi node2 = (TLi) pop();
        TOpen node1 = (TOpen) pop();
        ALiBlock node = new ALiBlock(node1, node2, node3, node4);
        return node;
    }

    Node new51()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = (TTb) pop();
        TLi node2 = (TLi) pop();
        TOpen node1 = (TOpen) pop();
        ALiBlock node = new ALiBlock(node1, node2, node3, node4);
        return node;
    }

    Node new52()
    {
        TClose node4 = (TClose) pop();
        TLi node3 = (TLi) pop();
        TSlash node2 = (TSlash) pop();
        TOpen node1 = (TOpen) pop();
        ACloseliBlock node = new ACloseliBlock(node1, node2, node3, node4);
        return node;
    }

    Node new53()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = null;
        TOption node2 = (TOption) pop();
        TOpen node1 = (TOpen) pop();
        AOpenoptBlock node = new AOpenoptBlock(node1, node2, node3, node4);
        return node;
    }

    Node new54()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = (TTb) pop();
        TOption node2 = (TOption) pop();
        TOpen node1 = (TOpen) pop();
        AOpenoptBlock node = new AOpenoptBlock(node1, node2, node3, node4);
        return node;
    }

    Node new55()
    {
        TClose node4 = (TClose) pop();
        TOption node3 = (TOption) pop();
        TSlash node2 = (TSlash) pop();
        TOpen node1 = (TOpen) pop();
        ACloseoptBlock node = new ACloseoptBlock(node1, node2, node3, node4);
        return node;
    }

    Node new56()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = null;
        TInput node2 = (TInput) pop();
        TOpen node1 = (TOpen) pop();
        AInputBlock node = new AInputBlock(node1, node2, node3, node4);
        return node;
    }

    Node new57()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = (TTb) pop();
        TInput node2 = (TInput) pop();
        TOpen node1 = (TOpen) pop();
        AInputBlock node = new AInputBlock(node1, node2, node3, node4);
        return node;
    }

    Node new58()
    {
        PScr node1 = (PScr) pop();
        AScriptBlock node = new AScriptBlock(node1);
        return node;
    }

    Node new59()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = null;
        TBr node2 = (TBr) pop();
        TOpen node1 = (TOpen) pop();
        ABreakBlock node = new ABreakBlock(node1, node2, node3, node4);
        return node;
    }

    Node new60()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = (TTb) pop();
        TBr node2 = (TBr) pop();
        TOpen node1 = (TOpen) pop();
        ABreakBlock node = new ABreakBlock(node1, node2, node3, node4);
        return node;
    }

    Node new61()
    {
        PCloseol node3 = (PCloseol) pop();
        XPBlock node2 = null;
        POpenol node1 = (POpenol) pop();
        AOlBlock node = new AOlBlock(node1, node2, node3);
        return node;
    }

    Node new62()
    {
        PCloseol node3 = (PCloseol) pop();
        XPBlock node2 = (XPBlock) pop();
        POpenol node1 = (POpenol) pop();
        AOlBlock node = new AOlBlock(node1, node2, node3);
        return node;
    }

    Node new63()
    {
        PEfset node3 = (PEfset) pop();
        XPFsblock node2 = (XPFsblock) pop();
        PBfset node1 = (PBfset) pop();
        AFsFsblock node = new AFsFsblock(node1, node2, node3);
        return node;
    }

    Node new64()
    {
        PBlock node1 = (PBlock) pop();
        ANormalFsblock node = new ANormalFsblock(node1);
        return node;
    }

    Node new65()
    {
        PEbody node3 = (PEbody) pop();
        XPBlock node2 = (XPBlock) pop();
        PBbody node1 = (PBbody) pop();
        ABodyFsblock node = new ABodyFsblock(node1, node2, node3);
        return node;
    }

    Node new66()
    {
        TClose node5 = (TClose) pop();
        TTb node4 = null;
        TNumber node3 = null;
        TTag node2 = (TTag) pop();
        TOpen node1 = (TOpen) pop();
        AOpentag node = new AOpentag(node1, node2, node3, node4, node5);
        return node;
    }

    Node new67()
    {
        TClose node5 = (TClose) pop();
        TTb node4 = null;
        TNumber node3 = (TNumber) pop();
        TTag node2 = (TTag) pop();
        TOpen node1 = (TOpen) pop();
        AOpentag node = new AOpentag(node1, node2, node3, node4, node5);
        return node;
    }

    Node new68()
    {
        TClose node5 = (TClose) pop();
        TTb node4 = (TTb) pop();
        TNumber node3 = null;
        TTag node2 = (TTag) pop();
        TOpen node1 = (TOpen) pop();
        AOpentag node = new AOpentag(node1, node2, node3, node4, node5);
        return node;
    }

    Node new69()
    {
        TClose node5 = (TClose) pop();
        TTb node4 = (TTb) pop();
        TNumber node3 = (TNumber) pop();
        TTag node2 = (TTag) pop();
        TOpen node1 = (TOpen) pop();
        AOpentag node = new AOpentag(node1, node2, node3, node4, node5);
        return node;
    }

    Node new70()
    {
        TClose node6 = (TClose) pop();
        TTb node5 = null;
        TNumber node4 = null;
        TTag node3 = (TTag) pop();
        TSlash node2 = (TSlash) pop();
        TOpen node1 = (TOpen) pop();
        AClosetag node = new AClosetag(node1, node2, node3, node4, node5, node6);
        return node;
    }

    Node new71()
    {
        TClose node6 = (TClose) pop();
        TTb node5 = null;
        TNumber node4 = (TNumber) pop();
        TTag node3 = (TTag) pop();
        TSlash node2 = (TSlash) pop();
        TOpen node1 = (TOpen) pop();
        AClosetag node = new AClosetag(node1, node2, node3, node4, node5, node6);
        return node;
    }

    Node new72()
    {
        TClose node6 = (TClose) pop();
        TTb node5 = (TTb) pop();
        TNumber node4 = null;
        TTag node3 = (TTag) pop();
        TSlash node2 = (TSlash) pop();
        TOpen node1 = (TOpen) pop();
        AClosetag node = new AClosetag(node1, node2, node3, node4, node5, node6);
        return node;
    }

    Node new73()
    {
        TClose node6 = (TClose) pop();
        TTb node5 = (TTb) pop();
        TNumber node4 = (TNumber) pop();
        TTag node3 = (TTag) pop();
        TSlash node2 = (TSlash) pop();
        TOpen node1 = (TOpen) pop();
        AClosetag node = new AClosetag(node1, node2, node3, node4, node5, node6);
        return node;
    }

    Node new74()
    {
        TCs node3 = null;
        TCom node2 = (TCom) pop();
        TOpen node1 = (TOpen) pop();
        AComment node = new AComment(node1, node2, node3);
        return node;
    }

    Node new75()
    {
        TCs node3 = (TCs) pop();
        TCom node2 = (TCom) pop();
        TOpen node1 = (TOpen) pop();
        AComment node = new AComment(node1, node2, node3);
        return node;
    }

    Node new76()
    {
        TClose node4 = (TClose) pop();
        TTb2 node3 = null;
        TScript node2 = (TScript) pop();
        TOpen node1 = (TOpen) pop();
        ABscript node = new ABscript(node1, node2, node3, node4);
        return node;
    }

    Node new77()
    {
        TClose node4 = (TClose) pop();
        TTb2 node3 = (TTb2) pop();
        TScript node2 = (TScript) pop();
        TOpen node1 = (TOpen) pop();
        ABscript node = new ABscript(node1, node2, node3, node4);
        return node;
    }

    Node new78()
    {
        TEscript node3 = (TEscript) pop();
        TSctext node2 = null;
        PBscript node1 = (PBscript) pop();
        AScr node = new AScr(node1, node2, node3);
        return node;
    }

    Node new79()
    {
        TEscript node3 = (TEscript) pop();
        TSctext node2 = (TSctext) pop();
        PBscript node1 = (PBscript) pop();
        AScr node = new AScr(node1, node2, node3);
        return node;
    }

    Node new80()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = null;
        TUl node2 = (TUl) pop();
        TOpen node1 = (TOpen) pop();
        AOpenul node = new AOpenul(node1, node2, node3, node4);
        return node;
    }

    Node new81()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = (TTb) pop();
        TUl node2 = (TUl) pop();
        TOpen node1 = (TOpen) pop();
        AOpenul node = new AOpenul(node1, node2, node3, node4);
        return node;
    }

    Node new82()
    {
        TClose node5 = (TClose) pop();
        TTb node4 = null;
        TUl node3 = (TUl) pop();
        TSlash node2 = (TSlash) pop();
        TOpen node1 = (TOpen) pop();
        ACloseul node = new ACloseul(node1, node2, node3, node4, node5);
        return node;
    }

    Node new83()
    {
        TClose node5 = (TClose) pop();
        TTb node4 = (TTb) pop();
        TUl node3 = (TUl) pop();
        TSlash node2 = (TSlash) pop();
        TOpen node1 = (TOpen) pop();
        ACloseul node = new ACloseul(node1, node2, node3, node4, node5);
        return node;
    }

    Node new84()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = null;
        TOl node2 = (TOl) pop();
        TOpen node1 = (TOpen) pop();
        AOpenol node = new AOpenol(node1, node2, node3, node4);
        return node;
    }

    Node new85()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = (TTb) pop();
        TOl node2 = (TOl) pop();
        TOpen node1 = (TOpen) pop();
        AOpenol node = new AOpenol(node1, node2, node3, node4);
        return node;
    }

    Node new86()
    {
        TClose node5 = (TClose) pop();
        TTb node4 = null;
        TOl node3 = (TOl) pop();
        TSlash node2 = (TSlash) pop();
        TOpen node1 = (TOpen) pop();
        ACloseol node = new ACloseol(node1, node2, node3, node4, node5);
        return node;
    }

    Node new87()
    {
        TClose node5 = (TClose) pop();
        TTb node4 = (TTb) pop();
        TOl node3 = (TOl) pop();
        TSlash node2 = (TSlash) pop();
        TOpen node1 = (TOpen) pop();
        ACloseol node = new ACloseol(node1, node2, node3, node4, node5);
        return node;
    }

    Node new88()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = null;
        THtml node2 = (THtml) pop();
        TOpen node1 = (TOpen) pop();
        ABhtml node = new ABhtml(node1, node2, node3, node4);
        return node;
    }

    Node new89()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = (TTb) pop();
        THtml node2 = (THtml) pop();
        TOpen node1 = (TOpen) pop();
        ABhtml node = new ABhtml(node1, node2, node3, node4);
        return node;
    }

    Node new90()
    {
        TClose node5 = (TClose) pop();
        TTb node4 = null;
        THtml node3 = (THtml) pop();
        TSlash node2 = (TSlash) pop();
        TOpen node1 = (TOpen) pop();
        AEhtml node = new AEhtml(node1, node2, node3, node4, node5);
        return node;
    }

    Node new91()
    {
        TClose node5 = (TClose) pop();
        TTb node4 = (TTb) pop();
        THtml node3 = (THtml) pop();
        TSlash node2 = (TSlash) pop();
        TOpen node1 = (TOpen) pop();
        AEhtml node = new AEhtml(node1, node2, node3, node4, node5);
        return node;
    }

    Node new92()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = null;
        THead node2 = (THead) pop();
        TOpen node1 = (TOpen) pop();
        ABhead node = new ABhead(node1, node2, node3, node4);
        return node;
    }

    Node new93()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = (TTb) pop();
        THead node2 = (THead) pop();
        TOpen node1 = (TOpen) pop();
        ABhead node = new ABhead(node1, node2, node3, node4);
        return node;
    }

    Node new94()
    {
        TClose node5 = (TClose) pop();
        TTb node4 = null;
        THead node3 = (THead) pop();
        TSlash node2 = (TSlash) pop();
        TOpen node1 = (TOpen) pop();
        AEhead node = new AEhead(node1, node2, node3, node4, node5);
        return node;
    }

    Node new95()
    {
        TClose node5 = (TClose) pop();
        TTb node4 = (TTb) pop();
        THead node3 = (THead) pop();
        TSlash node2 = (TSlash) pop();
        TOpen node1 = (TOpen) pop();
        AEhead node = new AEhead(node1, node2, node3, node4, node5);
        return node;
    }

    Node new96()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = null;
        TBody node2 = (TBody) pop();
        TOpen node1 = (TOpen) pop();
        ABbody node = new ABbody(node1, node2, node3, node4);
        return node;
    }

    Node new97()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = (TTb) pop();
        TBody node2 = (TBody) pop();
        TOpen node1 = (TOpen) pop();
        ABbody node = new ABbody(node1, node2, node3, node4);
        return node;
    }

    Node new98()
    {
        TClose node5 = (TClose) pop();
        TTb node4 = null;
        TBody node3 = (TBody) pop();
        TSlash node2 = (TSlash) pop();
        TOpen node1 = (TOpen) pop();
        AEbody node = new AEbody(node1, node2, node3, node4, node5);
        return node;
    }

    Node new99()
    {
        TClose node5 = (TClose) pop();
        TTb node4 = (TTb) pop();
        TBody node3 = (TBody) pop();
        TSlash node2 = (TSlash) pop();
        TOpen node1 = (TOpen) pop();
        AEbody node = new AEbody(node1, node2, node3, node4, node5);
        return node;
    }

    Node new100()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = null;
        TFrameset node2 = (TFrameset) pop();
        TOpen node1 = (TOpen) pop();
        ABfset node = new ABfset(node1, node2, node3, node4);
        return node;
    }

    Node new101()
    {
        TClose node4 = (TClose) pop();
        TTb node3 = (TTb) pop();
        TFrameset node2 = (TFrameset) pop();
        TOpen node1 = (TOpen) pop();
        ABfset node = new ABfset(node1, node2, node3, node4);
        return node;
    }

    Node new102()
    {
        TClose node5 = (TClose) pop();
        TTb node4 = null;
        TFrameset node3 = (TFrameset) pop();
        TSlash node2 = (TSlash) pop();
        TOpen node1 = (TOpen) pop();
        AEfset node = new AEfset(node1, node2, node3, node4, node5);
        return node;
    }

    Node new103()
    {
        TClose node5 = (TClose) pop();
        TTb node4 = (TTb) pop();
        TFrameset node3 = (TFrameset) pop();
        TSlash node2 = (TSlash) pop();
        TOpen node1 = (TOpen) pop();
        AEfset node = new AEfset(node1, node2, node3, node4, node5);
        return node;
    }

    private static int[][][] actionTable;
/*      {
			{{-1, ERROR, 0}, {2, SHIFT, 1}, {36, SHIFT, 2}, },
			{{-1, ERROR, 1}, {5, SHIFT, 12}, {6, SHIFT, 13}, {7, SHIFT, 14}, {10, SHIFT, 15}, {11, SHIFT, 16}, {12, SHIFT, 17}, {13, SHIFT, 18}, {14, SHIFT, 19}, {15, SHIFT, 20}, {16, SHIFT, 21}, {17, SHIFT, 22}, {18, SHIFT, 23}, {19, SHIFT, 24}, {20, SHIFT, 25}, {21, SHIFT, 26}, {22, SHIFT, 27}, {23, SHIFT, 28}, {24, SHIFT, 29}, {26, SHIFT, 30}, {32, SHIFT, 31}, },
			{{-1, REDUCE, 27}, },
			{{-1, ERROR, 3}, {38, ACCEPT, -1}, },
			{{-1, REDUCE, 3}, },
			{{-1, ERROR, 5}, {2, SHIFT, 32}, {36, SHIFT, 2}, },
			{{-1, ERROR, 6}, {3, SHIFT, 35}, {4, SHIFT, 36}, },
			{{-1, REDUCE, 58}, },
			{{-1, ERROR, 8}, {2, SHIFT, 37}, {36, SHIFT, 2}, },
			{{-1, ERROR, 9}, {2, SHIFT, 40}, {36, SHIFT, 2}, },
			{{-1, ERROR, 10}, {2, SHIFT, 43}, {36, SHIFT, 2}, },
			{{-1, ERROR, 11}, {2, SHIFT, 1}, {36, SHIFT, 2}, },
			{{-1, ERROR, 12}, {13, SHIFT, 52}, {15, SHIFT, 53}, {18, SHIFT, 54}, {23, SHIFT, 55}, },
			{{-1, ERROR, 13}, {33, SHIFT, 56}, {35, SHIFT, 57}, },
			{{-1, ERROR, 14}, {33, SHIFT, 58}, {35, SHIFT, 59}, },
			{{-1, ERROR, 15}, {33, SHIFT, 60}, {35, SHIFT, 61}, },
			{{-1, ERROR, 16}, {33, SHIFT, 62}, {35, SHIFT, 63}, },
			{{-1, ERROR, 17}, {33, SHIFT, 64}, {35, SHIFT, 65}, },
			{{-1, ERROR, 18}, {33, SHIFT, 66}, {35, SHIFT, 67}, },
			{{-1, ERROR, 19}, {33, SHIFT, 68}, {35, SHIFT, 69}, },
			{{-1, ERROR, 20}, {33, SHIFT, 70}, {35, SHIFT, 71}, },
			{{-1, ERROR, 21}, {33, SHIFT, 72}, {35, SHIFT, 73}, },
			{{-1, ERROR, 22}, {33, SHIFT, 74}, {35, SHIFT, 75}, },
			{{-1, ERROR, 23}, {33, SHIFT, 76}, {35, SHIFT, 77}, },
			{{-1, ERROR, 24}, {33, SHIFT, 78}, {35, SHIFT, 79}, },
			{{-1, ERROR, 25}, {33, SHIFT, 80}, {35, SHIFT, 81}, },
			{{-1, ERROR, 26}, {33, SHIFT, 82}, {35, SHIFT, 83}, },
			{{-1, ERROR, 27}, {34, SHIFT, 84}, {35, SHIFT, 85}, },
			{{-1, ERROR, 28}, {37, SHIFT, 86}, },
			{{-1, ERROR, 29}, {33, SHIFT, 87}, {35, SHIFT, 88}, },
			{{-1, REDUCE, 30}, {29, SHIFT, 89}, },
			{{-1, ERROR, 31}, {33, SHIFT, 90}, {35, SHIFT, 91}, {37, SHIFT, 92}, },
			{{-1, ERROR, 32}, {5, SHIFT, 93}, {7, SHIFT, 14}, {10, SHIFT, 15}, {11, SHIFT, 16}, {12, SHIFT, 17}, {13, SHIFT, 18}, {14, SHIFT, 19}, {15, SHIFT, 20}, {16, SHIFT, 21}, {17, SHIFT, 22}, {18, SHIFT, 23}, {19, SHIFT, 24}, {20, SHIFT, 25}, {21, SHIFT, 26}, {22, SHIFT, 27}, {23, SHIFT, 28}, {24, SHIFT, 29}, {26, SHIFT, 30}, {32, SHIFT, 31}, },
			{{-1, REDUCE, 23}, },
			{{-1, ERROR, 34}, {2, SHIFT, 32}, {36, SHIFT, 2}, },
			{{-1, ERROR, 35}, {4, SHIFT, 95}, },
			{{-1, REDUCE, 78}, },
			{{-1, ERROR, 37}, {5, SHIFT, 96}, {7, SHIFT, 14}, {10, SHIFT, 15}, {11, SHIFT, 16}, {12, SHIFT, 17}, {13, SHIFT, 18}, {14, SHIFT, 19}, {15, SHIFT, 20}, {16, SHIFT, 21}, {17, SHIFT, 22}, {18, SHIFT, 23}, {19, SHIFT, 24}, {20, SHIFT, 25}, {21, SHIFT, 26}, {22, SHIFT, 27}, {23, SHIFT, 28}, {24, SHIFT, 29}, {26, SHIFT, 30}, {32, SHIFT, 31}, },
			{{-1, REDUCE, 25}, },
			{{-1, ERROR, 39}, {2, SHIFT, 37}, {36, SHIFT, 2}, },
			{{-1, ERROR, 40}, {5, SHIFT, 98}, {7, SHIFT, 14}, {10, SHIFT, 15}, {11, SHIFT, 16}, {12, SHIFT, 17}, {13, SHIFT, 18}, {14, SHIFT, 19}, {15, SHIFT, 20}, {16, SHIFT, 21}, {17, SHIFT, 22}, {18, SHIFT, 23}, {19, SHIFT, 24}, {20, SHIFT, 25}, {21, SHIFT, 26}, {22, SHIFT, 27}, {23, SHIFT, 28}, {24, SHIFT, 29}, {26, SHIFT, 30}, {32, SHIFT, 31}, },
			{{-1, REDUCE, 61}, },
			{{-1, ERROR, 42}, {2, SHIFT, 40}, {36, SHIFT, 2}, },
			{{-1, ERROR, 43}, {5, SHIFT, 12}, {7, SHIFT, 14}, {8, SHIFT, 100}, {9, SHIFT, 101}, {10, SHIFT, 15}, {11, SHIFT, 16}, {12, SHIFT, 17}, {13, SHIFT, 18}, {14, SHIFT, 19}, {15, SHIFT, 20}, {16, SHIFT, 21}, {17, SHIFT, 22}, {18, SHIFT, 23}, {19, SHIFT, 24}, {20, SHIFT, 25}, {21, SHIFT, 26}, {22, SHIFT, 27}, {23, SHIFT, 28}, {24, SHIFT, 29}, {25, SHIFT, 102}, {26, SHIFT, 30}, {32, SHIFT, 31}, },
			{{-1, ERROR, 44}, {2, SHIFT, 103}, {36, SHIFT, 2}, },
			{{-1, ERROR, 45}, {2, SHIFT, 106}, },
			{{-1, ERROR, 46}, {2, SHIFT, 108}, {36, SHIFT, 2}, },
			{{-1, ERROR, 47}, {2, SHIFT, 108}, {36, SHIFT, 2}, },
			{{-1, ERROR, 48}, {2, SHIFT, 103}, {36, SHIFT, 2}, },
			{{-1, ERROR, 49}, {2, SHIFT, 103}, {36, SHIFT, 2}, },
			{{-1, REDUCE, 2}, },
			{{-1, ERROR, 51}, {2, SHIFT, 43}, {36, SHIFT, 2}, },
			{{-1, ERROR, 52}, {35, SHIFT, 120}, },
			{{-1, ERROR, 53}, {35, SHIFT, 121}, },
			{{-1, ERROR, 54}, {35, SHIFT, 122}, },
			{{-1, ERROR, 55}, {37, SHIFT, 123}, },
			{{-1, ERROR, 56}, {35, SHIFT, 124}, },
			{{-1, REDUCE, 88}, },
			{{-1, ERROR, 58}, {35, SHIFT, 125}, },
			{{-1, REDUCE, 47}, },
			{{-1, ERROR, 60}, {35, SHIFT, 126}, },
			{{-1, REDUCE, 36}, },
			{{-1, ERROR, 62}, {35, SHIFT, 127}, },
			{{-1, REDUCE, 43}, },
			{{-1, ERROR, 64}, {35, SHIFT, 128}, },
			{{-1, REDUCE, 59}, },
			{{-1, ERROR, 66}, {35, SHIFT, 129}, },
			{{-1, REDUCE, 41}, },
			{{-1, ERROR, 68}, {35, SHIFT, 130}, },
			{{-1, REDUCE, 28}, },
			{{-1, ERROR, 70}, {35, SHIFT, 131}, },
			{{-1, REDUCE, 53}, },
			{{-1, ERROR, 72}, {35, SHIFT, 132}, },
			{{-1, REDUCE, 56}, },
			{{-1, ERROR, 74}, {35, SHIFT, 133}, },
			{{-1, REDUCE, 45}, },
			{{-1, ERROR, 76}, {35, SHIFT, 134}, },
			{{-1, REDUCE, 50}, },
			{{-1, ERROR, 78}, {35, SHIFT, 135}, },
			{{-1, REDUCE, 32}, },
			{{-1, ERROR, 80}, {35, SHIFT, 136}, },
			{{-1, REDUCE, 80}, },
			{{-1, ERROR, 82}, {35, SHIFT, 137}, },
			{{-1, REDUCE, 84}, },
			{{-1, ERROR, 84}, {35, SHIFT, 138}, },
			{{-1, REDUCE, 76}, },
			{{-1, ERROR, 86}, {33, SHIFT, 139}, {35, SHIFT, 140}, },
			{{-1, ERROR, 87}, {35, SHIFT, 141}, },
			{{-1, REDUCE, 34}, },
			{{-1, REDUCE, 31}, },
			{{-1, ERROR, 90}, {35, SHIFT, 142}, },
			{{-1, REDUCE, 66}, },
			{{-1, ERROR, 92}, {33, SHIFT, 143}, {35, SHIFT, 144}, },
			{{-1, ERROR, 93}, {13, SHIFT, 52}, {15, SHIFT, 53}, {18, SHIFT, 54}, {23, SHIFT, 55}, {32, SHIFT, 145}, },
			{{-1, REDUCE, 24}, },
			{{-1, REDUCE, 79}, },
			{{-1, ERROR, 96}, {13, SHIFT, 52}, {15, SHIFT, 53}, {18, SHIFT, 54}, {20, SHIFT, 146}, {23, SHIFT, 55}, },
			{{-1, REDUCE, 26}, },
			{{-1, ERROR, 98}, {13, SHIFT, 52}, {15, SHIFT, 53}, {18, SHIFT, 54}, {21, SHIFT, 147}, {23, SHIFT, 55}, },
			{{-1, REDUCE, 62}, },
			{{-1, ERROR, 100}, {33, SHIFT, 148}, {35, SHIFT, 149}, },
			{{-1, ERROR, 101}, {33, SHIFT, 150}, {35, SHIFT, 151}, },
			{{-1, ERROR, 102}, {33, SHIFT, 152}, {35, SHIFT, 153}, },
			{{-1, ERROR, 103}, {5, SHIFT, 12}, {7, SHIFT, 14}, {9, SHIFT, 101}, {10, SHIFT, 15}, {11, SHIFT, 16}, {12, SHIFT, 17}, {13, SHIFT, 18}, {14, SHIFT, 19}, {15, SHIFT, 20}, {16, SHIFT, 21}, {17, SHIFT, 22}, {18, SHIFT, 23}, {19, SHIFT, 24}, {20, SHIFT, 25}, {21, SHIFT, 26}, {22, SHIFT, 27}, {23, SHIFT, 28}, {24, SHIFT, 29}, {25, SHIFT, 102}, {26, SHIFT, 30}, {32, SHIFT, 31}, },
			{{-1, ERROR, 104}, {2, SHIFT, 106}, },
			{{-1, ERROR, 105}, {2, SHIFT, 103}, {36, SHIFT, 2}, },
			{{-1, ERROR, 106}, {5, SHIFT, 156}, },
			{{-1, REDUCE, 0}, {2, SHIFT, 157}, },
			{{-1, ERROR, 108}, {5, SHIFT, 12}, {7, SHIFT, 14}, {10, SHIFT, 15}, {11, SHIFT, 16}, {12, SHIFT, 17}, {13, SHIFT, 18}, {14, SHIFT, 19}, {15, SHIFT, 20}, {16, SHIFT, 21}, {17, SHIFT, 22}, {18, SHIFT, 23}, {19, SHIFT, 24}, {20, SHIFT, 25}, {21, SHIFT, 26}, {22, SHIFT, 27}, {23, SHIFT, 28}, {24, SHIFT, 29}, {26, SHIFT, 30}, {32, SHIFT, 31}, },
			{{-1, ERROR, 109}, {2, SHIFT, 159}, {36, SHIFT, 2}, },
			{{-1, ERROR, 110}, {2, SHIFT, 161}, {36, SHIFT, 2}, },
			{{-1, REDUCE, 64}, },
			{{-1, REDUCE, 22}, },
			{{-1, ERROR, 113}, {2, SHIFT, 108}, {36, SHIFT, 2}, },
			{{-1, ERROR, 114}, {2, SHIFT, 103}, {36, SHIFT, 2}, },
			{{-1, ERROR, 115}, {2, SHIFT, 165}, {36, SHIFT, 2}, },
			{{-1, ERROR, 116}, {2, SHIFT, 106}, },
			{{-1, ERROR, 117}, {2, SHIFT, 103}, {36, SHIFT, 2}, },
			{{-1, ERROR, 118}, {2, SHIFT, 106}, },
			{{-1, ERROR, 119}, {2, SHIFT, 103}, {36, SHIFT, 2}, },
			{{-1, REDUCE, 49}, },
			{{-1, REDUCE, 55}, },
			{{-1, REDUCE, 52}, },
			{{-1, ERROR, 123}, {35, SHIFT, 173}, },
			{{-1, REDUCE, 89}, },
			{{-1, REDUCE, 48}, },
			{{-1, REDUCE, 37}, },
			{{-1, REDUCE, 44}, },
			{{-1, REDUCE, 60}, },
			{{-1, REDUCE, 42}, },
			{{-1, REDUCE, 29}, },
			{{-1, REDUCE, 54}, },
			{{-1, REDUCE, 57}, },
			{{-1, REDUCE, 46}, },
			{{-1, REDUCE, 51}, },
			{{-1, REDUCE, 33}, },
			{{-1, REDUCE, 81}, },
			{{-1, REDUCE, 85}, },
			{{-1, REDUCE, 77}, },
			{{-1, ERROR, 139}, {35, SHIFT, 174}, },
			{{-1, REDUCE, 38}, },
			{{-1, REDUCE, 35}, },
			{{-1, REDUCE, 68}, },
			{{-1, ERROR, 143}, {35, SHIFT, 175}, },
			{{-1, REDUCE, 67}, },
			{{-1, ERROR, 145}, {33, SHIFT, 176}, {35, SHIFT, 177}, {37, SHIFT, 178}, },
			{{-1, ERROR, 146}, {33, SHIFT, 179}, {35, SHIFT, 180}, },
			{{-1, ERROR, 147}, {33, SHIFT, 181}, {35, SHIFT, 182}, },
			{{-1, ERROR, 148}, {35, SHIFT, 183}, },
			{{-1, REDUCE, 92}, },
			{{-1, ERROR, 150}, {35, SHIFT, 184}, },
			{{-1, REDUCE, 96}, },
			{{-1, ERROR, 152}, {35, SHIFT, 185}, },
			{{-1, REDUCE, 100}, },
			{{-1, REDUCE, 4}, {2, SHIFT, 157}, },
			{{-1, ERROR, 155}, {2, SHIFT, 106}, },
			{{-1, ERROR, 156}, {6, SHIFT, 188}, },
			{{-1, ERROR, 157}, {26, SHIFT, 189}, },
			{{-1, REDUCE, 10}, },
			{{-1, ERROR, 159}, {5, SHIFT, 190}, {7, SHIFT, 14}, {10, SHIFT, 15}, {11, SHIFT, 16}, {12, SHIFT, 17}, {13, SHIFT, 18}, {14, SHIFT, 19}, {15, SHIFT, 20}, {16, SHIFT, 21}, {17, SHIFT, 22}, {18, SHIFT, 23}, {19, SHIFT, 24}, {20, SHIFT, 25}, {21, SHIFT, 26}, {22, SHIFT, 27}, {23, SHIFT, 28}, {24, SHIFT, 29}, {26, SHIFT, 30}, {32, SHIFT, 31}, },
			{{-1, REDUCE, 18}, },
			{{-1, ERROR, 161}, {5, SHIFT, 191}, {7, SHIFT, 14}, {10, SHIFT, 15}, {11, SHIFT, 16}, {12, SHIFT, 17}, {13, SHIFT, 18}, {14, SHIFT, 19}, {15, SHIFT, 20}, {16, SHIFT, 21}, {17, SHIFT, 22}, {18, SHIFT, 23}, {19, SHIFT, 24}, {20, SHIFT, 25}, {21, SHIFT, 26}, {22, SHIFT, 27}, {23, SHIFT, 28}, {24, SHIFT, 29}, {26, SHIFT, 30}, {32, SHIFT, 31}, },
			{{-1, REDUCE, 19}, },
			{{-1, ERROR, 163}, {2, SHIFT, 161}, {36, SHIFT, 2}, },
			{{-1, ERROR, 164}, {2, SHIFT, 165}, {36, SHIFT, 2}, },
			{{-1, ERROR, 165}, {5, SHIFT, 194}, {7, SHIFT, 14}, {9, SHIFT, 101}, {10, SHIFT, 15}, {11, SHIFT, 16}, {12, SHIFT, 17}, {13, SHIFT, 18}, {14, SHIFT, 19}, {15, SHIFT, 20}, {16, SHIFT, 21}, {17, SHIFT, 22}, {18, SHIFT, 23}, {19, SHIFT, 24}, {20, SHIFT, 25}, {21, SHIFT, 26}, {22, SHIFT, 27}, {23, SHIFT, 28}, {24, SHIFT, 29}, {25, SHIFT, 102}, {26, SHIFT, 30}, {32, SHIFT, 31}, },
			{{-1, REDUCE, 21}, },
			{{-1, REDUCE, 20}, },
			{{-1, REDUCE, 6}, {2, SHIFT, 157}, },
			{{-1, ERROR, 169}, {2, SHIFT, 106}, },
			{{-1, ERROR, 170}, {2, SHIFT, 103}, {36, SHIFT, 2}, },
			{{-1, REDUCE, 1}, {2, SHIFT, 157}, },
			{{-1, ERROR, 172}, {2, SHIFT, 106}, },
			{{-1, REDUCE, 40}, },
			{{-1, REDUCE, 39}, },
			{{-1, REDUCE, 69}, },
			{{-1, ERROR, 176}, {35, SHIFT, 200}, },
			{{-1, REDUCE, 70}, },
			{{-1, ERROR, 178}, {33, SHIFT, 201}, {35, SHIFT, 202}, },
			{{-1, ERROR, 179}, {35, SHIFT, 203}, },
			{{-1, REDUCE, 82}, },
			{{-1, ERROR, 181}, {35, SHIFT, 204}, },
			{{-1, REDUCE, 86}, },
			{{-1, REDUCE, 93}, },
			{{-1, REDUCE, 97}, },
			{{-1, REDUCE, 101}, },
			{{-1, REDUCE, 12}, },
			{{-1, REDUCE, 8}, {2, SHIFT, 157}, },
			{{-1, ERROR, 188}, {33, SHIFT, 206}, {35, SHIFT, 207}, },
			{{-1, REDUCE, 74}, {29, SHIFT, 208}, },
			{{-1, ERROR, 190}, {8, SHIFT, 209}, {13, SHIFT, 52}, {15, SHIFT, 53}, {18, SHIFT, 54}, {23, SHIFT, 55}, },
			{{-1, ERROR, 191}, {9, SHIFT, 210}, {13, SHIFT, 52}, {15, SHIFT, 53}, {18, SHIFT, 54}, {23, SHIFT, 55}, },
			{{-1, REDUCE, 65}, },
			{{-1, REDUCE, 63}, },
			{{-1, ERROR, 194}, {13, SHIFT, 52}, {15, SHIFT, 53}, {18, SHIFT, 54}, {23, SHIFT, 55}, {25, SHIFT, 211}, },
			{{-1, REDUCE, 14}, },
			{{-1, REDUCE, 5}, {2, SHIFT, 157}, },
			{{-1, ERROR, 197}, {2, SHIFT, 106}, },
			{{-1, REDUCE, 11}, },
			{{-1, REDUCE, 7}, {2, SHIFT, 157}, },
			{{-1, REDUCE, 72}, },
			{{-1, ERROR, 201}, {35, SHIFT, 215}, },
			{{-1, REDUCE, 71}, },
			{{-1, REDUCE, 83}, },
			{{-1, REDUCE, 87}, },
			{{-1, REDUCE, 16}, },
			{{-1, ERROR, 206}, {35, SHIFT, 216}, },
			{{-1, REDUCE, 90}, },
			{{-1, REDUCE, 75}, },
			{{-1, ERROR, 209}, {33, SHIFT, 217}, {35, SHIFT, 218}, },
			{{-1, ERROR, 210}, {33, SHIFT, 219}, {35, SHIFT, 220}, },
			{{-1, ERROR, 211}, {33, SHIFT, 221}, {35, SHIFT, 222}, },
			{{-1, REDUCE, 13}, },
			{{-1, REDUCE, 9}, {2, SHIFT, 157}, },
			{{-1, REDUCE, 15}, },
			{{-1, REDUCE, 73}, },
			{{-1, REDUCE, 91}, },
			{{-1, ERROR, 217}, {35, SHIFT, 224}, },
			{{-1, REDUCE, 94}, },
			{{-1, ERROR, 219}, {35, SHIFT, 225}, },
			{{-1, REDUCE, 98}, },
			{{-1, ERROR, 221}, {35, SHIFT, 226}, },
			{{-1, REDUCE, 102}, },
			{{-1, REDUCE, 17}, },
			{{-1, REDUCE, 95}, },
			{{-1, REDUCE, 99}, },
			{{-1, REDUCE, 103}, },
        };*/
    private static int[][][] gotoTable;
/*      {
			{{-1, 3}, },
			{{-1, 44}, {51, 117}, },
			{{-1, 45}, {44, 104}, {49, 116}, {51, 118}, {105, 155}, {117, 169}, {119, 172}, {170, 197}, },
			{{-1, 4}, {11, 50}, {34, 50}, {39, 50}, {42, 50}, {48, 111}, {49, 50}, {105, 50}, {109, 50}, {110, 50}, {114, 111}, {115, 111}, {119, 50}, {163, 50}, {164, 111}, {170, 50}, },
			{{-1, 112}, {115, 166}, {164, 166}, },
			{{-1, 5}, },
			{{-1, 33}, {34, 94}, },
			{{-1, 158}, {154, 186}, {168, 195}, {171, 198}, {187, 205}, {196, 212}, {199, 214}, {213, 223}, },
			{{-1, 6}, },
			{{-1, 7}, },
			{{-1, 8}, },
			{{-1, 38}, {39, 97}, },
			{{-1, 9}, },
			{{-1, 41}, {42, 99}, },
			{{-1, 10}, {11, 51}, },
			{{-1, 107}, {104, 154}, {116, 168}, {118, 171}, {155, 187}, {169, 196}, {172, 199}, {197, 213}, },
			{{-1, 46}, },
			{{-1, 160}, },
			{{-1, 47}, {48, 113}, {114, 113}, {115, 113}, {164, 113}, },
			{{-1, 162}, {163, 192}, },
			{{-1, 48}, {48, 114}, {114, 114}, {115, 114}, {164, 114}, },
			{{-1, 167}, {164, 193}, },
			{{-1, 11}, {5, 34}, {8, 39}, {9, 42}, {10, 49}, {44, 105}, {46, 109}, {47, 110}, {51, 119}, {113, 163}, {117, 170}, },
			{{-1, 115}, {114, 164}, },
        };*/
    protected static String[] errorMessages;
/*      {
			"TOpen TWord expected.",
			"TSlash THtml TMeta TArea TBase TBr TP TImg TOption TInput TDt TLi THr TUl TOl TScript TH TFrame TCom TTag expected.",
			"EOF expected.",
			"TSctext TEscript expected.",
			"TP TOption TLi TH expected.",
			"TTb TClose expected.",
			"TTb2 TClose expected.",
			"TNumber expected.",
			"TOpen TCs TWord expected.",
			"TTb TClose TNumber expected.",
			"TSlash TMeta TArea TBase TBr TP TImg TOption TInput TDt TLi THr TUl TOl TScript TH TFrame TCom TTag expected.",
			"TEscript expected.",
			"TSlash TMeta THead TBody TArea TBase TBr TP TImg TOption TInput TDt TLi THr TUl TOl TScript TH TFrame TFrameset TCom TTag expected.",
			"TOpen expected.",
			"TClose expected.",
			"TP TOption TLi TH TTag expected.",
			"TP TOption TLi TUl TH expected.",
			"TP TOption TLi TOl TH expected.",
			"TSlash TMeta TBody TArea TBase TBr TP TImg TOption TInput TDt TLi THr TUl TOl TScript TH TFrame TFrameset TCom TTag expected.",
			"TSlash expected.",
			"TOpen EOF expected.",
			"THtml expected.",
			"TCom expected.",
			"TCs EOF expected.",
			"THead TP TOption TLi TH expected.",
			"TBody TP TOption TLi TH expected.",
			"TP TOption TLi TH TFrameset expected.",
        };*/
    private static int[] errors;
/*      {
			0, 1, 0, 2, 0, 0, 3, 0, 0, 0, 0, 0, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 7, 5, 8, 9, 10, 0, 0, 11, 0, 10, 0, 0, 10, 0, 0, 12, 0, 13, 0, 0, 0, 0, 0, 0, 14, 14, 14, 7, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 3, 5, 14, 0, 0, 14, 0, 5, 15, 0, 0, 16, 0, 17, 0, 5, 5, 5, 18, 13, 0, 19, 20, 10, 0, 0, 0, 0, 0, 0, 0, 13, 0, 13, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 14, 0, 0, 0, 14, 0, 9, 5, 5, 14, 0, 14, 0, 14, 0, 20, 13, 21, 22, 2, 10, 0, 10, 13, 0, 0, 18, 0, 13, 20, 13, 0, 20, 13, 0, 0, 0, 14, 0, 5, 14, 0, 14, 0, 0, 0, 0, 2, 20, 5, 23, 24, 25, 0, 0, 26, 2, 20, 13, 2, 20, 0, 14, 0, 0, 0, 2, 14, 20, 2, 5, 5, 5, 2, 20, 2, 0, 20, 14, 0, 14, 0, 14, 0, 2, 0, 0, 0, 
        };*/
}
